/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.avro.input;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.AliasedFileObject;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.avro.AvroSpec;
import org.pentaho.di.trans.steps.avro.AvroTypeConverter;
import org.pentaho.di.trans.steps.avro.input.AvroInputField;
import org.pentaho.di.trans.steps.avro.input.AvroLookupField;
import org.pentaho.di.trans.steps.avro.input.BaseFormatInputField;
import org.pentaho.di.workarounds.ResolvableResource;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public abstract class AvroInputMetaBase
extends BaseStepMeta
implements StepMetaInterface,
ResolvableResource {
    public static final Class<?> PKG = AvroInputMetaBase.class;
    @Injection(name="DATA_LOCATION")
    private String dataLocation;
    @Injection(name="DATA_LOCATION_TYPE")
    @VisibleForTesting
    public int dataLocationType = LocationDescriptor.FILE_NAME.ordinal();
    @Injection(name="SCHEMA_LOCATION")
    private String schemaLocation;
    @Injection(name="SCHEMA_LOCATION_TYPE")
    private int schemaLocationType = LocationDescriptor.FILE_NAME.ordinal();
    private boolean isCacheSchemas;
    @Injection(name="ALLOW_NULL_FOR_MISSING_FIELDS")
    private boolean allowNullForMissingFields;
    @Injection(name="PASS_THROUGH_FIELDS")
    public boolean passingThruFields;
    @Injection(name="DATA_FORMAT")
    private int format;
    @InjectionDeep
    public AvroInputField[] inputFields = new AvroInputField[0];
    @InjectionDeep
    private List<AvroLookupField> lookupFields = new ArrayList<AvroLookupField>();

    public List<AvroLookupField> getLookupFields() {
        return this.lookupFields;
    }

    public void setLookupFields(List<AvroLookupField> lookupFields) {
        this.lookupFields = lookupFields;
    }

    public String getDataLocation() {
        return this.dataLocation;
    }

    public void setDataLocation(String dataLocation, LocationDescriptor locationDescriptor) {
        this.dataLocation = dataLocation;
        this.dataLocationType = locationDescriptor.ordinal();
    }

    public LocationDescriptor getDataLocationType() {
        return LocationDescriptor.values()[this.dataLocationType];
    }

    public void setFormat(int formatIndex) {
        this.format = formatIndex;
    }

    public int getFormat() {
        return this.format;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation, LocationDescriptor locationDescriptor) {
        this.schemaLocation = schemaLocation;
        this.schemaLocationType = locationDescriptor.ordinal();
    }

    public void setDefault() {
    }

    public LocationDescriptor getSchemaLocationType() {
        return LocationDescriptor.values()[this.schemaLocationType];
    }

    public boolean isCacheSchemas() {
        return this.isCacheSchemas;
    }

    public void setCacheSchemas(boolean cacheSchemas) {
        this.isCacheSchemas = cacheSchemas;
    }

    public boolean isAllowNullForMissingFields() {
        return this.allowNullForMissingFields;
    }

    public void setAllowNullForMissingFields(boolean allowNullForMissingFields) {
        this.allowNullForMissingFields = allowNullForMissingFields;
    }

    public String getEncoding() {
        return null;
    }

    public AvroInputField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(AvroInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    public void setInputFields(List<AvroInputField> inputFields) {
        this.inputFields = new AvroInputField[inputFields.size()];
        this.inputFields = inputFields.toArray(this.inputFields);
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, metaStore);
    }

    private void readData(Node stepnode, IMetaStore metastore) throws KettleXMLException {
        try {
            Node fnode;
            int i;
            String passFileds = XMLHandler.getTagValue((Node)stepnode, (String)"passing_through_fields") == null ? "false" : XMLHandler.getTagValue((Node)stepnode, (String)"passing_through_fields");
            this.passingThruFields = ValueMetaBase.convertStringToBoolean((String)passFileds);
            this.dataLocation = XMLHandler.getTagValue((Node)stepnode, (String)"dataLocation") == null ? XMLHandler.getTagValue((Node)stepnode, (String)"fileName") : XMLHandler.getTagValue((Node)stepnode, (String)"dataLocation");
            this.format = XMLHandler.getTagValue((Node)stepnode, (String)"sourceFormat") == null ? LocationDescriptor.FILE_NAME.ordinal() : Integer.parseInt(XMLHandler.getTagValue((Node)stepnode, (String)"sourceFormat"));
            this.dataLocationType = XMLHandler.getTagValue((Node)stepnode, (String)"dataLocationType") == null ? LocationDescriptor.FILE_NAME.ordinal() : Integer.parseInt(XMLHandler.getTagValue((Node)stepnode, (String)"dataLocationType"));
            this.schemaLocation = XMLHandler.getTagValue((Node)stepnode, (String)"schemaLocation");
            this.schemaLocationType = XMLHandler.getTagValue((Node)stepnode, (String)"schemaLocationType") == null ? LocationDescriptor.FILE_NAME.ordinal() : Integer.parseInt(XMLHandler.getTagValue((Node)stepnode, (String)"schemaLocationType"));
            this.isCacheSchemas = ValueMetaBase.convertStringToBoolean((String)(XMLHandler.getTagValue((Node)stepnode, (String)"isCacheSchemas") == null ? "false" : XMLHandler.getTagValue((Node)stepnode, (String)"isCacheSchemas")));
            this.allowNullForMissingFields = ValueMetaBase.convertStringToBoolean((String)(XMLHandler.getTagValue((Node)stepnode, (String)"allowNullForMissingFields") == null ? "false" : XMLHandler.getTagValue((Node)stepnode, (String)"allowNullForMissingFields")));
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.inputFields = new AvroInputField[nrfields];
            for (i = 0; i < nrfields; ++i) {
                fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                AvroInputField inputField = new AvroInputField();
                inputField.setFormatFieldName(XMLHandler.getTagValue((Node)fnode, (String)"path"));
                inputField.setPentahoFieldName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
                inputField.setPentahoType(XMLHandler.getTagValue((Node)fnode, (String)"type"));
                String avroType = XMLHandler.getTagValue((Node)fnode, (String)"avro_type");
                if (avroType != null && !avroType.equalsIgnoreCase("null")) {
                    inputField.setAvroType(avroType);
                } else {
                    inputField.setAvroType(AvroTypeConverter.convertToAvroType(inputField.getPentahoType()));
                }
                String stringFormat = XMLHandler.getTagValue((Node)fnode, (String)"format");
                inputField.setStringFormat(stringFormat == null ? "" : stringFormat);
                String indexedValues = XMLHandler.getTagValue((Node)fnode, (String)"indexed_vals");
                if (indexedValues != null && indexedValues.length() > 0) {
                    inputField.setIndexedValues(indexedValues);
                }
                this.inputFields[i] = inputField;
            }
            fields = XMLHandler.getSubNode((Node)stepnode, (String)"lookupFields");
            nrfields = XMLHandler.countNodes((Node)fields, (String)"lookupField");
            this.lookupFields = new ArrayList<AvroLookupField>();
            for (i = 0; i < nrfields; ++i) {
                fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"lookupField", (int)i);
                AvroLookupField lookupField = new AvroLookupField();
                lookupField.setFieldName(XMLHandler.getTagValue((Node)fnode, (String)"fieldName"));
                lookupField.setVariableName(XMLHandler.getTagValue((Node)fnode, (String)"variableName"));
                lookupField.setDefaultValue(XMLHandler.getTagValue((Node)fnode, (String)"defaultValue"));
                this.lookupFields.add(lookupField);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public String getXML() {
        Object field;
        int i;
        StringBuffer retval = new StringBuffer(800);
        String INDENT = "    ";
        retval.append("    ").append(XMLHandler.addTagValue((String)"passing_through_fields", (boolean)this.passingThruFields));
        retval.append("    ").append(XMLHandler.addTagValue((String)"dataLocation", (String)this.getDataLocation()));
        this.parentStepMeta.getParentTransMeta().getNamedClusterEmbedManager().registerUrl(this.getDataLocation());
        retval.append("    ").append(XMLHandler.addTagValue((String)"sourceFormat", (int)this.getFormat()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"dataLocationType", (int)this.dataLocationType));
        retval.append("    ").append(XMLHandler.addTagValue((String)"schemaLocation", (String)this.getSchemaLocation()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"schemaLocationType", (int)this.schemaLocationType));
        retval.append("    ").append(XMLHandler.addTagValue((String)"isCacheSchemas", (boolean)this.isCacheSchemas()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"allowNullForMissingFields", (boolean)this.isAllowNullForMissingFields()));
        retval.append("    <fields>").append(Const.CR);
        for (i = 0; i < this.inputFields.length; ++i) {
            String indexedValues;
            field = this.inputFields[i];
            if (((BaseFormatInputField)field).getPentahoFieldName() == null || ((BaseFormatInputField)field).getPentahoFieldName().length() == 0) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"path", (String)((AvroInputField)field).getAvroFieldName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)((BaseFormatInputField)field).getPentahoFieldName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)field.getTypeDesc()));
            AvroSpec.DataType avroDataType = ((AvroInputField)field).getAvroType();
            if (avroDataType != null && !avroDataType.equals((Object)AvroSpec.DataType.NULL)) {
                retval.append("        ").append(XMLHandler.addTagValue((String)"avro_type", (String)avroDataType.getName()));
            } else {
                retval.append("        ").append(XMLHandler.addTagValue((String)"avro_type", (String)AvroTypeConverter.convertToAvroType(field.getTypeDesc())));
            }
            if (((BaseFormatInputField)field).getStringFormat() != null) {
                retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)((BaseFormatInputField)field).getStringFormat()));
            }
            if ((indexedValues = ((AvroInputField)field).getIndexedValues()) != null && indexedValues.length() > 0) {
                retval.append("        ").append(XMLHandler.addTagValue((String)"indexed_vals", (String)indexedValues));
            }
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append("    <lookupFields>").append(Const.CR);
        for (i = 0; i < this.lookupFields.size(); ++i) {
            field = this.lookupFields.get(i);
            if (((AvroLookupField)field).getFieldName() == null || ((AvroLookupField)field).getFieldName().length() == 0) continue;
            retval.append("      <lookupField>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"fieldName", (String)((AvroLookupField)field).getFieldName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"variableName", (String)((AvroLookupField)field).getVariableName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"defaultValue", (String)((AvroLookupField)field).getDefaultValue()));
            retval.append("      </lookupField>").append(Const.CR);
        }
        retval.append("    </lookupFields>").append(Const.CR);
        return retval.toString();
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int i;
            this.passingThruFields = rep.getStepAttributeBoolean(id_step, "passing_through_fields");
            this.dataLocation = rep.getStepAttributeString(id_step, "dataLocation");
            this.format = (int)rep.getStepAttributeInteger(id_step, "sourceFormat");
            this.dataLocationType = (int)rep.getStepAttributeInteger(id_step, "dataLocationType");
            this.schemaLocation = rep.getStepAttributeString(id_step, "schemaLocation");
            this.schemaLocationType = (int)rep.getStepAttributeInteger(id_step, "schemaLocationType");
            this.isCacheSchemas = rep.getStepAttributeBoolean(id_step, "isCacheSchemas");
            this.allowNullForMissingFields = rep.getStepAttributeBoolean(id_step, "allowNullForMissingFields");
            int nrfields = rep.countNrStepAttributes(id_step, "type");
            this.inputFields = new AvroInputField[nrfields];
            for (i = 0; i < nrfields; ++i) {
                AvroInputField inputField = new AvroInputField();
                inputField.setFormatFieldName(rep.getStepAttributeString(id_step, i, "path"));
                inputField.setPentahoFieldName(rep.getStepAttributeString(id_step, i, "name"));
                inputField.setPentahoType(rep.getStepAttributeString(id_step, i, "type"));
                String avroType = rep.getStepAttributeString(id_step, i, "avro_type");
                if (avroType != null && !avroType.equalsIgnoreCase("null")) {
                    inputField.setAvroType(avroType);
                } else {
                    inputField.setAvroType(AvroTypeConverter.convertToAvroType(inputField.getPentahoType()));
                }
                String stringFormat = rep.getStepAttributeString(id_step, i, "format");
                inputField.setStringFormat(stringFormat == null ? "" : stringFormat);
                String indexedValues = rep.getStepAttributeString(id_step, i, "indexed_vals");
                if (indexedValues != null && indexedValues.length() > 0) {
                    inputField.setIndexedValues(indexedValues);
                }
                this.inputFields[i] = inputField;
            }
            nrfields = rep.countNrStepAttributes(id_step, "fieldName");
            this.lookupFields = new ArrayList<AvroLookupField>();
            for (i = 0; i < nrfields; ++i) {
                AvroLookupField lookupField = new AvroLookupField();
                lookupField.setFieldName(rep.getStepAttributeString(id_step, i, "fieldName"));
                lookupField.setVariableName(rep.getStepAttributeString(id_step, i, "variableName"));
                lookupField.setDefaultValue(rep.getStepAttributeString(id_step, i, "defaultValue"));
                this.lookupFields.add(lookupField);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            Object field;
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "passing_through_fields", this.passingThruFields);
            rep.saveStepAttribute(id_transformation, id_step, "dataLocation", this.getDataLocation());
            rep.saveStepAttribute(id_transformation, id_step, "sourceFormat", (long)this.getFormat());
            rep.saveStepAttribute(id_transformation, id_step, "dataLocationType", (long)this.dataLocationType);
            rep.saveStepAttribute(id_transformation, id_step, "schemaLocation", this.getSchemaLocation());
            rep.saveStepAttribute(id_transformation, id_step, "schemaLocationType", (long)this.schemaLocationType);
            rep.saveStepAttribute(id_transformation, id_step, "isCacheSchemas", this.isCacheSchemas());
            rep.saveStepAttribute(id_transformation, id_step, "allowNullForMissingFields", this.isAllowNullForMissingFields());
            for (i = 0; i < this.inputFields.length; ++i) {
                String indexedValues;
                field = this.inputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, i, "path", ((AvroInputField)field).getAvroFieldName());
                rep.saveStepAttribute(id_transformation, id_step, i, "name", ((BaseFormatInputField)field).getPentahoFieldName());
                rep.saveStepAttribute(id_transformation, id_step, i, "type", field.getTypeDesc());
                AvroSpec.DataType avroDataType = ((AvroInputField)field).getAvroType();
                if (avroDataType != null && !avroDataType.equals((Object)AvroSpec.DataType.NULL)) {
                    rep.saveStepAttribute(id_transformation, id_step, i, "avro_type", avroDataType.getName());
                } else {
                    rep.saveStepAttribute(id_transformation, id_step, i, "avro_type", AvroTypeConverter.convertToAvroType(field.getTypeDesc()));
                }
                if (((BaseFormatInputField)field).getStringFormat() != null) {
                    rep.saveStepAttribute(id_transformation, id_step, i, "format", ((BaseFormatInputField)field).getStringFormat());
                }
                if ((indexedValues = ((AvroInputField)field).getIndexedValues()) == null || indexedValues.length() <= 0) continue;
                rep.saveStepAttribute(id_transformation, id_step, i, "indexed_vals", indexedValues);
            }
            for (i = 0; i < this.lookupFields.size(); ++i) {
                field = this.lookupFields.get(i);
                rep.saveStepAttribute(id_transformation, id_step, i, "fieldName", ((AvroLookupField)field).getFieldName());
                rep.saveStepAttribute(id_transformation, id_step, i, "variableName", ((AvroLookupField)field).getVariableName());
                rep.saveStepAttribute(id_transformation, id_step, i, "defaultValue", ((AvroLookupField)field).getDefaultValue());
            }
            super.saveRep(rep, metaStore, id_transformation, id_step);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        try {
            if (!this.passingThruFields) {
                rowMeta.clear();
            } else if (info != null) {
                boolean found = false;
                for (int i = 0; i < info.length && !found; ++i) {
                    if (info[i] == null) continue;
                    rowMeta.mergeRowMeta(info[i], origin);
                    found = true;
                }
            }
            for (int i = 0; i < this.inputFields.length; ++i) {
                AvroInputField field = this.inputFields[i];
                String value = space.environmentSubstitute(field.getPentahoFieldName());
                ValueMetaInterface v = ValueMetaFactory.createValueMeta((String)value, (int)field.getPentahoType());
                v.setOrigin(origin);
                rowMeta.addValueMeta(v);
            }
        }
        catch (KettlePluginException e) {
            throw new KettleStepException("Unable to create value type", (Throwable)e);
        }
    }

    public void resolve() {
        FileObject fileObject;
        if (this.dataLocation != null && !this.dataLocation.isEmpty()) {
            try {
                String realFileName = this.getParentStepMeta().getParentTransMeta().environmentSubstitute(this.dataLocation);
                fileObject = KettleVFS.getFileObject((String)realFileName);
                if (AliasedFileObject.isAliasedFile((FileObject)fileObject)) {
                    this.dataLocation = ((AliasedFileObject)fileObject).getAELSafeURIString();
                }
            }
            catch (KettleFileException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.schemaLocation != null && !this.schemaLocation.isEmpty()) {
            try {
                String realSchemaFilename = this.getParentStepMeta().getParentTransMeta().environmentSubstitute(this.schemaLocation);
                fileObject = KettleVFS.getFileObject((String)realSchemaFilename);
                if (AliasedFileObject.isAliasedFile((FileObject)fileObject)) {
                    this.schemaLocation = ((AliasedFileObject)fileObject).getAELSafeURIString();
                }
            }
            catch (KettleFileException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Injection(name="AVRO_FILENAME")
    @Deprecated
    public void setDataFileName(String fileName) {
        this.setDataLocation(fileName, LocationDescriptor.FILE_NAME);
        this.setFormat(SourceFormat.AVRO_USE_SCHEMA.ordinal());
    }

    @Injection(name="STREAM_FIELDNAME")
    @Deprecated
    public void setDataFieldName(String fieldName) {
        this.setDataLocation(fieldName, LocationDescriptor.FIELD_NAME);
        this.setFormat(SourceFormat.AVRO_USE_SCHEMA.ordinal());
    }

    @Injection(name="SCHEMA_FILENAME")
    @Deprecated
    public void setSchemaFileName(String fileName) {
        this.setSchemaLocation(fileName, LocationDescriptor.FILE_NAME);
    }

    public static enum SourceFormat {
        AVRO_USE_SCHEMA,
        DATUM_JSON,
        DATUM_BINARY,
        AVRO_ALT_SCHEMA;

        public static final SourceFormat[] values;

        static {
            values = SourceFormat.values();
        }
    }

    public static enum LocationDescriptor {
        FILE_NAME,
        FIELD_NAME,
        FIELD_CONTAINING_FILE_NAME;

    }
}

