/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.avro;

import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.trans.steps.avro.AvroSpec;

public class AvroTypeConverter {
    public static String convertToAvroType(int pdiType) {
        switch (pdiType) {
            case 2: 
            case 10: {
                return AvroSpec.DataType.STRING.getName();
            }
            case 9: {
                return AvroSpec.DataType.TIMESTAMP_MILLIS.getName();
            }
            case 8: {
                return AvroSpec.DataType.BYTES.getName();
            }
            case 6: {
                return AvroSpec.DataType.DECIMAL.getName();
            }
            case 4: {
                return AvroSpec.DataType.BOOLEAN.getName();
            }
            case 3: {
                return AvroSpec.DataType.DATE.getName();
            }
            case 5: {
                return AvroSpec.DataType.LONG.getName();
            }
            case 1: {
                return AvroSpec.DataType.DOUBLE.getName();
            }
        }
        return AvroSpec.DataType.NULL.getName();
    }

    public static String convertToAvroType(String type) {
        int pdiType = ValueMetaFactory.getIdForValueMeta((String)type);
        if (pdiType > 0) {
            return AvroTypeConverter.convertToAvroType(pdiType);
        }
        return type;
    }
}

