/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mongo.wrapper.collection;

import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pentaho.mongo.MongoDbException;
import org.pentaho.mongo.wrapper.collection.MongoCollectionWrapper;
import org.pentaho.mongo.wrapper.cursor.DefaultCursorWrapper;
import org.pentaho.mongo.wrapper.cursor.MongoCursorWrapper;

public class DefaultMongoCollectionWrapper
implements MongoCollectionWrapper {
    private final DBCollection collection;

    public DefaultMongoCollectionWrapper(DBCollection collection) {
        this.collection = collection;
    }

    @Override
    public MongoCursorWrapper find(DBObject dbObject, DBObject dbObject2) throws MongoDbException {
        return this.wrap(this.collection.find(dbObject, dbObject2));
    }

    @Override
    public Cursor aggregate(List<? extends DBObject> pipeline, AggregationOptions options) {
        return this.collection.aggregate(pipeline, options);
    }

    @Override
    public Cursor aggregate(DBObject firstP, DBObject[] remainder, boolean allowDiskUse) {
        AggregationOptions options = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(allowDiskUse)).build();
        ArrayList<DBObject> pipeline = new ArrayList<DBObject>();
        pipeline.add(firstP);
        Collections.addAll(pipeline, remainder);
        return this.aggregate(pipeline, options);
    }

    @Override
    public MongoCursorWrapper find() throws MongoDbException {
        return this.wrap(this.collection.find());
    }

    @Override
    public void drop() throws MongoDbException {
        this.collection.drop();
    }

    @Override
    public WriteResult update(DBObject updateQuery, DBObject insertUpdate, boolean upsert, boolean multi) throws MongoDbException {
        return this.collection.update(updateQuery, insertUpdate, upsert, multi);
    }

    @Override
    public WriteResult insert(List<DBObject> m_batch) throws MongoDbException {
        return this.collection.insert(m_batch);
    }

    @Override
    public MongoCursorWrapper find(DBObject query) throws MongoDbException {
        return this.wrap(this.collection.find(query));
    }

    @Override
    public void dropIndex(BasicDBObject mongoIndex) throws MongoDbException {
        this.collection.dropIndex((DBObject)mongoIndex);
    }

    @Override
    public void createIndex(BasicDBObject mongoIndex) throws MongoDbException {
        this.collection.createIndex((DBObject)mongoIndex);
    }

    @Override
    public void createIndex(BasicDBObject mongoIndex, BasicDBObject options) throws MongoDbException {
        this.collection.createIndex((DBObject)mongoIndex, (DBObject)options);
    }

    @Override
    public WriteResult remove() throws MongoDbException {
        return this.remove((DBObject)new BasicDBObject());
    }

    @Override
    public WriteResult remove(DBObject query) throws MongoDbException {
        return this.collection.remove(query);
    }

    @Override
    public WriteResult save(DBObject toTry) throws MongoDbException {
        return this.collection.save(toTry);
    }

    @Override
    public long count() throws MongoDbException {
        return this.collection.count();
    }

    @Override
    public List distinct(String key) throws MongoDbException {
        return this.collection.distinct(key);
    }

    protected MongoCursorWrapper wrap(DBCursor cursor) {
        return new DefaultCursorWrapper(cursor);
    }
}

