/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mongo.wrapper;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.pentaho.mongo.BaseMessages;
import org.pentaho.mongo.MongoDbException;
import org.pentaho.mongo.MongoProp;
import org.pentaho.mongo.MongoProperties;
import org.pentaho.mongo.MongoUtilLogger;
import org.pentaho.mongo.Util;
import org.pentaho.mongo.wrapper.ConnectionStringMongoClientWrapper;
import org.pentaho.mongo.wrapper.KerberosConnectionStringMongoClientWrapper;
import org.pentaho.mongo.wrapper.KerberosInvocationHandler;
import org.pentaho.mongo.wrapper.KerberosMongoClientWrapper;
import org.pentaho.mongo.wrapper.MongoClientWrapper;
import org.pentaho.mongo.wrapper.NoAuthMongoClientWrapper;
import org.pentaho.mongo.wrapper.UsernamePasswordMongoClientWrapper;

public class MongoClientWrapperFactory {
    private static Class<?> PKG = MongoClientWrapperFactory.class;

    public static MongoClientWrapper createMongoClientWrapper(MongoProperties props, MongoUtilLogger log) throws MongoDbException {
        if (props.useKerberos()) {
            return MongoClientWrapperFactory.initKerberosProxy(new KerberosMongoClientWrapper(props, log));
        }
        if (!(Util.isEmpty(props.get(MongoProp.USERNAME)) && Util.isEmpty(props.get(MongoProp.PASSWORD)) && Util.isEmpty(props.get(MongoProp.AUTH_DATABASE)))) {
            return new UsernamePasswordMongoClientWrapper(props, log);
        }
        return new NoAuthMongoClientWrapper(props, log);
    }

    public static MongoClientWrapper createConnectionStringMongoClientWrapper(String connectionString, MongoUtilLogger log) throws MongoDbException {
        if (connectionString == null || connectionString.isEmpty()) {
            throw new MongoDbException(BaseMessages.getString(PKG, "MongoConnectionStringWrapper.ErrorMessage.EmptyConnectionString"));
        }
        if (connectionString.toLowerCase().contains("authmechanism=gssapi")) {
            return MongoClientWrapperFactory.initConnectionStringKerberosProxy(new KerberosConnectionStringMongoClientWrapper(connectionString, log));
        }
        return new ConnectionStringMongoClientWrapper(connectionString, log);
    }

    private static MongoClientWrapper initKerberosProxy(KerberosMongoClientWrapper wrapper) {
        return (MongoClientWrapper)Proxy.newProxyInstance(wrapper.getClass().getClassLoader(), new Class[]{MongoClientWrapper.class}, (InvocationHandler)new KerberosInvocationHandler(wrapper.getAuthContext(), wrapper));
    }

    private static MongoClientWrapper initConnectionStringKerberosProxy(KerberosConnectionStringMongoClientWrapper wrapper) {
        return (MongoClientWrapper)Proxy.newProxyInstance(wrapper.getClass().getClassLoader(), new Class[]{MongoClientWrapper.class}, (InvocationHandler)new KerberosInvocationHandler(wrapper.getAuthContext(), wrapper));
    }
}

