/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swing.tags;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulDomException;
import org.pentaho.ui.xul.containers.XulHbox;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swing.AbstractSwingContainer;
import org.pentaho.ui.xul.swing.ScrollablePanel;
import org.pentaho.ui.xul.swing.tags.SwingImage;
import org.pentaho.ui.xul.util.Orient;

public class SwingHbox
extends AbstractSwingContainer
implements XulHbox {
    private static final Log logger = LogFactory.getLog(SwingHbox.class);
    private String background;
    private XulDomContainer domContainer;

    public SwingHbox(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("Hbox");
        this.domContainer = domContainer;
        this.container = new ScrollablePanel(new GridBagLayout());
        this.container.setOpaque(false);
        this.setManagedObject(this.container);
        this.setPadding(2);
        this.resetContainer();
    }

    @Override
    public void removeChild(Element ele) {
        super.removeChild(ele);
        if (this.initialized) {
            this.resetContainer();
            this.layout();
        }
    }

    @Override
    public void resetContainer() {
        this.container.removeAll();
        this.gc = new GridBagConstraints();
        this.gc.gridx = -1;
        this.gc.gridy = 0;
        this.gc.gridheight = 0;
        this.gc.gridwidth = 1;
        int pad = this.getPadding();
        this.gc.insets = new Insets(pad, pad, pad, pad);
        this.gc.fill = 2;
        this.gc.anchor = 18;
        this.gc.weighty = 1.0;
    }

    @Override
    public Orient getOrientation() {
        return Orient.HORIZONTAL;
    }

    @Override
    public void replaceChild(XulComponent oldElement, XulComponent newElement) throws XulDomException {
        this.resetContainer();
        super.replaceChild(oldElement, newElement);
    }

    @Override
    public void layout() {
        this.resetContainer();
        if (this.getBgcolor() != null) {
            this.container.setOpaque(true);
            this.container.setBackground(Color.decode(this.getBgcolor()));
        }
        super.layout();
    }

    public String getBackground() {
        return this.background;
    }

    public void setBackground(String src) {
        this.background = src;
        URL url = SwingImage.class.getClassLoader().getResource(this.domContainer.getXulLoader().getRootDir() + src);
        if (url == null) {
            try {
                url = new File(src).toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (url == null) {
            logger.error((Object)("Could not find resource: " + src));
            return;
        }
        final ImageIcon ico = new ImageIcon(url);
        this.container.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent arg0) {
            }

            @Override
            public void componentMoved(ComponentEvent arg0) {
            }

            @Override
            public void componentResized(ComponentEvent arg0) {
                SwingHbox.this.container.getGraphics().drawImage(ico.getImage(), 0, 0, SwingHbox.this.container);
            }

            @Override
            public void componentShown(ComponentEvent arg0) {
            }
        });
    }
}

