/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swing.tags;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.containers.XulGrid;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swing.AbstractSwingContainer;
import org.pentaho.ui.xul.util.Align;

public class SwingGrid
extends AbstractSwingContainer
implements XulGrid {
    private JPanel grid = new JPanel();
    private static final Log logger = LogFactory.getLog(SwingGrid.class);

    public SwingGrid(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("grid");
        this.grid.setLayout(new GridBagLayout());
        this.grid.setOpaque(false);
        this.setManagedObject(this.grid);
        this.resetContainer();
    }

    @Override
    public void resetContainer() {
        this.grid.removeAll();
        this.gc = new GridBagConstraints();
        this.gc.gridy = 0;
        this.gc.gridx = 0;
        this.gc.gridheight = 1;
        this.gc.gridwidth = 1;
        this.gc.insets = new Insets(2, 2, 2, 2);
        this.gc.anchor = 18;
        this.gc.weightx = 1.0;
    }

    @Override
    public void layout() {
        if (this.getChildNodes().size() < 2) {
            logger.warn((Object)"Grid does not contain Column and Row children");
            return;
        }
        XulComponent columns = (XulComponent)this.getChildNodes().get(0);
        XulComponent rows = (XulComponent)this.getChildNodes().get(1);
        int colCount = 0;
        int rowCount = 0;
        float colFlexTotal = 0.0f;
        float rowTotalFlex = 0.0f;
        for (XulComponent col : columns.getChildNodes()) {
            if (col.getFlex() > 0) {
                colFlexTotal += (float)col.getFlex();
            }
            ++colCount;
        }
        for (XulComponent row : rows.getChildNodes()) {
            if (row.getFlex() > 0) {
                rowTotalFlex += (float)row.getFlex();
            }
            ++rowCount;
        }
        for (XulComponent row : rows.getChildNodes()) {
            this.gc.gridx = 0;
            for (XulComponent xulComp : row.getChildNodes()) {
                this.gc.weightx = 0.0;
                this.gc.gridwidth = 1;
                this.gc.gridheight = 1;
                this.gc.weighty = 0.0;
                this.gc.anchor = 18;
                this.gc.fill = 0;
                Component comp = (Component)xulComp.getManagedObject();
                float colFlex = ((XulComponent)columns.getChildNodes().get(this.gc.gridx)).getFlex();
                int rowFlex = row.getFlex();
                Align colAlignment = null;
                Align rowAlignment = null;
                String colAlignmentStr = xulComp.getAlign();
                String rowAlignStr = row.getAlign();
                if (colAlignmentStr != null) {
                    colAlignment = Align.valueOf((String)colAlignmentStr);
                }
                if (rowAlignStr != null) {
                    rowAlignment = Align.valueOf((String)rowAlignStr);
                }
                if (colFlex > 0.0f) {
                    this.gc.weightx = colFlex / colFlexTotal;
                }
                if (rowFlex > 0) {
                    this.gc.weighty = (float)rowFlex / rowTotalFlex;
                }
                if (colAlignment == Align.STRETCH && xulComp.getFlex() > 0) {
                    this.gc.fill = 1;
                } else if (colAlignment == Align.STRETCH) {
                    this.gc.fill = 2;
                } else if (xulComp.getFlex() > 0) {
                    this.gc.fill = 3;
                }
                this.gc.gridwidth = row.getChildNodes().indexOf(xulComp) + 1 == row.getChildNodes().size() ? 0 : 1;
                this.gc.gridheight = rows.getChildNodes().indexOf(row) + 1 == rows.getChildNodes().size() ? 0 : 1;
                if (colAlignment != null && rowAlignment != null) {
                    block0 : switch (rowAlignment) {
                        case START: {
                            switch (colAlignment) {
                                case START: {
                                    this.gc.anchor = 18;
                                    break block0;
                                }
                                case CENTER: {
                                    this.gc.anchor = 11;
                                    break block0;
                                }
                                case END: {
                                    this.gc.anchor = 12;
                                }
                            }
                            break;
                        }
                        case CENTER: {
                            switch (colAlignment) {
                                case START: {
                                    this.gc.anchor = 17;
                                    break block0;
                                }
                                case CENTER: {
                                    this.gc.anchor = 10;
                                    break block0;
                                }
                                case END: {
                                    this.gc.anchor = 13;
                                }
                            }
                            break;
                        }
                        case END: {
                            switch (colAlignment) {
                                case START: {
                                    this.gc.anchor = 16;
                                    break block0;
                                }
                                case CENTER: {
                                    this.gc.anchor = 15;
                                    break block0;
                                }
                                case END: {
                                    this.gc.anchor = 14;
                                }
                            }
                        }
                    }
                } else if (rowAlignment != null) {
                    switch (rowAlignment) {
                        case START: {
                            this.gc.anchor = 18;
                            break;
                        }
                        case CENTER: {
                            this.gc.anchor = 17;
                            break;
                        }
                        case END: {
                            this.gc.anchor = 16;
                        }
                    }
                } else if (colAlignment != null) {
                    switch (colAlignment) {
                        case START: {
                            this.gc.anchor = 18;
                            break;
                        }
                        case CENTER: {
                            this.gc.anchor = 11;
                            break;
                        }
                        case END: {
                            this.gc.anchor = 12;
                        }
                    }
                }
                if (comp.getWidth() > 0 || comp.getHeight() > 0) {
                    Dimension minSize = comp.getMinimumSize();
                    Dimension prefSize = comp.getPreferredSize();
                    if (comp.getWidth() > 0) {
                        minSize.width = comp.getWidth();
                        prefSize.width = comp.getWidth();
                    }
                    if (comp.getHeight() > 0) {
                        minSize.height = comp.getHeight();
                        prefSize.height = comp.getHeight();
                    }
                    comp.setMinimumSize(minSize);
                    comp.setPreferredSize(prefSize);
                } else {
                    comp.setPreferredSize(comp.getMinimumSize());
                }
                this.grid.add(comp, this.gc);
                ++this.gc.gridx;
            }
            ++this.gc.gridy;
        }
        if (rowTotalFlex == 0.0f) {
            ++this.gc.gridy;
            this.gc.weighty = 1.0;
            this.gc.fill = 0;
            this.grid.add(Box.createGlue(), this.gc);
        }
        this.initialized = true;
    }

    public void update() {
        this.resetContainer();
        this.layout();
    }
}

