/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swing.tags;

import java.awt.Component;
import java.awt.Point;
import java.io.File;
import javax.swing.JFileChooser;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.components.XulFileDialog;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swing.SwingElement;

public class SwingFileDialog
extends SwingElement
implements XulFileDialog {
    JFileChooser fc;
    private XulFileDialog.SEL_TYPE selectionType = XulFileDialog.SEL_TYPE.SINGLE;
    private XulFileDialog.VIEW_TYPE viewType = XulFileDialog.VIEW_TYPE.FILES_DIRECTORIES;
    private File selectedFile;
    private File[] selectedFiles;
    private Component parentObject = null;
    private XulComponent parent;

    public SwingFileDialog(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("filedialog");
        this.parent = domContainer.getDocumentRoot().getRootElement();
        domContainer.getDocumentRoot().getRootElement().addChild((Element)this);
    }

    public File getFile() {
        return this.fc.getSelectedFile();
    }

    public File[] getFiles() {
        return this.fc.getSelectedFiles();
    }

    public XulFileDialog.SEL_TYPE getSelectionMode() {
        return this.selectionType;
    }

    public XulFileDialog.VIEW_TYPE getViewType() {
        return this.viewType;
    }

    public void setSelectionMode(XulFileDialog.SEL_TYPE type) {
        this.selectionType = type;
    }

    public void setViewType(XulFileDialog.VIEW_TYPE type) {
        this.viewType = type;
    }

    public XulFileDialog.RETURN_CODE showOpenDialog() {
        this.fc = new JFileChooser();
        return this.showOpen();
    }

    public XulFileDialog.RETURN_CODE showOpenDialog(Object f) {
        this.fc = new JFileChooser((File)f);
        return this.showOpen();
    }

    public XulFileDialog.RETURN_CODE showSaveDialog() {
        this.fc = new JFileChooser();
        return this.showSave();
    }

    public XulFileDialog.RETURN_CODE showSaveDialog(Object f) {
        this.fc = new JFileChooser((File)f);
        return this.showSave();
    }

    private XulFileDialog.RETURN_CODE showOpen() {
        Point loc = this.getParentObject().getLocation();
        switch (this.getViewType()) {
            case FILES_DIRECTORIES: {
                this.fc.setFileSelectionMode(2);
                break;
            }
            case DIRECTORIES: {
                this.fc.setFileSelectionMode(1);
                break;
            }
            default: {
                this.fc.setFileSelectionMode(0);
            }
        }
        int retVal = this.fc.showOpenDialog(this.getParentObject());
        switch (retVal) {
            case 0: {
                if (this.selectionType == XulFileDialog.SEL_TYPE.SINGLE) {
                    this.selectedFile = this.fc.getSelectedFile();
                } else {
                    this.selectedFiles = this.fc.getSelectedFiles();
                }
                return XulFileDialog.RETURN_CODE.OK;
            }
        }
        return XulFileDialog.RETURN_CODE.CANCEL;
    }

    private XulFileDialog.RETURN_CODE showSave() {
        this.fc.setLocation(this.getParentObject().getLocation());
        int retVal = this.fc.showSaveDialog(this.getParentObject());
        switch (retVal) {
            case 0: {
                this.selectedFile = this.fc.getSelectedFile();
                return XulFileDialog.RETURN_CODE.OK;
            }
        }
        return XulFileDialog.RETURN_CODE.CANCEL;
    }

    public void setModalParent(Object parent) {
        this.parentObject = (Component)parent;
    }

    private Component getParentObject() {
        if (this.parentObject != null) {
            return this.parentObject;
        }
        return (Component)this.parent.getManagedObject();
    }
}

