/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.registry;

import java.util.HashSet;
import java.util.List;
import org.pentaho.metadata.registry.Entity;
import org.pentaho.metadata.registry.IMetadataRegistry;
import org.pentaho.metadata.registry.Link;
import org.pentaho.metadata.registry.Namespace;
import org.pentaho.metadata.registry.Type;
import org.pentaho.metadata.registry.TypeLink;
import org.pentaho.metadata.registry.Verb;

public abstract class RegistryBase
implements IMetadataRegistry {
    private boolean initialized = false;

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void init() throws Exception {
        this.addNamespace(Namespace.NAMESPACE_GLOBAL);
        this.addNamespace(Namespace.NAMESPACE_PDI);
        this.addNamespace(Namespace.NAMESPACE_MODELING);
        this.addNamespace(Namespace.NAMESPACE_ANALYZER);
        this.addNamespace(Namespace.NAMESPACE_REPORTING);
        this.addVerb(Verb.VERB_POPULATES);
        this.addVerb(Verb.VERB_READS);
        this.addVerb(Verb.VERB_DEFINES);
        this.addVerb(Verb.VERB_USES);
        this.addVerb(Verb.VERB_EXECUTES);
        this.addType(Type.TYPE_TRANSFORMATION);
        this.addType(Type.TYPE_JOB);
        this.addType(Type.TYPE_RESOURCE);
        this.addType(Type.TYPE_DB_CONNECTION);
        this.addType(Type.TYPE_PHYSICAL_TABLE);
        this.addType(Type.TYPE_PHYSICAL_COLUMN);
        this.addType(Type.TYPE_HOSTED_SOURCE);
        this.addType(Type.TYPE_PHYSICAL_FILE);
        this.addType(Type.TYPE_LOGICAL_COLUMN);
        this.addType(Type.TYPE_ANALYZER_VIEW);
        this.addType(Type.TYPE_REPORT);
        this.addType(Type.TYPE_OLAP_MODEL);
        this.addType(Type.TYPE_REL_MODEL);
        this.addTypeLink(new TypeLink("TRANS", "USES", "DB_CONNECTION"));
        this.addTypeLink(new TypeLink("TRANS", "POPULATES", "PHYSICAL TABLE"));
        this.addTypeLink(new TypeLink("TRANS", "POPULATES", "PHYSICAL COLUMN"));
        this.addTypeLink(new TypeLink("TRANS", "POPULATES", "PHYSICAL FILE"));
        this.addTypeLink(new TypeLink("TRANS", "READS", "PHYSICAL TABLE"));
        this.addTypeLink(new TypeLink("TRANS", "READS", "PHYSICAL COLUMN"));
        this.addTypeLink(new TypeLink("TRANS", "READS", "PHYSICAL FILE"));
        this.addTypeLink(new TypeLink("JOB", "EXECUTES", "TRANS"));
        this.addTypeLink(new TypeLink("OLAP_MOD", "USES", "DB_CONNECTION"));
        this.addTypeLink(new TypeLink("OLAP_MOD", "USES", "PHYS_TABLE"));
        this.addTypeLink(new TypeLink("OLAP_MOD", "USES", "PHYS_COLUMN"));
        this.addTypeLink(new TypeLink("OLAP_MOD", "DEFINES", "LOGICAL_COLUMN"));
        this.addTypeLink(new TypeLink("REL_MODEL", "USES", "DB_CONNECTION"));
        this.addTypeLink(new TypeLink("REL_MODEL", "USES", "PHYS_TABLE"));
        this.addTypeLink(new TypeLink("REL_MODEL", "USES", "PHYS_COLUMN"));
        this.addTypeLink(new TypeLink("REL_MODEL", "DEFINES", "LOGICAL_COLUMN"));
        this.addTypeLink(new TypeLink("VIEW", "USES", "LOGICAL_COLUMN"));
        this.addTypeLink(new TypeLink("REPORT", "USES", "LOGICAL_COLUMN"));
        this.initialized = true;
    }

    @Override
    public List<Link> findObjectLinks(String subjectId, String verbId, String typeId) {
        HashSet<String> verbIds = null;
        HashSet<String> typeIds = null;
        if (verbId != null) {
            verbIds = new HashSet<String>();
            verbIds.add(verbId);
        }
        if (typeId != null) {
            typeIds = new HashSet<String>();
            typeIds.add(typeId);
        }
        return this.findObjectLinks(subjectId, verbIds, typeIds);
    }

    @Override
    public List<Link> findSubjectLinks(String objectId, String verbId, String typeId) {
        HashSet<String> verbIds = null;
        HashSet<String> typeIds = null;
        if (verbId != null) {
            verbIds = new HashSet<String>();
            verbIds.add(verbId);
        }
        if (typeId != null) {
            typeIds = new HashSet<String>();
            typeIds.add(typeId);
        }
        return this.findSubjectLinks(objectId, verbIds, typeIds);
    }

    @Override
    public List<Link> findDirectLinks(String entityId, String typeId) {
        HashSet<String> typeIds = null;
        if (typeId != null) {
            typeIds = new HashSet<String>();
            typeIds.add(typeId);
        }
        return this.findDirectLinks(entityId, typeIds);
    }

    @Override
    public List<Entity> findAllLinkedEntities(String entityId, String typeId) {
        HashSet<String> typeIds = null;
        if (typeId != null) {
            typeIds = new HashSet<String>();
            typeIds.add(typeId);
        }
        return this.findAllLinkedEntities(entityId, typeIds);
    }
}

