/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.metastore;

import java.io.File;
import org.pentaho.di.core.util.Utils;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.stores.xml.XmlMetaStore;

public class MetaStoreConst {
    public static final String DB_ATTR_ID_DESCRIPTION = "description";
    public static final String DB_ATTR_ID_PLUGIN_ID = "plugin_id";
    public static final String DB_ATTR_ID_ACCESS_TYPE = "access_type";
    public static final String DB_ATTR_ID_HOSTNAME = "host_name";
    public static final String DB_ATTR_ID_PORT = "port";
    public static final String DB_ATTR_ID_DATABASE_NAME = "database_name";
    public static final String DB_ATTR_ID_USERNAME = "username";
    public static final String DB_ATTR_ID_PASSWORD = "password";
    public static final String DB_ATTR_ID_SERVERNAME = "server_name";
    public static final String DB_ATTR_ID_DATA_TABLESPACE = "data_tablespace";
    public static final String DB_ATTR_ID_INDEX_TABLESPACE = "index_tablespace";
    public static boolean disableMetaStore;
    public static final String DB_ATTR_DRIVER_CLASS = "driver_class";
    public static final String DB_ATTR_JDBC_URL = "jdbc_url";
    public static final String DB_ATTR_ID_ATTRIBUTES = "attributes";

    public static final String getDefaultPentahoMetaStoreLocation() {
        return System.getProperty("user.home") + File.separator + ".pentaho";
    }

    public static IMetaStore openLocalPentahoMetaStore() throws MetaStoreException {
        return MetaStoreConst.openLocalPentahoMetaStore(true);
    }

    public static IMetaStore openLocalPentahoMetaStore(boolean allowCreate) throws MetaStoreException {
        if (disableMetaStore) {
            return null;
        }
        String rootFolder = System.getProperty("PENTAHO_METASTORE_FOLDER");
        if (Utils.isEmpty(rootFolder)) {
            rootFolder = MetaStoreConst.getDefaultPentahoMetaStoreLocation();
        }
        File rootFolderFile = new File(rootFolder);
        File metaFolder = new File(rootFolder + File.separator + "metastore");
        if (!allowCreate && !metaFolder.exists()) {
            return null;
        }
        if (!rootFolderFile.exists()) {
            try {
                rootFolderFile.mkdirs();
            }
            catch (SecurityException e) {
                throw new MetaStoreException(e.getMessage());
            }
        }
        XmlMetaStore metaStore = new XmlMetaStore(rootFolder);
        if (allowCreate) {
            metaStore.setName("Pentaho Local Client Metastore");
        }
        return metaStore;
    }
}

