/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.vfs;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystem;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.vfs.SftpFileObjectWithWindowsSupport;
import org.pentaho.di.core.vfs.SftpFileSystemWindowsProvider;

class SftpFileSystemWindows
extends SftpFileSystem {
    private static final LogChannelInterface log = new LogChannel("SftpFileSystemWindows");
    private static final String WHO_AMI_GROUPS_FO_LIST = "Whoami /GROUPS /FO LIST";
    private static final String WHO_AMI = "Whoami ";
    private static final String ICACLS = "icacls ";
    private static final String VER = "ver";
    private static final String GROUP_NAME = "Group Name:";
    private static final String WINDOWS = "WINDOWS";
    private static final String N_DELIMITER = "\\n";
    private static final String RN_DELIMITER = "\r\n";
    private static final String WINDOWS_PATH_DELIMITER = "/";
    private AtomicInteger openStreamCount = new AtomicInteger(0);
    private Session subclassSession;
    private List<String> userGroups;
    private Boolean windowsFlag;
    private boolean execDisabled = false;

    SftpFileSystemWindows(GenericFileName rootName, Session session, FileSystemOptions fileSystemOptions) {
        super(rootName, session, fileSystemOptions);
        this.subclassSession = session;
        this.detectExecDisabledWinClass();
    }

    protected FileObject createFile(AbstractFileName name) throws FileSystemException {
        return new SftpFileObjectWithWindowsSupport(name, this);
    }

    protected synchronized void doCloseCommunicationLink() {
        this.closeSubclassSession();
        if (this.isReleaseable()) {
            super.doCloseCommunicationLink();
        }
    }

    private void closeSubclassSession() {
        if (this.subclassSession != null) {
            this.subclassSession.disconnect();
            this.subclassSession = null;
        }
    }

    public boolean isReleaseable() {
        return !this.isOpen() && (null == this.openStreamCount || this.openStreamCount.get() == 0);
    }

    List<String> getUserGroups() throws JSchException, IOException {
        if (this.userGroups == null) {
            StringBuilder output = new StringBuilder();
            int code = this.executeCommandWinClass(WHO_AMI_GROUPS_FO_LIST, output);
            if (code != 0) {
                throw new JSchException("Could not get the groups  of the current user (error code: " + code + ")");
            }
            this.userGroups = this.getUserGroups(output.toString());
            this.userGroups.add(this.getUser());
        }
        return this.userGroups;
    }

    private List<String> getUserGroups(String commandOutput) {
        ArrayList<String> result = new ArrayList<String>();
        int startIndex = 0;
        while ((startIndex = StringUtils.indexOfIgnoreCase((String)commandOutput, (String)GROUP_NAME, (int)startIndex)) >= 0) {
            int endIndex = StringUtils.indexOfIgnoreCase((String)commandOutput, (String)RN_DELIMITER, (int)(startIndex += GROUP_NAME.length()));
            if (endIndex < 0) {
                return result;
            }
            result.add(commandOutput.substring(startIndex, endIndex).toUpperCase().trim());
        }
        return result;
    }

    String getUser() throws JSchException, IOException {
        StringBuilder output = new StringBuilder();
        int code = this.executeCommandWinClass(WHO_AMI, output);
        if (code != 0) {
            throw new JSchException("Could not get user name on remote host (error code: " + code + ")");
        }
        return output.toString().trim().toUpperCase();
    }

    Map<String, String> getFilePermission(String path) throws JSchException, IOException {
        String[] strings;
        String windowsAbsPath;
        if (path.startsWith(WINDOWS_PATH_DELIMITER)) {
            path = path.substring(WINDOWS_PATH_DELIMITER.length());
            windowsAbsPath = path.substring(0, 1) + ":" + path.substring(1);
        } else {
            windowsAbsPath = path;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        StringBuilder output = new StringBuilder();
        int code = this.executeCommandWinClass(ICACLS + windowsAbsPath, output);
        if (code != 0) {
            return result;
        }
        String outputString = output.toString();
        int indexOf = outputString.indexOf(windowsAbsPath);
        if (indexOf > -1) {
            outputString = outputString.substring(indexOf + windowsAbsPath.length());
        }
        for (String string : strings = outputString.toUpperCase().split(N_DELIMITER)) {
            int index = string.indexOf(":");
            if (index <= -1) continue;
            result.put(string.substring(0, index).trim(), string.substring(index + 1).trim());
        }
        return result;
    }

    boolean isRemoteHostWindows() throws JSchException, IOException {
        if (this.windowsFlag == null) {
            StringBuilder output = new StringBuilder();
            int code = this.executeCommandWinClass(VER, output);
            this.windowsFlag = code == 0 && output.toString().toUpperCase().contains(WINDOWS);
        }
        return this.windowsFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureSession() throws FileSystemException {
        if (this.subclassSession == null || !this.subclassSession.isConnected()) {
            SftpFileSystemWindows sftpFileSystemWindows = this;
            synchronized (sftpFileSystemWindows) {
                if (this.subclassSession == null || !this.subclassSession.isConnected()) {
                    this.closeSubclassSession();
                    this.subclassSession = SftpFileSystemWindowsProvider.createSession((GenericFileName)this.getRootName(), this.getFileSystemOptions());
                }
            }
        }
    }

    private synchronized int executeCommandWinClass(String command, StringBuilder output) throws JSchException, IOException {
        int read;
        this.ensureSession();
        ChannelExec channel = (ChannelExec)this.subclassSession.openChannel("exec");
        channel.setCommand(command);
        channel.setInputStream((InputStream)null);
        InputStreamReader stream = new InputStreamReader(channel.getInputStream());
        channel.setErrStream((OutputStream)System.err, true);
        channel.connect();
        char[] buffer = new char[128];
        while ((read = stream.read(buffer, 0, buffer.length)) >= 0) {
            output.append(buffer, 0, read);
        }
        stream.close();
        while (!channel.isClosed()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exc) {
                log.logMinimal("Warning: Error session closing. " + exc.getMessage());
            }
        }
        channel.disconnect();
        return channel.getExitStatus();
    }

    private void detectExecDisabledWinClass() {
        try {
            this.getUId();
        }
        catch (JSchException | IOException e) {
            this.execDisabled = true;
        }
    }

    public boolean isExecDisabled() {
        return this.execDisabled;
    }

    protected synchronized void sftpBufferOpened() {
        this.openStreamCount.incrementAndGet();
    }

    protected synchronized void sftpBufferClosed() {
        this.openStreamCount.decrementAndGet();
    }
}

