/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging.log4j;

import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.message.Message;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogMessage;
import org.pentaho.di.core.logging.log4j.Log4jLayout;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.version.BuildVersion;

public class Log4jKettleLayout
extends AbstractStringLayout
implements Log4jLayout {
    private static final ThreadLocal<SimpleDateFormat> LOCAL_SIMPLE_DATE_PARSER = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        }
    };
    public static final String ERROR_STRING = "ERROR";
    private boolean timeAdded;

    public Log4jKettleLayout(Charset charset, boolean timeAdded) {
        super(charset);
        this.timeAdded = timeAdded;
    }

    @Override
    public String format(LogEvent event) {
        Message object;
        StringBuilder line = Log4jKettleLayout.getStringBuilder();
        String dateTimeString = "";
        if (this.timeAdded) {
            dateTimeString = LOCAL_SIMPLE_DATE_PARSER.get().format(new Date(event.getTimeMillis())) + " - ";
        }
        if ((object = event.getMessage()) instanceof LogMessage) {
            LogMessage message = (LogMessage)object;
            String[] parts = message.getMessage().split(Const.CR);
            for (int i = 0; i < parts.length; ++i) {
                line.append(dateTimeString);
                if (message.getSubject() != null) {
                    line.append(message.getSubject());
                    if (message.getCopy() != null) {
                        line.append(".").append(message.getCopy());
                    }
                    line.append(" - ");
                }
                if (message.isError()) {
                    BuildVersion buildVersion = BuildVersion.getInstance();
                    line.append(ERROR_STRING);
                    line.append(" (version ");
                    line.append(buildVersion.getVersion());
                    if (!Utils.isEmpty(buildVersion.getRevision())) {
                        line.append(", build ");
                        line.append(buildVersion.getRevision());
                    }
                    if (!Utils.isEmpty(buildVersion.getBuildDate())) {
                        line.append(" from ");
                        line.append(buildVersion.getBuildDate());
                    }
                    if (!Utils.isEmpty(buildVersion.getBuildUser())) {
                        line.append(" by ");
                        line.append(buildVersion.getBuildUser());
                    }
                    line.append(") : ");
                }
                line.append(parts[i]);
                if (i >= parts.length - 1) continue;
                line.append(Const.CR);
            }
        } else {
            line.append(dateTimeString);
            line.append(object != null ? object.toString() : "<null>");
        }
        line.append(Const.CR);
        return line.toString();
    }

    @Override
    public boolean ignoresThrowable() {
        return false;
    }

    @Override
    public void activateOptions() {
    }

    @Override
    public boolean isTimeAdded() {
        return this.timeAdded;
    }

    @Override
    public void setTimeAdded(boolean addTime) {
        this.timeAdded = addTime;
    }

    public byte[] getFooter() {
        return new byte[0];
    }

    public byte[] getHeader() {
        return new byte[0];
    }

    public String toSerializable(LogEvent event) {
        return this.format(event);
    }

    public String getContentType() {
        return null;
    }

    public Map<String, String> getContentFormat() {
        return new HashMap<String, String>();
    }

    public void encode(LogEvent source, ByteBufferDestination destination) {
    }
}

