/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database.util;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.apache.tomcat.jdbc.pool.DataSourceFactory;
import org.pentaho.support.encryption.Encr;
import org.pentaho.support.encryption.PasswordEncoderException;
import org.pentaho.support.utils.XmlParseException;

public class DecryptingDataSourceFactory
extends DataSourceFactory {
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (obj instanceof Reference) {
            this.setPassword((Reference)obj);
        }
        return super.getObjectInstance(obj, name, nameCtx, environment);
    }

    private void setPassword(Reference ref) throws PasswordEncoderException, XmlParseException {
        this.findDecryptAndReplace("password", ref);
    }

    private void findDecryptAndReplace(String refType, Reference ref) throws PasswordEncoderException, XmlParseException {
        int idx = this.find(refType, ref);
        String decrypted = this.decrypt(idx, ref);
        this.replace(idx, refType, decrypted, ref);
    }

    private void replace(int idx, String refType, String newValue, Reference ref) {
        ref.remove(idx);
        ref.add(idx, new StringRefAddr(refType, newValue));
    }

    private String decrypt(int idx, Reference ref) throws PasswordEncoderException, XmlParseException {
        return Encr.getInstance().decryptPasswordOptionallyEncrypted(ref.get(idx).getContent().toString());
    }

    private int find(String addrType, Reference ref) {
        Enumeration<RefAddr> enu = ref.getAll();
        int i = 0;
        while (enu.hasMoreElements()) {
            RefAddr addr = enu.nextElement();
            if (addr.getType().compareTo(addrType) == 0) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("The '" + addrType + "' name/value pair was not found in the Reference object. The reference Object is " + ref.toString());
    }
}

