/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.DBCacheEntry;
import org.pentaho.di.core.exception.KettleEOFException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.version.BuildVersion;

public class DBCache {
    @VisibleForTesting
    static DBCache dbCache;
    private Map<DBCacheEntry, RowMetaInterface> cache;
    private boolean useCache;
    private LogChannelInterface log;
    @VisibleForTesting
    static Supplier<String> fileNameSupplier;

    public void setActive() {
        this.setActive(true);
    }

    public void setInactive() {
        this.setActive(false);
    }

    public void setActive(boolean act) {
        this.useCache = act;
    }

    public boolean isActive() {
        return this.useCache;
    }

    public void put(DBCacheEntry entry, RowMetaInterface fields) {
        if (!this.useCache) {
            return;
        }
        RowMetaInterface copy = fields.clone();
        this.cache.put(entry, copy);
    }

    public RowMetaInterface get(DBCacheEntry entry) {
        if (!this.useCache) {
            return null;
        }
        RowMetaInterface fields = this.cache.get(entry);
        if (fields != null) {
            fields = fields.clone();
        }
        return fields;
    }

    public int size() {
        return this.cache.size();
    }

    public void clear(String dbname) {
        if (dbname == null) {
            this.cache = new ConcurrentHashMap<DBCacheEntry, RowMetaInterface>();
            this.setActive();
        } else {
            for (DBCacheEntry entry : this.cache.keySet()) {
                if (!entry.sameDB(dbname)) continue;
                this.cache.remove(entry);
            }
        }
    }

    public static String getFilename() {
        return Const.getKettleDirectory() + Const.FILE_SEPARATOR + "db.cache-" + BuildVersion.getInstance().getVersion();
    }

    private DBCache() throws KettleFileException {
        block8: {
            try {
                this.clear(null);
                this.log = new LogChannel("DBCache");
                String filename = fileNameSupplier.get();
                File file = new File(filename);
                if (file.canRead()) {
                    this.log.logDetailed("Loading database cache from file: [" + filename + "]");
                    try (DataInputStream dis = new DataInputStream(new FileInputStream(file));){
                        this.loadFileToCache(dis);
                        break block8;
                    }
                }
                this.log.logDetailed("The database cache doesn't exist yet.");
            }
            catch (Exception e) {
                throw new KettleFileException("Couldn't read the database cache", e);
            }
        }
    }

    private void loadFileToCache(DataInputStream dis) throws KettleFileException, SocketTimeoutException {
        int counter = 0;
        try {
            while (true) {
                DBCacheEntry entry = new DBCacheEntry(dis);
                RowMeta row = new RowMeta(dis);
                this.cache.put(entry, row);
                ++counter;
            }
        }
        catch (KettleEOFException eof) {
            this.log.logDetailed("We read " + counter + " cached rows from the database cache!");
            return;
        }
    }

    public void saveCache() throws KettleFileException {
        block10: {
            try {
                String filename = fileNameSupplier.get();
                File file = new File(filename);
                if (!file.exists() || file.canWrite()) {
                    try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file), 10000));){
                        int counter = 0;
                        for (DBCacheEntry entry : this.cache.keySet()) {
                            entry.write(dos);
                            RowMetaInterface rowMeta = this.get(entry);
                            if (rowMeta != null) {
                                rowMeta.writeMeta(dos);
                                ++counter;
                                continue;
                            }
                            throw new KettleFileException("The database cache contains an empty row. We can't save this!");
                        }
                        this.log.logDetailed("We wrote " + counter + " cached rows to the database cache!");
                        break block10;
                    }
                }
                throw new KettleFileException("We can't write to the cache file: " + filename);
            }
            catch (Exception e) {
                throw new KettleFileException("Couldn't write to the database cache", e);
            }
        }
    }

    public static DBCache getInstance() {
        if (dbCache != null) {
            return dbCache;
        }
        try {
            dbCache = new DBCache();
        }
        catch (KettleFileException kfe) {
            throw new RuntimeException("Unable to create the database cache: " + kfe.getMessage());
        }
        return dbCache;
    }

    static {
        fileNameSupplier = DBCache::getFilename;
    }
}

