/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.connections.vfs;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.pentaho.di.connections.ConnectionDetails;
import org.pentaho.di.connections.ConnectionManager;
import org.pentaho.di.connections.vfs.VFSConnectionDetails;
import org.pentaho.di.connections.vfs.VFSConnectionProvider;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;

public abstract class BaseVFSConnectionProvider<T extends VFSConnectionDetails>
implements VFSConnectionProvider<T> {
    private Supplier<ConnectionManager> connectionManagerSupplier = ConnectionManager::getInstance;

    @Override
    public List<String> getNames() {
        return this.connectionManagerSupplier.get().getNamesByType(this.getClass());
    }

    @Override
    public List<T> getConnectionDetails() {
        return this.connectionManagerSupplier.get().getConnectionDetailsByScheme(this.getKey());
    }

    @Override
    public T prepare(T connectionDetails) throws KettleException {
        return connectionDetails;
    }

    @Override
    public String sanitizeName(String string) {
        return string;
    }

    protected String getVar(String value, VariableSpace variableSpace) {
        if (variableSpace != null) {
            return variableSpace.environmentSubstitute(value);
        }
        return value;
    }

    protected static boolean getBooleanValueOfVariable(VariableSpace space, String variableName, String defaultValue) {
        String value;
        if (!Utils.isEmpty(variableName) && !Utils.isEmpty(value = space.environmentSubstitute(variableName))) {
            Boolean b = ValueMetaBase.convertStringToBoolean(value);
            return b != null && b != false;
        }
        return Objects.equals(Boolean.TRUE, ValueMetaBase.convertStringToBoolean(defaultValue));
    }

    protected VariableSpace getSpace(ConnectionDetails connectionDetails) {
        return connectionDetails.getSpace() == null ? Variables.getADefaultVariableSpace() : connectionDetails.getSpace();
    }
}

