/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.connections;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.pentaho.di.connections.ConnectionDetails;
import org.pentaho.di.connections.ConnectionProvider;
import org.pentaho.di.connections.LookupFilter;
import org.pentaho.di.connections.utils.EncryptUtils;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.persist.MetaStoreFactory;

public class ConnectionManager {
    private static final ConnectionManager instance = new ConnectionManager();
    private List<LookupFilter> lookupFilters = new ArrayList<LookupFilter>();
    private Supplier<IMetaStore> metaStoreSupplier;
    private ConcurrentHashMap<String, ConnectionProvider<? extends ConnectionDetails>> connectionProviders = new ConcurrentHashMap();
    private List<String> nameCache = new ArrayList<String>();

    public static ConnectionManager getInstance() {
        return instance;
    }

    private <T extends ConnectionDetails> MetaStoreFactory<T> getMetaStoreFactory(Class<T> clazz) {
        return new MetaStoreFactory(clazz, this.metaStoreSupplier.get(), "pentaho");
    }

    private <T extends ConnectionDetails> MetaStoreFactory<T> getMetaStoreFactory(IMetaStore metaStore, Class<T> clazz) {
        return new MetaStoreFactory(clazz, metaStore, "pentaho");
    }

    public void setMetastoreSupplier(Supplier<IMetaStore> metaStoreSupplier) {
        this.metaStoreSupplier = metaStoreSupplier;
    }

    public void addLookupFilter(LookupFilter lookupFilter) {
        this.lookupFilters.add(lookupFilter);
    }

    public void addConnectionProvider(String key, ConnectionProvider<? extends ConnectionDetails> connectionProvider) {
        this.connectionProviders.putIfAbsent(key, connectionProvider);
    }

    public ConnectionProvider<? extends ConnectionDetails> getConnectionProvider(String key) {
        return this.connectionProviders.get(this.getLookupKey(key));
    }

    protected String getLookupKey(String value) {
        for (LookupFilter lookupFilter : this.lookupFilters) {
            String filterValue = lookupFilter.filter(value);
            if (filterValue == null) continue;
            return filterValue;
        }
        return value;
    }

    public <T extends ConnectionDetails> boolean save(IMetaStore metaStore, T connectionDetails) {
        return this.save(metaStore, connectionDetails, true);
    }

    public <T extends ConnectionDetails> boolean save(IMetaStore metaStore, T connectionDetails, boolean prepare) {
        if (connectionDetails.getType() == null) {
            return false;
        }
        ConnectionProvider<? extends ConnectionDetails> connectionProvider = this.connectionProviders.get(connectionDetails.getType());
        try {
            if (prepare) {
                connectionProvider.prepare(connectionDetails);
            }
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        if (!this.saveElement(this.getMetaStoreFactory(metaStore, connectionDetails.getClass()), connectionDetails)) {
            return false;
        }
        if (!this.nameCache.contains(connectionDetails.getName())) {
            this.nameCache.add(connectionDetails.getName());
        }
        return true;
    }

    public <T extends ConnectionDetails> boolean save(T connectionDetails) {
        return this.save(this.metaStoreSupplier.get(), connectionDetails);
    }

    public <T extends ConnectionDetails> boolean test(T connectionDetails) throws KettleException {
        ConnectionProvider<? extends ConnectionDetails> connectionProvider = this.connectionProviders.get(connectionDetails.getType());
        return connectionProvider.test(connectionDetails);
    }

    public void delete(String name) {
        this.delete(this.metaStoreSupplier.get(), name);
    }

    public void delete(IMetaStore metaStore, String name) {
        ArrayList<ConnectionProvider<? extends ConnectionDetails>> providers = Collections.list(this.connectionProviders.elements());
        for (ConnectionProvider connectionProvider : providers) {
            try {
                ConnectionDetails connectionDetails = this.loadElement(this.getMetaStoreFactory(metaStore, connectionProvider.getClassType()), name);
                if (connectionDetails == null) continue;
                this.getMetaStoreFactory(metaStore, connectionProvider.getClassType()).deleteElement(name);
                this.nameCache.remove(name);
            }
            catch (MetaStoreException metaStoreException) {}
        }
    }

    public List<ConnectionProvider<? extends ConnectionDetails>> getProviders() {
        return Collections.list(this.connectionProviders.elements());
    }

    public List<ConnectionProvider<? extends ConnectionDetails>> getProvidersByType(Class<? extends ConnectionProvider> clazz) {
        return Collections.list(this.connectionProviders.elements()).stream().filter(connectionProvider -> clazz.isAssignableFrom(connectionProvider.getClass())).collect(Collectors.toList());
    }

    private List<String> getNames(IMetaStore metaStore, ConnectionProvider<? extends ConnectionDetails> provider) {
        try {
            return this.getMetaStoreFactory(metaStore, provider.getClassType()).getElementNames();
        }
        catch (MetaStoreException mse) {
            return Collections.emptyList();
        }
    }

    private List<String> getNames(ConnectionProvider<? extends ConnectionDetails> provider) {
        if (this.metaStoreSupplier == null || this.metaStoreSupplier.get() == null) {
            return Collections.emptyList();
        }
        return this.getNames(this.metaStoreSupplier.get(), provider);
    }

    public List<String> getNames(IMetaStore metaStore, boolean clearCache) {
        if (clearCache) {
            this.nameCache.clear();
        }
        if (!this.nameCache.isEmpty()) {
            return this.nameCache;
        }
        ArrayList<String> detailNames = new ArrayList<String>();
        ArrayList<ConnectionProvider<? extends ConnectionDetails>> providers = Collections.list(this.connectionProviders.elements());
        for (ConnectionProvider connectionProvider : providers) {
            detailNames.addAll(this.getNames(metaStore, connectionProvider));
        }
        this.nameCache.addAll(detailNames);
        return detailNames;
    }

    public List<String> getNames(boolean clearCache) {
        return this.getNames(this.metaStoreSupplier.get(), clearCache);
    }

    public List<String> getNames() {
        return this.getNames(this.metaStoreSupplier.get(), true);
    }

    public List<String> getNames(IMetaStore metaStore) {
        return this.getNames(metaStore, true);
    }

    public boolean exists(String name) {
        return this.getNames().stream().anyMatch(name::equalsIgnoreCase);
    }

    public List<String> getNamesByType(Class<? extends ConnectionProvider> clazz) {
        ArrayList<String> detailNames = new ArrayList<String>();
        List providers = Collections.list(this.connectionProviders.elements()).stream().filter(connectionProvider -> clazz.isAssignableFrom(connectionProvider.getClass())).collect(Collectors.toList());
        for (ConnectionProvider provider : providers) {
            detailNames.addAll(this.getNames(provider));
        }
        return detailNames;
    }

    public List<String> getNamesByKey(String key) {
        ArrayList<String> detailNames = new ArrayList<String>();
        List providers = Collections.list(this.connectionProviders.elements()).stream().filter(connectionProvider -> connectionProvider.getKey().equals(key)).collect(Collectors.toList());
        for (ConnectionProvider provider : providers) {
            detailNames.addAll(this.getNames(provider));
        }
        return detailNames;
    }

    public ConnectionDetails getConnectionDetails(IMetaStore metaStore, String key, String name) {
        ConnectionProvider<? extends ConnectionDetails> connectionProvider = this.getConnectionProvider(key);
        if (connectionProvider != null) {
            Class<? extends ConnectionDetails> clazz = connectionProvider.getClassType();
            return this.loadElement(this.getMetaStoreFactory(metaStore, clazz), name);
        }
        return null;
    }

    public ConnectionDetails getConnectionDetails(String key, String name) {
        if (this.metaStoreSupplier == null || this.metaStoreSupplier.get() == null) {
            return null;
        }
        return this.getConnectionDetails(this.metaStoreSupplier.get(), key, name);
    }

    public ConnectionDetails getConnectionDetails(String name) {
        if (this.metaStoreSupplier == null || this.metaStoreSupplier.get() == null) {
            return null;
        }
        return this.getConnectionDetails(this.metaStoreSupplier.get(), name);
    }

    public ConnectionDetails getConnectionDetails(IMetaStore metaStore, String name) {
        ArrayList<ConnectionProvider<? extends ConnectionDetails>> providers = Collections.list(this.connectionProviders.elements());
        for (ConnectionProvider connectionProvider : providers) {
            ConnectionDetails connectionDetails = this.loadElement(this.getMetaStoreFactory(metaStore, connectionProvider.getClassType()), name);
            if (connectionDetails == null) continue;
            return connectionDetails;
        }
        return null;
    }

    private <T extends ConnectionDetails> boolean saveElement(MetaStoreFactory<T> metaStoreFactory, T connectionDetails) {
        try {
            EncryptUtils.encryptFields(connectionDetails);
            metaStoreFactory.saveElement(connectionDetails);
            return true;
        }
        catch (MetaStoreException ignored) {
            return false;
        }
    }

    private ConnectionDetails loadElement(MetaStoreFactory metaStoreFactory, String name) {
        try {
            ConnectionDetails connectionDetails = (ConnectionDetails)metaStoreFactory.loadElement(name);
            if (connectionDetails != null) {
                EncryptUtils.decryptFields(connectionDetails);
            }
            return connectionDetails;
        }
        catch (MetaStoreException e) {
            return null;
        }
    }

    public ConnectionDetails createConnectionDetails(String scheme) {
        try {
            ConnectionProvider<? extends ConnectionDetails> provider = this.connectionProviders.get(scheme);
            return provider.getClassType().newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<? extends ConnectionDetails> getConnectionDetailsByScheme(String scheme) {
        ConnectionProvider<? extends ConnectionDetails> provider = this.connectionProviders.get(scheme);
        try {
            return this.getMetaStoreFactory(provider.getClassType()).getElements();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public void clear(IMetaStore metaStore) {
        List<String> names = this.getNames(metaStore);
        for (String name : names) {
            this.delete(metaStore, name);
        }
    }

    public void copy(IMetaStore sourceMetaStore, IMetaStore destinationMetaStore) {
        List<String> sourceNames = this.getNames(sourceMetaStore, true);
        List<String> destinationNames = this.getNames(destinationMetaStore, true);
        for (String sourceName : sourceNames) {
            if (destinationNames.contains(sourceName)) continue;
            ConnectionDetails connectionDetails = this.getConnectionDetails(sourceMetaStore, sourceName);
            this.save(destinationMetaStore, connectionDetails, false);
        }
    }

    public List<Type> getItems() {
        ArrayList<Type> types = new ArrayList<Type>();
        ArrayList<ConnectionProvider<? extends ConnectionDetails>> providers = Collections.list(this.connectionProviders.elements());
        for (ConnectionProvider connectionProvider : providers) {
            types.add(new Type(connectionProvider.getKey(), connectionProvider.getName()));
        }
        return types;
    }

    public static class Type {
        private String value;
        private String label;

        public Type(String value, String label) {
            this.value = value;
            this.label = label;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }
    }
}

