/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom.wrappers;

import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.Location;
import org.eigenbase.xom.Locator;
import org.eigenbase.xom.XOMUtil;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class W3CDOMWrapper
implements DOMWrapper {
    final Node node;
    private final Locator locator;

    public W3CDOMWrapper(Node node, Locator locator) {
        this.node = node;
        this.locator = locator;
    }

    public int getType() {
        short nodeType = this.node.getNodeType();
        switch (nodeType) {
            case 1: {
                return 2;
            }
            case 8: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    public String getTagName() {
        if (this.getType() != 2) {
            return null;
        }
        return ((Element)this.node).getTagName();
    }

    public String getAttribute(String attrName) {
        if (this.getType() != 2) {
            return null;
        }
        String attrVal = ((Element)this.node).getAttribute(attrName);
        if (attrVal == null || attrVal.length() == 0) {
            return null;
        }
        return attrVal;
    }

    public String[] getAttributeNames() {
        NamedNodeMap map = this.node.getAttributes();
        int count = map.getLength();
        String[] attributeNames = new String[count];
        for (int i = 0; i < count; ++i) {
            attributeNames[i] = map.item(i).getLocalName();
        }
        return attributeNames;
    }

    public String getText() {
        if (this.node instanceof Comment) {
            return ((Comment)this.node).getData();
        }
        StringBuffer sbuf = new StringBuffer();
        W3CDOMWrapper.appendNodeText(this.node, sbuf);
        return sbuf.toString();
    }

    public String toXML() {
        boolean onlyElements = false;
        return XOMUtil.wrapperToXml(this, onlyElements);
    }

    private static void appendNodeText(Node node, StringBuffer sbuf) {
        if (!(node instanceof Comment)) {
            if (node instanceof CharacterData) {
                sbuf.append(((CharacterData)node).getData());
            } else if (node instanceof Element) {
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    W3CDOMWrapper.appendNodeText(nodeList.item(i), sbuf);
                }
            }
        }
    }

    public DOMWrapper[] getChildren() {
        if (this.getType() != 2) {
            return new DOMWrapper[0];
        }
        NodeList nodeList = this.node.getChildNodes();
        int count = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node nextNode = nodeList.item(i);
            if (!(nextNode instanceof Element) && !(nextNode instanceof Text)) continue;
            ++count;
        }
        DOMWrapper[] ret = new DOMWrapper[count];
        count = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node nextNode = nodeList.item(i);
            if (!(nextNode instanceof Element) && !(nextNode instanceof Text)) continue;
            ret[count++] = new W3CDOMWrapper(nextNode, this.locator);
        }
        return ret;
    }

    public DOMWrapper[] getElementChildren() {
        if (this.getType() != 2) {
            return new DOMWrapper[0];
        }
        NodeList nodeList = this.node.getChildNodes();
        int count = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node nextNode = nodeList.item(i);
            if (!(nextNode instanceof Element)) continue;
            ++count;
        }
        DOMWrapper[] ret = new DOMWrapper[count];
        count = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node nextNode = nodeList.item(i);
            if (!(nextNode instanceof Element)) continue;
            ret[count++] = new W3CDOMWrapper(nextNode, this.locator);
        }
        return ret;
    }

    public Location getLocation() {
        return this.locator.getLocation(this);
    }
}

