/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.vfs.connections.ui.dialog;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.connections.ConnectionDetails;
import org.pentaho.di.connections.ConnectionManager;
import org.pentaho.di.connections.ui.dialog.ConnectionRenameDialog;
import org.pentaho.di.connections.ui.tree.ConnectionFolderProvider;
import org.pentaho.di.connections.vfs.VFSDetailsComposite;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.vfs.connections.ui.dialog.VFSDetailsCompositeHelper;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.util.HelpUtils;

public class ConnectionDialog
extends Dialog {
    private static final Class<?> PKG = ConnectionDialog.class;
    private static final Image LOGO = GUIResource.getInstance().getImageLogoSmall();
    private static final int MARGIN = 4;
    private static final ConnectionManager connectionManager = ConnectionManager.getInstance();
    private static final int TEXT_VAR_FLAGS = 18436;
    Supplier<Spoon> spoonSupplier = Spoon::getInstance;
    private String connectionTypeKey;
    private ConnectionDetails connectionDetails;
    private final List<ConnectionManager.Type> connectionTypes;
    private final String[] connectionTypeChoices;
    private final PropsUI props;
    private final int width;
    private final int height;
    private Shell shell;
    private String connectionName;
    private VFSDetailsComposite vfsDetailsComposite;
    private Composite wConnectionTypeComp;
    private VFSDetailsCompositeHelper helper;
    private Text wName;
    private Text wDescription;
    private CCombo wConnectionType;
    private Composite wDetailsWrapperComp;
    private ScrolledComposite wScrolledComposite;
    private String originalName;

    public ConnectionDialog(Shell shell, int width, int height) {
        super(shell, 0);
        this.width = width;
        this.height = height;
        this.props = PropsUI.getInstance();
        this.connectionTypes = connectionManager.getItems();
        this.connectionTypeChoices = (String[])this.connectionTypes.stream().filter(connType -> !"other".equals(new String(connType.getValue()))).map(ConnectionManager.Type::getLabel).sorted().toArray(String[]::new);
        this.helper = new VFSDetailsCompositeHelper(PKG, this.props);
    }

    public void open(String title) {
        this.open(title, null);
    }

    public void open(String title, String existingConnectionName) {
        this.connectionName = existingConnectionName;
        final Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.shell.setSize(this.width, this.height);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(LOGO);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setText(title);
        this.shell.setLayout((Layout)formLayout);
        Button wOK = new Button((Composite)this.shell, 8);
        wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        Button wTest = new Button((Composite)this.shell, 8);
        wTest.setText(BaseMessages.getString(PKG, (String)"System.Button.Test", (String[])new String[0]));
        Button[] buttons = new Button[]{wOK, wCancel, wTest};
        BaseStepDialog.positionBottomRightButtons((Composite)this.shell, (Button[])buttons, (int)4, null);
        final String docUrl = Const.getDocUrl((String)BaseMessages.getString(PKG, (String)"ConnectionDialog.help.dialog.Help", (String[])new String[0]));
        final String docTitle = BaseMessages.getString(PKG, (String)"ConnectionDialog.help.dialog.Title", (String[])new String[0]);
        final String docHeader = BaseMessages.getString(PKG, (String)"ConnectionDialog.help.dialog.Header", (String[])new String[0]);
        Button btnHelp = new Button((Composite)this.shell, 0);
        btnHelp.setImage(GUIResource.getInstance().getImageHelpWeb());
        btnHelp.setText(BaseMessages.getString(PKG, (String)"System.Button.Help", (String[])new String[0]));
        btnHelp.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.Help", (String[])new String[0]));
        BaseStepDialog.positionBottomLeftButtons((Composite)this.shell, (Button[])new Button[]{btnHelp}, (int)4, null);
        btnHelp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                HelpUtils.openHelpDialog((Shell)parent.getShell(), (String)docTitle, (String)docUrl, (String)docHeader);
            }
        });
        wOK.addListener(13, e -> this.ok());
        wCancel.addListener(13, e -> this.cancel());
        wTest.addListener(13, e -> this.test());
        this.wConnectionTypeComp = new Composite((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wConnectionTypeComp);
        FormLayout genLayout = new FormLayout();
        genLayout.marginWidth = 5;
        genLayout.marginHeight = 5;
        this.wConnectionTypeComp.setLayout((Layout)genLayout);
        FormData fdTabFolder = new FormData();
        fdTabFolder.top = new FormAttachment(0, 4);
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)wCancel, -4);
        this.wConnectionTypeComp.setLayoutData((Object)fdTabFolder);
        this.addHeaderWidgets();
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ConnectionDialog.this.cancel();
            }
        });
        this.shell.open();
        while (!this.shell.isDisposed()) {
            Display display = parent.getDisplay();
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void addHeaderWidgets() {
        Label wlName = this.createLabel("ConnectionDialog.ConnectionName.Label", null);
        this.wName = this.createText((Control)wlName);
        Label wlConnectionType = this.createLabel("ConnectionDialog.ConnectionType.Label", (Control)this.wName);
        this.wConnectionType = this.createCCombo((Control)wlConnectionType, 200);
        this.wConnectionType.setItems(this.connectionTypeChoices);
        this.wConnectionType.select(0);
        Label wlDescription = this.createLabel("ConnectionDialog.Description.Label", (Control)this.wConnectionType);
        this.wDescription = this.createMultilineText((Control)wlDescription);
        ((FormData)this.wDescription.getLayoutData()).height = this.wDescription.computeSize((int)-1, (int)-1).y * 3;
        this.setConnectionType();
        this.populateWidgets();
        this.wName.addModifyListener(modifyEvent -> this.setName(this.wName.getText()));
        this.wConnectionType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String connectionTypeSelected = ConnectionDialog.this.wConnectionType.getText();
                ConnectionDialog.this.updateConnectionType(ConnectionDialog.this.convertTypeLabelToKey(connectionTypeSelected));
            }
        });
        this.wDescription.addModifyListener(modifyEvent -> this.connectionDetails.setDescription(this.wDescription.getText()));
    }

    private void setConnectionType() {
        if (this.connectionName != null) {
            this.connectionDetails = connectionManager.getConnectionDetails(this.connectionName);
            this.originalName = this.connectionName;
            if (this.connectionDetails != null) {
                this.connectionTypeKey = this.connectionDetails.getType();
            }
            return;
        }
        this.connectionTypeKey = this.convertTypeLabelToKey(this.connectionTypeChoices[0]);
        this.connectionDetails = connectionManager.createConnectionDetails(this.connectionTypeKey);
        this.originalName = null;
    }

    private void updateConnectionType(String connectionType) {
        if (this.vfsDetailsComposite != null && this.connectionDetails != null) {
            this.connectionDetails.closeDialog();
            this.vfsDetailsComposite = null;
        } else if (this.wDetailsWrapperComp != null && !this.wDetailsWrapperComp.isDisposed()) {
            this.wDetailsWrapperComp.dispose();
            this.wDetailsWrapperComp = null;
        }
        if (this.wScrolledComposite != null && !this.wScrolledComposite.isDisposed()) {
            this.wScrolledComposite.dispose();
        }
        if (this.connectionDetails != null && !this.connectionDetails.getType().equals(connectionType)) {
            ConnectionDetails newConnectionDetails = connectionManager.createConnectionDetails(connectionType);
            this.transferFieldsFromOldToNew(this.connectionDetails, newConnectionDetails);
            this.connectionDetails = newConnectionDetails;
        }
        this.wScrolledComposite = new ScrolledComposite(this.wConnectionTypeComp, 2560);
        FormData fdScrolledComp = new FormData();
        fdScrolledComp.top = new FormAttachment((Control)this.wDescription, 8);
        fdScrolledComp.left = new FormAttachment(0, 0);
        fdScrolledComp.right = new FormAttachment(100, 0);
        fdScrolledComp.bottom = new FormAttachment(100, 0);
        this.wScrolledComposite.setLayoutData((Object)fdScrolledComp);
        HashSet<ScrolledComposite> skipControls = new HashSet<ScrolledComposite>();
        skipControls.add(this.wScrolledComposite);
        this.wDetailsWrapperComp = new Composite((Composite)this.wScrolledComposite, 0);
        this.props.setLook((Control)this.wDetailsWrapperComp);
        if (this.connectionDetails != null) {
            this.vfsDetailsComposite = (VFSDetailsComposite)this.connectionDetails.openDialog((Object)this.wDetailsWrapperComp, (Object)this.props);
        }
        this.wScrolledComposite.setExpandHorizontal(false);
        this.wScrolledComposite.setExpandVertical(true);
        this.wScrolledComposite.setContent((Control)this.wDetailsWrapperComp);
        this.wDetailsWrapperComp.pack();
        this.wScrolledComposite.setMinSize(this.wDetailsWrapperComp.computeSize(this.wConnectionTypeComp.getClientArea().width, -1));
        this.wConnectionTypeComp.layout();
    }

    private void transferFieldsFromOldToNew(ConnectionDetails connectionDetails, ConnectionDetails newConnectionDetails) {
        newConnectionDetails.setName(connectionDetails.getName());
        newConnectionDetails.setDescription(connectionDetails.getDescription());
    }

    private void populateWidgets() {
        this.wConnectionType.select(this.getIndexOfKey(this.connectionTypeKey));
        this.updateConnectionType(this.connectionTypeKey);
        this.wName.setText(Const.NVL((String)this.connectionDetails.getName(), (String)""));
        this.wDescription.setText(Const.NVL((String)this.connectionDetails.getDescription(), (String)""));
    }

    private String convertTypeLabelToKey(String typeLabel) {
        Optional<ConnectionManager.Type> s = this.connectionTypes.stream().filter(x -> x.getLabel().equals(typeLabel)).findFirst();
        if (s.isPresent()) {
            return s.get().getValue();
        }
        return this.connectionTypes.get(0).getValue();
    }

    private String convertKeyToTypeLabel(String key) {
        Optional<ConnectionManager.Type> s = this.connectionTypes.stream().filter(x -> x.getValue().equals(key)).findFirst();
        if (s.isPresent()) {
            return s.get().getLabel();
        }
        return this.connectionTypes.get(0).getLabel();
    }

    private int getIndexOfKey(String key) {
        String typeLabel = this.convertKeyToTypeLabel(key);
        return IntStream.range(0, this.connectionTypeChoices.length).filter(i -> this.connectionTypeChoices[i].equals(typeLabel)).findFirst().orElse(-1);
    }

    private void setName(String name) {
        this.connectionDetails.setName(name);
        this.connectionName = name;
    }

    private void cancel() {
        this.dispose();
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    private void ok() {
        if (this.validateEntries()) {
            if (this.originalName != null && !this.originalName.equals(this.connectionDetails.getName())) {
                ConnectionRenameDialog connectionDeleteDialog = new ConnectionRenameDialog(this.spoonSupplier.get().getShell());
                int answer = connectionDeleteDialog.open(this.originalName, this.connectionDetails.getName());
                if (answer == 256) {
                    return;
                }
                connectionManager.save(this.connectionDetails);
                if (answer == 128) {
                    connectionManager.delete(this.originalName);
                }
            } else {
                connectionManager.save(this.connectionDetails);
            }
            this.refreshMenu();
            this.dispose();
        }
    }

    private void refreshMenu() {
        this.spoonSupplier.get().getShell().getDisplay().asyncExec(() -> this.spoonSupplier.get().refreshTree(ConnectionFolderProvider.STRING_VFS_CONNECTIONS));
        EngineMetaInterface engineMetaInterface = this.spoonSupplier.get().getActiveMeta();
        if (engineMetaInterface instanceof AbstractMeta) {
            ((AbstractMeta)engineMetaInterface).setChanged();
        }
    }

    private boolean validateEntries() {
        String validationMessage = this.computeValidateMessage();
        if (!Utils.isEmpty((CharSequence)validationMessage)) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(validationMessage);
            mb.open();
            return false;
        }
        return true;
    }

    private String computeValidateMessage() {
        if (this.connectionDetails == null) {
            return BaseMessages.getString(PKG, (String)"ConnectionDialog.validate.failure.noDetailsObjectPresent", (String[])new String[0]);
        }
        if (Utils.isEmpty((CharSequence)this.connectionDetails.getName())) {
            return BaseMessages.getString(PKG, (String)"ConnectionDialog.validate.failure.noName", (String[])new String[0]);
        }
        ConnectionDetails attemptReadDetails = connectionManager.getConnectionDetails(this.connectionDetails.getName());
        if (attemptReadDetails != null && attemptReadDetails.getType() != this.connectionDetails.getType()) {
            return BaseMessages.getString(PKG, (String)"ConnectionDialog.validate.failure.sameNameOnDifferentType", (String[])new String[]{this.connectionDetails.getName(), this.convertKeyToTypeLabel(attemptReadDetails.getType())});
        }
        return this.vfsDetailsComposite.validate();
    }

    private void test() {
        if (this.validateEntries()) {
            MessageBox mb;
            boolean result = false;
            try {
                result = connectionManager.test(this.connectionDetails);
                if (!result) {
                    mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"ConnectionDialog.test.failure", (String[])new String[0]));
                } else {
                    mb = new MessageBox(this.shell, 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"ConnectionDialog.test.success", (String[])new String[0]));
                }
            }
            catch (KettleException e) {
                mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"ConnectionDialog.test.failure", (String[])new String[0]) + Const.CR + Const.CR + e.getMessage());
            }
            mb.open();
        }
    }

    private Label createLabel(String key, Control topWidget) {
        return this.helper.createLabel(this.wConnectionTypeComp, 16448, key, topWidget);
    }

    private Text createText(Control topWidget) {
        return this.helper.createText(this.wConnectionTypeComp, 18436, topWidget, 0);
    }

    private Text createMultilineText(Control topWidget) {
        return this.helper.createText(this.wConnectionTypeComp, 18946, topWidget, 0);
    }

    private CCombo createCCombo(Control topWidget, int width) {
        return this.helper.createCCombo(this.wConnectionTypeComp, 18436, topWidget, width);
    }
}

