/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.connections.ui.tree;

import java.util.function.Supplier;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.pentaho.di.connections.ui.tree.ConnectionTreeItem;
import org.pentaho.di.connections.vfs.VFSConnectionDetails;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.ConstUI;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.TreeSelection;
import org.pentaho.di.vfs.connections.ui.dialog.ConnectionDelegate;

@ExtensionPoint(id="VFSConnectionPopupMenuExtension", description="Creates popup menus for VFS Connections", extensionPointId="SpoonPopupMenuExtension")
public class ConnectionPopupMenuExtension
implements ExtensionPointInterface {
    private static final Class<?> PKG = ConnectionPopupMenuExtension.class;
    private Supplier<Spoon> spoonSupplier = Spoon::getInstance;
    private Menu rootMenu;
    private Menu itemMenu;
    private ConnectionDelegate vfsConnectionDelegate = ConnectionDelegate.getInstance();
    private ConnectionTreeItem vfsConnectionTreeItem;

    public void callExtensionPoint(LogChannelInterface logChannelInterface, Object extension) throws KettleException {
        Menu popupMenu = null;
        Tree selectionTree = (Tree)extension;
        TreeSelection[] objects = this.spoonSupplier.get().getTreeObjects(selectionTree);
        TreeSelection object = objects[0];
        Object selection = object.getSelection();
        if (selection == VFSConnectionDetails.class) {
            popupMenu = this.createRootPopupMenu(selectionTree);
        } else if (selection instanceof ConnectionTreeItem) {
            this.vfsConnectionTreeItem = (ConnectionTreeItem)selection;
            popupMenu = this.createItemPopupMenu(selectionTree);
        }
        if (popupMenu != null) {
            ConstUI.displayMenu((Menu)popupMenu, (Control)selectionTree);
        } else {
            selectionTree.setMenu(null);
        }
    }

    private Menu createRootPopupMenu(Tree tree) {
        if (this.rootMenu == null) {
            this.rootMenu = new Menu((Control)tree);
            MenuItem menuItem = new MenuItem(this.rootMenu, 0);
            menuItem.setText(BaseMessages.getString(PKG, (String)"VFSConnectionPopupMenuExtension.MenuItem.New", (String[])new String[0]));
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ConnectionPopupMenuExtension.this.vfsConnectionDelegate.openDialog();
                }
            });
        }
        return this.rootMenu;
    }

    private Menu createItemPopupMenu(Tree tree) {
        if (this.itemMenu == null) {
            this.itemMenu = new Menu((Control)tree);
            MenuItem editMenuItem = new MenuItem(this.itemMenu, 0);
            editMenuItem.setText(BaseMessages.getString(PKG, (String)"VFSConnectionPopupMenuExtension.MenuItem.Edit", (String[])new String[0]));
            editMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ConnectionPopupMenuExtension.this.vfsConnectionDelegate.openDialog(ConnectionPopupMenuExtension.this.vfsConnectionTreeItem.getLabel());
                }
            });
            MenuItem deleteMenuItem = new MenuItem(this.itemMenu, 0);
            deleteMenuItem.setText(BaseMessages.getString(PKG, (String)"VFSConnectionPopupMenuExtension.MenuItem.Delete", (String[])new String[0]));
            deleteMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ConnectionPopupMenuExtension.this.vfsConnectionDelegate.delete(ConnectionPopupMenuExtension.this.vfsConnectionTreeItem.getLabel());
                }
            });
        }
        return this.itemMenu;
    }
}

