/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.exceptions.InternalJDBCError;
import com.sap.dbtech.jdbc.packet.PartEnumeration;
import com.sap.dbtech.jdbc.packet.ReplyPacket;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.vsp001.FunctionCode;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.HashMap;

public class Parseinfo {
    ConnectionSapDB connection;
    String sqlCmd;
    private byte[] parseid;
    private byte[] massParseid;
    DBTechTranslator[] paramInfos;
    int inputCount;
    private boolean isMassCmd;
    boolean isSelect;
    boolean isDBProc;
    boolean hasLongs;
    boolean cached;
    int functionCode;
    int sessionID;
    String[] columnNames;
    AbstractMap columnMap;
    DBTechTranslator[] columnInfos;
    boolean isClosed = false;
    private static final int applicationCodeByte = 10;
    String updTableName;

    public Parseinfo(ConnectionSapDB connectionSapDB, String string, int n) {
        this.connection = connectionSapDB;
        this.sqlCmd = string;
        this.massParseid = null;
        this.paramInfos = null;
        this.inputCount = 0;
        this.isSelect = false;
        this.isDBProc = false;
        this.hasLongs = false;
        this.isMassCmd = false;
        this.functionCode = n;
        this.sessionID = -1;
        this.updTableName = null;
        this.cached = false;
        if (n == 4 || n == 216 || n == 248 || n == 27) {
            this.isSelect = true;
        }
        if (n == 248 || n == 34) {
            this.isDBProc = true;
        }
        this.columnNames = null;
        this.columnMap = null;
    }

    public byte[] getMassParseid() {
        return this.massParseid;
    }

    public boolean setMassParseid(byte[] byArray) {
        this.massParseid = byArray;
        if (byArray == null) {
            return false;
        }
        int n = 0;
        while (n < FunctionCode.massCmdAppCodes.length) {
            if (byArray[10] == FunctionCode.massCmdAppCodes[n]) {
                this.isMassCmd = true;
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isMassCmd() {
        return this.isMassCmd;
    }

    public void setUpdateTableName(String string) {
        this.updTableName = string;
    }

    public boolean isValid() {
        return this.sessionID == this.connection.sessionID;
    }

    public DBTechTranslator[] getColumnInfos() {
        return this.columnInfos;
    }

    public void setParseIdAndSession(byte[] byArray, int n) {
        this.sessionID = n;
        this.parseid = byArray;
    }

    public synchronized void dropParseIDs() {
        if (this.parseid != null && this.connection != null) {
            this.connection.dropParseid(this.parseid);
            this.parseid = null;
        }
        if (this.massParseid != null && this.connection != null) {
            this.connection.dropParseid(this.massParseid);
            this.massParseid = null;
        }
    }

    protected void finalize() {
        this.cached = false;
        this.dropParseIDs();
    }

    public DBTechTranslator[] getParamInfo() {
        return this.paramInfos;
    }

    public void setSelect(boolean bl) {
        this.isSelect = bl;
    }

    public byte[] getParseId() {
        return this.parseid;
    }

    public boolean isAlreadyExecuted() {
        return this.parseid != null && this.parseid[10] == 1;
    }

    public void setShortInfosAndColumnNames(DBTechTranslator[] dBTechTranslatorArray, String[] stringArray) throws SQLException {
        this.inputCount = 0;
        this.hasLongs = false;
        this.columnNames = null;
        this.paramInfos = null;
        this.columnMap = null;
        this.columnInfos = null;
        this.columnNames = stringArray;
        if (dBTechTranslatorArray == null && stringArray == null) {
            this.columnInfos = new DBTechTranslator[0];
            this.paramInfos = this.columnInfos;
            return;
        }
        if (this.functionCode == 4) {
            if (stringArray == null || stringArray.length == 0) {
                this.paramInfos = dBTechTranslatorArray;
                int n = 0;
                while (n < this.paramInfos.length) {
                    DBTechTranslator dBTechTranslator = dBTechTranslatorArray[n];
                    if (dBTechTranslator.isInput()) {
                        dBTechTranslator.setColIndex(n);
                        ++this.inputCount;
                    }
                    this.hasLongs |= dBTechTranslator.isLongKind();
                    ++n;
                }
            } else {
                int n = stringArray.length;
                this.columnInfos = new DBTechTranslator[n];
                this.paramInfos = new DBTechTranslator[dBTechTranslatorArray.length - n];
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                while (n4 < dBTechTranslatorArray.length) {
                    DBTechTranslator dBTechTranslator = dBTechTranslatorArray[n4];
                    if (dBTechTranslator.isInput()) {
                        if (n3 == this.paramInfos.length) {
                            throw new InternalJDBCError(MessageTranslator.translate("error.internal.unexpectedinput", Integer.toString(n3)));
                        }
                        dBTechTranslator.setColIndex(n3);
                        this.paramInfos[n3] = dBTechTranslator;
                        ++n3;
                        ++this.inputCount;
                    } else {
                        if (n2 == this.columnInfos.length) {
                            throw new InternalJDBCError(MessageTranslator.translate("error.internal.unexpectedoutput", Integer.toString(n2)));
                        }
                        this.columnInfos[n2] = dBTechTranslator;
                        dBTechTranslator.setColIndex(n2);
                        dBTechTranslator.setColName(stringArray[n2]);
                        ++n2;
                    }
                    this.hasLongs |= dBTechTranslatorArray[n4].isLongKind();
                    ++n4;
                }
            }
        } else {
            this.paramInfos = dBTechTranslatorArray;
            if (stringArray != null) {
                if (stringArray.length == this.paramInfos.length) {
                    int n = 0;
                    while (n < stringArray.length) {
                        DBTechTranslator dBTechTranslator = this.paramInfos[n];
                        dBTechTranslator.setColIndex(n);
                        dBTechTranslator.setColName(stringArray[n]);
                        this.inputCount += dBTechTranslator.isInput() ? 1 : 0;
                        this.hasLongs |= dBTechTranslator.isLongKind();
                        ++n;
                    }
                } else {
                    int n = 0;
                    int n5 = 0;
                    while (n5 < this.paramInfos.length) {
                        DBTechTranslator dBTechTranslator = this.paramInfos[n5];
                        dBTechTranslator.setColIndex(n5);
                        if (dBTechTranslator.isOutput()) {
                            dBTechTranslator.setColName(stringArray[n++]);
                        } else {
                            ++this.inputCount;
                        }
                        this.hasLongs |= dBTechTranslator.isLongKind();
                        ++n5;
                    }
                }
            } else {
                int n = 0;
                while (n < this.paramInfos.length) {
                    DBTechTranslator dBTechTranslator = this.paramInfos[n];
                    dBTechTranslator.setColIndex(n);
                    this.inputCount += dBTechTranslator.isInput() ? 1 : 0;
                    this.hasLongs |= dBTechTranslator.isLongKind();
                    ++n;
                }
            }
        }
    }

    public AbstractMap getColumnMap() throws SQLException {
        if (this.columnMap != null) {
            return this.columnMap;
        }
        if (this.columnNames == null) {
            throw new InternalJDBCError(MessageTranslator.translate("error.no.columnnames"));
        }
        this.columnMap = new HashMap(this.columnNames.length);
        int n = 0;
        while (n < this.paramInfos.length) {
            DBTechTranslator dBTechTranslator = this.paramInfos[n];
            String string = dBTechTranslator.getColumnName();
            if (string != null) {
                this.columnMap.put(string, dBTechTranslator);
            }
            ++n;
        }
        return this.columnMap;
    }

    void doDescribeParseId() throws SQLException {
        String[] stringArray = null;
        DBTechTranslator[] dBTechTranslatorArray = null;
        RequestPacket requestPacket = this.connection.getRequestPacket();
        requestPacket.initDbsCommand(false, "Describe ");
        requestPacket.addParseidPart(this.parseid);
        ReplyPacket replyPacket = this.connection.execute(requestPacket, this, true);
        PartEnumeration partEnumeration = replyPacket.partEnumeration();
        while (partEnumeration.hasMoreElements()) {
            partEnumeration.nextElement();
            switch (partEnumeration.partKind()) {
                case 2: {
                    stringArray = replyPacket.parseColumnNames();
                    break;
                }
                case 14: {
                    dBTechTranslatorArray = replyPacket.parseShortFields(this.connection.isSpaceoptionSet);
                    break;
                }
            }
        }
        this.setMetaData(dBTechTranslatorArray, stringArray);
    }

    void setMetaData(DBTechTranslator[] dBTechTranslatorArray, String[] stringArray) throws SQLException {
        int n = dBTechTranslatorArray.length;
        this.columnNames = stringArray;
        if (n == stringArray.length) {
            this.columnInfos = dBTechTranslatorArray;
            int n2 = 0;
            while (n2 < n) {
                DBTechTranslator dBTechTranslator = dBTechTranslatorArray[n2];
                String string = stringArray[n2];
                dBTechTranslator.setColName(string);
                dBTechTranslator.setColIndex(n2);
                ++n2;
            }
        } else {
            int n3 = 0;
            this.columnInfos = new DBTechTranslator[stringArray.length];
            int n4 = 0;
            while (n4 < n) {
                if (dBTechTranslatorArray[n4].isOutput()) {
                    DBTechTranslator dBTechTranslator = this.columnInfos[n3] = dBTechTranslatorArray[n4];
                    String string = stringArray[n3];
                    dBTechTranslator.setColName(string);
                    dBTechTranslator.setColIndex(n3++);
                }
                ++n4;
            }
        }
    }
}

