/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.service;

import java.util.ArrayList;
import java.util.Arrays;
import org.pentaho.di.connections.ConnectionManager;
import org.pentaho.di.core.service.ServiceProvider;
import org.pentaho.di.core.service.ServiceProviderInterface;
import org.pentaho.di.metastore.MetaStoreConst;
import org.pentaho.di.plugins.fileopensave.api.providers.BaseFileProvider;
import org.pentaho.di.plugins.fileopensave.api.providers.FileProvider;
import org.pentaho.di.plugins.fileopensave.api.providers.exception.ProviderServiceInterface;
import org.pentaho.di.plugins.fileopensave.providers.ProviderService;
import org.pentaho.di.plugins.fileopensave.providers.local.LocalFileProvider;
import org.pentaho.di.plugins.fileopensave.providers.recents.RecentFileProvider;
import org.pentaho.di.plugins.fileopensave.providers.repository.RepositoryFileProvider;
import org.pentaho.di.plugins.fileopensave.providers.vfs.VFSFileProvider;

@ServiceProvider(id="ProviderServiceService", description="Allows external file providers to register themselves and access to providers", provides=ProviderServiceInterface.class)
public class ProviderServiceService
implements ProviderServiceInterface,
ServiceProviderInterface<ProviderServiceInterface> {
    private static ProviderService providerService;

    public ProviderServiceService() {
        ProviderServiceService.initProviderService();
    }

    private static void initProviderService() {
        if (null != providerService) {
            return;
        }
        LocalFileProvider localProvider = new LocalFileProvider();
        RepositoryFileProvider repoProvider = new RepositoryFileProvider();
        RecentFileProvider recentProvider = new RecentFileProvider();
        VFSFileProvider vfsProvider = new VFSFileProvider();
        ConnectionManager.getInstance().setMetastoreSupplier(() -> {
            try {
                return MetaStoreConst.openLocalPentahoMetaStore();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        ArrayList<FileProvider> fileProviders = new ArrayList<FileProvider>();
        fileProviders.addAll(Arrays.asList(new BaseFileProvider[]{recentProvider, localProvider, repoProvider, vfsProvider}));
        providerService = new ProviderService(fileProviders);
    }

    public static ProviderService get() {
        ProviderServiceService.initProviderService();
        return providerService;
    }

    public void addProviderService(FileProvider fileProvider) {
        ProviderServiceService.initProviderService();
        providerService.add(fileProvider);
    }

    public boolean isSingleton() {
        return true;
    }
}

