/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.providers.vfs.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.pentaho.di.plugins.fileopensave.api.providers.Directory;
import org.pentaho.di.plugins.fileopensave.providers.vfs.model.VFSFile;

public class VFSDirectory
extends VFSFile
implements Directory {
    public static final String DIRECTORY = "folder";
    private boolean hasChildren;
    private boolean canAddChildren;
    private List<VFSFile> children = new ArrayList<VFSFile>();

    public String getType() {
        return DIRECTORY;
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(boolean hasChildren) {
        this.hasChildren = hasChildren;
    }

    public List<VFSFile> getChildren() {
        return this.children;
    }

    public void setChildren(List<VFSFile> children) {
        this.children = children;
    }

    public void addChild(VFSFile file) {
        this.children.add(file);
    }

    public boolean isHasChildren() {
        return this.hasChildren;
    }

    public boolean isCanAddChildren() {
        return this.canAddChildren;
    }

    public void setCanAddChildren(boolean canAddChildren) {
        this.canAddChildren = canAddChildren;
    }

    public static VFSDirectory create(String parent, FileObject fileObject, String connection, String domain) {
        VFSDirectory vfsDirectory = new VFSDirectory();
        vfsDirectory.setName(fileObject.getName().getBaseName());
        vfsDirectory.setPath(fileObject.getName().getURI());
        vfsDirectory.setParent(parent);
        if (connection != null) {
            vfsDirectory.setConnection(connection);
            vfsDirectory.setRoot("VFS Connections");
        }
        vfsDirectory.setDomain(domain != null ? domain : "");
        vfsDirectory.setCanEdit(true);
        vfsDirectory.setHasChildren(true);
        vfsDirectory.setCanAddChildren(true);
        try {
            vfsDirectory.setDate(new Date(fileObject.getContent().getLastModifiedTime()));
        }
        catch (FileSystemException e) {
            vfsDirectory.setDate(new Date());
        }
        return vfsDirectory;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getProvider(), this.getConnection(), this.getPath());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VFSDirectory)) {
            return false;
        }
        VFSDirectory compare = (VFSDirectory)((Object)obj);
        return compare.getProvider().equals(this.getProvider()) && StringUtils.equals((String)compare.getConnection(), (String)this.getConnection()) && StringUtils.equals((String)compare.getPath(), (String)this.getPath());
    }
}

