/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.providers.recents;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.pentaho.di.core.LastUsedFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.plugins.fileopensave.api.providers.BaseFileProvider;
import org.pentaho.di.plugins.fileopensave.api.providers.Entity;
import org.pentaho.di.plugins.fileopensave.api.providers.File;
import org.pentaho.di.plugins.fileopensave.api.providers.Tree;
import org.pentaho.di.plugins.fileopensave.api.providers.exception.FileException;
import org.pentaho.di.plugins.fileopensave.providers.recents.model.RecentFile;
import org.pentaho.di.plugins.fileopensave.providers.recents.model.RecentTree;
import org.pentaho.di.plugins.fileopensave.providers.repository.model.RepositoryFile;
import org.pentaho.di.plugins.fileopensave.providers.repository.model.RepositoryTree;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.spoon.Spoon;

public class RecentFileProvider
extends BaseFileProvider<RecentFile> {
    public static final String TYPE = "recents";
    public static final String NAME = "Recents";
    private Supplier<PropsUI> propsUISupplier = PropsUI::getInstance;

    public Class<RecentFile> getFileClass() {
        return RecentFile.class;
    }

    public String getName() {
        return null;
    }

    public String getType() {
        return TYPE;
    }

    public boolean isAvailable() {
        return true;
    }

    public Tree getTree() {
        Object recentTree;
        PropsUI propsUI = this.getPropsUI();
        Date dateThreshold = this.getDateThreshold();
        Spoon spoonInstance = Spoon.getInstance();
        if (spoonInstance.rep == null) {
            List lastUsedFiles = propsUI.getLastUsedFiles().stream().filter(lastUsedFile -> !lastUsedFile.isSourceRepository() && !lastUsedFile.getLastOpened().before(dateThreshold)).collect(Collectors.toList());
            recentTree = new RecentTree(NAME);
            for (LastUsedFile lastUsedFile2 : lastUsedFiles) {
                recentTree.addChild((Entity)RecentFile.create(lastUsedFile2));
            }
        } else {
            IUser userInfo = spoonInstance.rep.getUserInfo();
            String repoAndUser = spoonInstance.rep.getName() + ":" + (userInfo != null ? userInfo.getLogin() : "");
            List<LastUsedFile> lastUsedFiles = propsUI.getLastUsedRepoFiles().getOrDefault(repoAndUser, Collections.emptyList()).stream().filter(lastUsedFile -> !lastUsedFile.getLastOpened().before(dateThreshold)).collect(Collectors.toList());
            recentTree = new RepositoryTree(NAME);
            this.getLastUsedFile(lastUsedFiles, spoonInstance, (Tree)recentTree);
        }
        return recentTree;
    }

    public List<RecentFile> getFiles(RecentFile file, String filters, VariableSpace space) throws FileException {
        return Collections.emptyList();
    }

    public List<RecentFile> delete(List<RecentFile> files, VariableSpace space) throws FileException {
        return Collections.emptyList();
    }

    public RecentFile add(RecentFile folder, VariableSpace space) throws FileException {
        return null;
    }

    public RecentFile getFile(RecentFile file, VariableSpace space) {
        return null;
    }

    public boolean fileExists(RecentFile dir, String path, VariableSpace space) throws FileException {
        return false;
    }

    public String getNewName(RecentFile destDir, String newPath, VariableSpace space) throws FileException {
        return null;
    }

    public boolean isSame(File file1, File file2) {
        return false;
    }

    public RecentFile rename(RecentFile file, String newPath, boolean overwrite, VariableSpace space) throws FileException {
        return null;
    }

    public RecentFile copy(RecentFile file, String toPath, boolean overwrite, VariableSpace space) throws FileException {
        return null;
    }

    public RecentFile move(RecentFile file, String toPath, boolean overwrite, VariableSpace space) throws FileException {
        return null;
    }

    public InputStream readFile(RecentFile file, VariableSpace space) throws FileException {
        return null;
    }

    public RecentFile writeFile(InputStream inputStream, RecentFile destDir, String path, boolean overwrite, VariableSpace space) throws FileException {
        return null;
    }

    public RecentFile getParent(RecentFile file) {
        return null;
    }

    public void clearProviderCache() {
    }

    public RecentFile createDirectory(String parentPath, RecentFile file, String newDirectoryName) {
        return null;
    }

    private PropsUI getPropsUI() {
        return this.propsUISupplier.get();
    }

    private Date getDateThreshold() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -30);
        return calendar.getTime();
    }

    private void getLastUsedFile(List<LastUsedFile> lastUsedFiles, Spoon spoonInstance, Tree recentTree) {
        for (LastUsedFile lastUsedFile : lastUsedFiles) {
            ObjectId objectID;
            try {
                objectID = lastUsedFile.isTransformation() ? spoonInstance.rep.getTransformationID(lastUsedFile.getFilename(), spoonInstance.rep.findDirectory(lastUsedFile.getDirectory())) : spoonInstance.rep.getJobId(lastUsedFile.getFilename(), spoonInstance.rep.findDirectory(lastUsedFile.getDirectory()));
            }
            catch (KettleException e) {
                objectID = null;
            }
            if (objectID == null) continue;
            recentTree.addChild((Entity)RepositoryFile.create(lastUsedFile, objectID));
        }
    }
}

