/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.providers.local.model;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.Objects;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.plugins.fileopensave.api.providers.BaseEntity;
import org.pentaho.di.plugins.fileopensave.api.providers.File;

public class LocalFile
extends BaseEntity
implements File {
    public String getProvider() {
        return "local";
    }

    public static LocalFile create(String parent, Path path) {
        LocalFile localFile = new LocalFile();
        String filename = null;
        if (path != null && path.getFileName() != null && !Utils.isEmpty((CharSequence)path.getFileName().toString())) {
            filename = path.getFileName().toString();
        }
        if (!Utils.isEmpty(filename)) {
            if (filename.endsWith(".ktr")) {
                localFile.setType("transformation");
            } else if (filename.endsWith(".kjb")) {
                localFile.setType("job");
            } else {
                localFile.setType("file");
            }
        }
        localFile.setName(filename);
        if (path != null) {
            localFile.setPath(path.toString());
        }
        localFile.setParent(parent);
        try {
            localFile.setDate(new Date(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis()));
        }
        catch (IOException e) {
            localFile.setDate(new Date());
        }
        localFile.setRoot("Local");
        localFile.setCanEdit(true);
        return localFile;
    }

    public int hashCode() {
        return Objects.hash(this.getProvider(), this.getPath());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LocalFile)) {
            return false;
        }
        LocalFile compare = (LocalFile)((Object)obj);
        return compare.getProvider().equals(this.getProvider()) && Objects.equals(this.getPath(), compare.getPath());
    }
}

