/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.providers.local.model;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.pentaho.di.plugins.fileopensave.api.providers.Directory;
import org.pentaho.di.plugins.fileopensave.providers.local.model.LocalFile;

public class LocalDirectory
extends LocalFile
implements Directory {
    private static String DIRECTORY = "folder";
    private boolean canAddChildren;
    private boolean hasChildren;
    private List<LocalFile> children = new ArrayList<LocalFile>();

    public String getType() {
        return DIRECTORY;
    }

    public boolean isHasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(boolean hasChildren) {
        this.hasChildren = hasChildren;
    }

    public List<LocalFile> getChildren() {
        return this.children;
    }

    public void setChildren(List<LocalFile> children) {
        this.children = children;
    }

    public void addChild(LocalFile file) {
        this.children.add(file);
    }

    public boolean isCanAddChildren() {
        return this.canAddChildren;
    }

    public void setCanAddChildren(boolean canAddChildren) {
        this.canAddChildren = canAddChildren;
    }

    public static LocalDirectory create(String parent, Path path) {
        LocalDirectory localDirectory = new LocalDirectory();
        localDirectory.setName(path.getFileName().toString());
        localDirectory.setPath(path.toString());
        localDirectory.setParent(parent);
        try {
            localDirectory.setDate(new Date(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis()));
        }
        catch (IOException e) {
            localDirectory.setDate(new Date());
        }
        localDirectory.setRoot("Local");
        localDirectory.setCanAddChildren(true);
        localDirectory.setCanEdit(true);
        localDirectory.setHasChildren(true);
        return localDirectory;
    }
}

