/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.providers;

import java.util.List;
import org.pentaho.di.plugins.fileopensave.api.providers.FileProvider;
import org.pentaho.di.plugins.fileopensave.api.providers.exception.InvalidFileProviderException;

public class ProviderService {
    private final List<FileProvider> fileProviders;

    public ProviderService(List<FileProvider> fileProviders) {
        this.fileProviders = fileProviders;
    }

    public FileProvider get(String provider) throws InvalidFileProviderException {
        return this.fileProviders.stream().filter(fileProvider1 -> fileProvider1.getType().equalsIgnoreCase(provider) && fileProvider1.isAvailable()).findFirst().orElseThrow(InvalidFileProviderException::new);
    }

    public List<FileProvider> get() {
        return this.fileProviders;
    }

    public void add(FileProvider fileProvider) {
        this.fileProviders.removeIf(p -> p.getType().equalsIgnoreCase(fileProvider.getType()) && (p.getName() == null || p.getName().equalsIgnoreCase(fileProvider.getName())));
        this.fileProviders.add(fileProvider);
    }
}

