/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.dialog;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SwtUniversalImage;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.plugins.fileopensave.api.file.FileDetails;
import org.pentaho.di.plugins.fileopensave.api.providers.Directory;
import org.pentaho.di.plugins.fileopensave.api.providers.Entity;
import org.pentaho.di.plugins.fileopensave.api.providers.File;
import org.pentaho.di.plugins.fileopensave.api.providers.FileProvider;
import org.pentaho.di.plugins.fileopensave.api.providers.Result;
import org.pentaho.di.plugins.fileopensave.api.providers.Tree;
import org.pentaho.di.plugins.fileopensave.api.providers.Utils;
import org.pentaho.di.plugins.fileopensave.api.providers.exception.FileException;
import org.pentaho.di.plugins.fileopensave.api.providers.exception.InvalidFileProviderException;
import org.pentaho.di.plugins.fileopensave.controllers.FileController;
import org.pentaho.di.plugins.fileopensave.dialog.PasteConfirmationDialog;
import org.pentaho.di.plugins.fileopensave.dialog.RenameDialog;
import org.pentaho.di.plugins.fileopensave.providers.local.model.LocalFile;
import org.pentaho.di.plugins.fileopensave.providers.recents.model.RecentTree;
import org.pentaho.di.plugins.fileopensave.providers.repository.model.RepositoryFile;
import org.pentaho.di.plugins.fileopensave.providers.vfs.model.VFSFile;
import org.pentaho.di.plugins.fileopensave.providers.vfs.model.VFSLocation;
import org.pentaho.di.plugins.fileopensave.providers.vfs.model.VFSTree;
import org.pentaho.di.plugins.fileopensave.service.FileCacheService;
import org.pentaho.di.plugins.fileopensave.service.ProviderServiceService;
import org.pentaho.di.ui.core.FileDialogOperation;
import org.pentaho.di.ui.core.FormDataBuilder;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.EnterStringDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.WarningDialog;
import org.pentaho.di.ui.core.events.dialog.FilterType;
import org.pentaho.di.ui.core.events.dialog.ProviderFilterType;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.util.SwtSvgImageUtil;

public class FileOpenSaveDialog
extends Dialog
implements FileDetails {
    private static final Class<?> PKG = FileOpenSaveDialog.class;
    private final Image logo = GUIResource.getInstance().getImageLogoSmall();
    private static final int OPTIONS = 68720;
    private static final String HELP_URL = Const.getDocUrl((String)"Products/Work_with_transformations#Open_a_transformation");
    private static final String FILE_EXTENSION_RESOURCE_PATH = "extensions/supported_file_filters.json";
    public static final String PATH_PARAM = "path";
    public static final String USE_SCHEMA_PARAM = "useSchema";
    public static final String CONNECTION_PARAM = "connection";
    public static final String PROVIDER_PARAM = "provider";
    public static final String PROVIDER_FILTER_PARAM = "providerFilter";
    public static final String FILTER_PARAM = "filter";
    public static final String DEFAULT_FILTER_PARAM = "defaultFilter";
    public static final String CONNECTION_FILTER_PARAM = "connectionTypes";
    public static final String ORIGIN_PARAM = "origin";
    public static final String FILENAME_PARAM = "filename";
    public static final String FILE_TYPE_PARM = "fileType";
    public static final String OBJECT_ID_PARAM = "objectId";
    public static final String NAME_PARAM = "name";
    public static final String PARENT_PARAM = "parent";
    public static final String TYPE_PARAM = "type";
    private static final String ALL_FILE_TYPES = "ALL";
    private static final String FILE_PERIOD = ".";
    private static final String PASTE_ACTION_SKIP = "skip";
    private static final String PASTE_ACTION_REPLACE = "replace";
    private static final String PASTE_ACTION_KEEP_BOTH = "keep-both";
    private FilterFileType[] validFileTypes;
    private String shellTitle = "Open";
    private String objectId;
    private String name;
    private String path;
    private String parentPath;
    private String type;
    private String connection;
    private String provider;
    private String providerFilter;
    private String command = "open";
    private FileDialogOperation fileDialogOperation = new FileDialogOperation(this.command);
    private Text txtFileName;
    private LogChannelInterface log;
    private int width;
    private int height;
    protected TreeViewer treeViewer;
    protected TableViewer fileTableViewer;
    protected Text txtSearch;
    protected Set<File> selectedItems = new HashSet<File>();
    protected String pasteAction = null;
    protected boolean isCutActionSelected = false;
    protected boolean isApplyToAll = false;
    private static final FileController FILE_CONTROLLER = new FileController(FileCacheService.INSTANCE.get(), ProviderServiceService.get());
    private Label lblComboFilter;
    private TypedComboBox<FilterFileType> typedComboBox;
    private Text txtNav;
    private Button btnSave;
    private Button btnOpen;
    private Button btnCancel;
    private Color clrGray;
    private Color clrBlack;
    private Image imgTime;
    private Image imgVFS;
    private Image imgFolder;
    private Image imgDisk;
    private Image imgFile;
    private Image imgTrans;
    private Image imgJob;
    private EnterStringDialog enterStringDialog;
    private WarningDialog warningDialog;
    private FlatButton flatBtnAdd;
    private FlatButton flatBtnRefresh;
    private FlatButton flatBtnUp;
    private FlatButton flatBtnDelete;
    private FlatButton flatBtnBack;
    private FlatButton flatBtnForward;
    private Boolean navigateBtnFlag = false;
    List<Object> selectionHistory = new ArrayList<Object>();
    int currentHistoryIndex;
    LabelProvider labelProvider = new LabelProvider(){

        public String getText(Object element) {
            if (element instanceof Tree) {
                return ((Tree)element).getName();
            }
            if (element instanceof Directory) {
                return ((Directory)element).getName();
            }
            if (element instanceof File) {
                return ((File)element).getName();
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof Tree) {
                if (element instanceof RecentTree) {
                    return FileOpenSaveDialog.this.imgTime;
                }
                if (element instanceof VFSTree) {
                    return FileOpenSaveDialog.this.imgVFS;
                }
                return FileOpenSaveDialog.this.imgDisk;
            }
            if (element instanceof Directory) {
                return FileOpenSaveDialog.this.imgFolder;
            }
            return null;
        }
    };

    public FileOpenSaveDialog(Shell parentShell, int width, int height, LogChannelInterface logger) {
        super(parentShell);
        this.log = logger;
        this.width = width;
        this.height = height;
        this.setShellStyle(68720);
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(FILE_EXTENSION_RESOURCE_PATH);
            String jsonString = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            this.validFileTypes = (FilterFileType[])objectMapper.readValue(jsonString, FilterFileType[].class);
        }
        catch (Exception ex) {
            this.log.logError("Could not load resource", (Throwable)ex);
        }
    }

    public void open(FileDialogOperation fileDialogOperation) {
        this.fileDialogOperation = fileDialogOperation;
        this.command = fileDialogOperation.getCommand();
        this.shellTitle = BaseMessages.getString(PKG, (String)("FileOpenSaveDialog.dialog." + this.command + ".title"), (String[])new String[0]);
        this.open();
        if (this.getShell() != null) {
            while (!this.getShell().isDisposed()) {
                if (this.getShell().getDisplay().readAndDispatch()) continue;
                this.getShell().getDisplay().sleep();
            }
        } else {
            this.clearState();
        }
    }

    protected void configureShell(Shell newShell) {
        newShell.setImage(this.logo);
        newShell.setText(this.shellTitle);
        PropsUI.getInstance().setLook((Control)newShell);
        newShell.setMinimumSize(845, 458);
    }

    protected Point getInitialSize() {
        return new Point(this.width, this.height);
    }

    protected void createOpenLayout(Composite parent, Composite select) {
        this.btnOpen = new Button(parent, 0);
        this.btnOpen.setEnabled(false);
        PropsUI.getInstance().setLook((Control)this.btnOpen);
        this.lblComboFilter.setLayoutData((Object)new FormDataBuilder().top((Control)select, 20).right((Control)((TypedComboBox)this.typedComboBox).viewer.getCombo(), -5).result());
        ((TypedComboBox)this.typedComboBox).viewer.getCombo().setLayoutData((Object)new FormDataBuilder().top((Control)select, 20).right((Control)this.btnOpen, -15).result());
        this.btnOpen.setLayoutData((Object)new FormDataBuilder().top((Control)select, 20).right((Control)this.btnCancel, -15).result());
        this.btnOpen.setText(BaseMessages.getString(PKG, (String)"file-open-save-plugin.app.open.button", (String[])new String[0]));
        this.btnOpen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (FileOpenSaveDialog.this.command.equals("selectFile") || FileOpenSaveDialog.this.command.equals("open") || FileOpenSaveDialog.this.command.equals("import")) {
                    if (StringUtils.isNotEmpty((String)FileOpenSaveDialog.this.name)) {
                        FileOpenSaveDialog.this.getShell().dispose();
                    }
                } else if (FileOpenSaveDialog.this.command.equals("selectFolder")) {
                    if (StringUtils.isNotEmpty((String)FileOpenSaveDialog.this.path)) {
                        FileOpenSaveDialog.this.getShell().dispose();
                    }
                } else if (FileOpenSaveDialog.this.command.equals("selectFileFolder") && (StringUtils.isNotEmpty((String)FileOpenSaveDialog.this.path) || StringUtils.isNotEmpty((String)FileOpenSaveDialog.this.name))) {
                    FileOpenSaveDialog.this.getShell().dispose();
                }
            }
        });
        this.btnCancel.setLayoutData((Object)new FormDataBuilder().top((Control)select, 20).right(100, -30).result());
        this.btnCancel.setText(BaseMessages.getString(PKG, (String)"file-open-save-plugin.app.cancel.button", (String[])new String[0]));
    }

    protected Control createContents(final Composite parent) {
        String[] stringArray;
        FormLayout formLayout = new FormLayout();
        formLayout.marginTop = 20;
        formLayout.marginBottom = 25;
        parent.setLayout((Layout)formLayout);
        Composite header = this.createHeader(parent);
        header.setLayoutData((Object)new FormDataBuilder().top(0, 0).left(0, 0).right(100, 0).result());
        Composite buttons = this.createButtonsBar(parent);
        buttons.setLayoutData((Object)new FormDataBuilder().top((Control)header, 25).left(0, 0).right(100, 0).result());
        FlatButton flatBtnHelp = new FlatButton(parent, 0).setEnabledImage(this.rasterImage("img/help.svg", 24, 24)).setDisabledImage(this.rasterImage("img/help.svg", 24, 24)).setEnabled(true).setLayoutData(new FormDataBuilder().bottom(100, 0).left(0, 20).result()).addListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileOpenSaveDialog.this.openHelpDialog();
            }
        });
        flatBtnHelp.getLabel().setText(BaseMessages.getString(PKG, (String)"file-open-save-plugin.app.help.label", (String[])new String[0]));
        Composite select = this.createFilesBrowser(parent);
        select.setLayoutData((Object)new FormDataBuilder().top((Control)buttons, 15).left(0, 0).right(100, 0).bottom((Control)flatBtnHelp.getLabel(), -20).result());
        this.typedComboBox = new TypedComboBox(parent);
        if (StringUtils.isNotEmpty((String)this.fileDialogOperation.getFilter())) {
            stringArray = this.fileDialogOperation.getFilter().split(",");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = ALL_FILE_TYPES;
        }
        String[] fileFilters = stringArray;
        ArrayList<FilterFileType> filterFileTypes = new ArrayList<FilterFileType>();
        int indexOfDefault = 0;
        for (int i = 0; i < fileFilters.length; ++i) {
            int finalI = i;
            String[] finalFileFilters = fileFilters;
            Optional<FilterFileType> optionalFileFilterType = Arrays.stream(this.validFileTypes).filter(filterFileType -> filterFileType.getId().equals(finalFileFilters[finalI])).findFirst();
            if (optionalFileFilterType.isPresent()) {
                filterFileTypes.add(optionalFileFilterType.get());
                if (!fileFilters[i].equals(this.fileDialogOperation.getDefaultFilter())) continue;
                indexOfDefault = i;
                continue;
            }
            this.log.logBasic("OptionalFileFilterType not found");
        }
        this.typedComboBox.addSelectionListener((typedComboBox, newSelection) -> {
            TreeSelection treeViewerSelection = (TreeSelection)this.treeViewer.getSelection();
            this.selectPath(treeViewerSelection.getFirstElement());
            this.processState();
        });
        this.typedComboBox.setLabelProvider(element -> {
            String fileExtensions = element.getValue().replace('\\', '*').replace('|', ',').replace("$", "");
            return element.getLabel() + " (" + fileExtensions + ")";
        });
        this.typedComboBox.setContent(filterFileTypes);
        this.typedComboBox.selectFirstItem();
        this.typedComboBox.setSelection((FilterFileType)filterFileTypes.get(indexOfDefault));
        this.lblComboFilter = new Label(parent, 0);
        this.lblComboFilter.setText(BaseMessages.getString(PKG, (String)"file-open-save-plugin.app.save.file-filter.label", (String[])new String[0]));
        PropsUI.getInstance().setLook((Control)this.lblComboFilter);
        this.btnCancel = new Button(parent, 0);
        PropsUI.getInstance().setLook((Control)this.btnCancel);
        this.btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileOpenSaveDialog.this.clearState();
                parent.dispose();
            }
        });
        if (this.isSaveState()) {
            this.createSaveLayout(parent, select);
        } else {
            this.createOpenLayout(parent, select);
        }
        this.treeViewer.setSelection((ISelection)new StructuredSelection(this.treeViewer.getTree().getItem(0).getData()));
        this.flatBtnBack.setEnabled(false);
        select.setFocus();
        this.setPreviousSelection();
        return parent;
    }

    private void setPreviousSelection() {
        FileProvider fileProvider;
        String targetPath = this.fileDialogOperation.getPath();
        if (StringUtils.isNotEmpty((String)targetPath)) {
            java.io.File filePath;
            if (targetPath.startsWith("file:///")) {
                targetPath = targetPath.substring(7);
            }
            if ((filePath = new java.io.File(targetPath)).isFile()) {
                targetPath = filePath.getParent();
            }
        }
        if (StringUtils.isNotEmpty((String)targetPath) && (fileProvider = this.determineProviderFromFilePath(this.fileDialogOperation)) != null) {
            char pathSplitter = targetPath.contains("/") ? (char)'/' : '\\';
            String[] targetPathArray = this.getStringsAtEachDirectory(targetPath, pathSplitter);
            if (targetPathArray == null) {
                return;
            }
            Tree tree = fileProvider.getTree();
            TreeItem[] treeItems = this.treeViewer.getTree().getItems();
            Tree selectedTree = null;
            for (TreeItem currentTreeItem : treeItems) {
                Object currentObject = currentTreeItem.getData();
                if (!(currentObject instanceof Tree) || !((Tree)currentObject).getName().equals(fileProvider.getName())) continue;
                selectedTree = (Tree)currentObject;
                break;
            }
            if (selectedTree != null) {
                File currentFile;
                StructuredSelection structuredSelection = new StructuredSelection(selectedTree);
                this.treeViewer.setSelection((ISelection)structuredSelection, true);
                List<File> children = tree.getChildren();
                this.sortFileList(children);
                int targetPathArrayIndex = !children.isEmpty() && children.get(0) instanceof RepositoryFile ? 1 : 0;
                do {
                    currentFile = null;
                    if (targetPathArrayIndex == targetPathArray.length) break;
                    for (File file : children) {
                        if (!this.isFileEqual(file, targetPathArray[targetPathArrayIndex])) continue;
                        currentFile = file;
                        break;
                    }
                    if (currentFile instanceof Directory) {
                        this.treeViewer.setSelection((ISelection)new StructuredSelection(currentFile), true);
                        this.treeViewer.setExpandedState((Object)currentFile, true);
                        try {
                            children = FILE_CONTROLLER.getFiles(currentFile, null, true);
                            if (children.size() > 0) {
                                this.sortFileList(children);
                            }
                        }
                        catch (FileException fileException) {
                            // empty catch block
                        }
                    }
                    ++targetPathArrayIndex;
                } while (currentFile != null);
            }
        }
    }

    private boolean isFileEqual(File file, String fileName) {
        boolean isFileEqual = false;
        if (file instanceof VFSFile) {
            if (file instanceof VFSLocation) {
                String pathName = ((VFSLocation)file).getConnectionPath();
                pathName = pathName.substring(0, pathName.length() - 1);
                isFileEqual = pathName.equals(fileName);
            } else if (((VFSFile)file).getConnectionPath().equals(fileName)) {
                isFileEqual = true;
            }
        } else if (file.getPath().equals(fileName) || fileName != null && fileName.length() > 0 && file.getPath().equals(fileName.substring(0, fileName.length() - 1))) {
            isFileEqual = true;
        }
        return isFileEqual;
    }

    private void sortFileList(List<File> children) {
        if (children.get(0) instanceof VFSFile) {
            children.sort((f1, f2) -> ((VFSFile)((Object)f2)).getConnectionPath().length() - ((VFSFile)((Object)f1)).getConnectionPath().length());
        } else {
            children.sort((f1, f2) -> f2.getPath().length() - f1.getPath().length());
        }
    }

    private String[] getStringsAtEachDirectory(String targetPath, char pathSplitter) {
        String[] targetPathArray;
        int currentTargetPathArrayIndex = 0;
        if (pathSplitter == '\\') {
            int arraySize = targetPath.split("\\\\").length;
            targetPathArray = new String[arraySize];
            for (int i = 0; i < targetPath.length(); ++i) {
                if (targetPath.charAt(i) != pathSplitter && i != targetPath.length() - 1) continue;
                targetPathArray[currentTargetPathArrayIndex] = targetPath.substring(0, i + 1);
                ++currentTargetPathArrayIndex;
            }
        } else {
            if (targetPath.contains("pvfs://") || targetPath.contains("hc://")) {
                int indexOfDoubleSlash = targetPath.indexOf("//") + 2;
                int arraySize = targetPath.substring(indexOfDoubleSlash).split(String.valueOf(pathSplitter)).length;
                targetPathArray = new String[arraySize];
                for (int i = indexOfDoubleSlash; i < targetPath.length(); ++i) {
                    if (targetPath.charAt(i) != pathSplitter) continue;
                    targetPathArray[currentTargetPathArrayIndex] = targetPath.substring(0, i);
                    ++currentTargetPathArrayIndex;
                }
            } else {
                int arraySize = targetPath.split(String.valueOf(pathSplitter)).length;
                if (arraySize == 0) {
                    return null;
                }
                targetPathArray = new String[arraySize];
                targetPathArray[currentTargetPathArrayIndex] = String.valueOf(pathSplitter);
                for (int i = ++currentTargetPathArrayIndex; i < targetPath.length(); ++i) {
                    if (targetPath.charAt(i) != pathSplitter) continue;
                    targetPathArray[currentTargetPathArrayIndex] = targetPath.substring(0, i);
                    ++currentTargetPathArrayIndex;
                }
            }
            targetPathArray[currentTargetPathArrayIndex] = targetPath;
        }
        return targetPathArray;
    }

    private String createFileNameFromPath(String filePath) {
        String tempName = null;
        if (filePath != null && filePath.contains("/")) {
            tempName = filePath.substring(filePath.lastIndexOf(47) + 1);
        } else if (filePath != null && filePath.contains("\\")) {
            tempName = filePath.substring(filePath.lastIndexOf(92) + 1);
        }
        return tempName;
    }

    private void clearState() {
        this.parentPath = null;
        this.type = null;
        this.provider = null;
        this.providerFilter = null;
        this.path = null;
    }

    private void createSaveLayout(Composite parent, Composite select) {
        this.txtFileName = new Text(parent, 18436);
        Label filenameLabel = new Label(parent, 0);
        filenameLabel.setText(BaseMessages.getString(PKG, (String)"file-open-save-plugin.app.save.file-name.label", (String[])new String[0]));
        PropsUI.getInstance().setLook((Control)filenameLabel);
        PropsUI.getInstance().setLook((Control)this.txtFileName);
        this.txtFileName.setSize(40, 40);
        this.btnSave = new Button(parent, 0);
        this.btnSave.setEnabled(false);
        filenameLabel.setLayoutData((Object)new FormDataBuilder().top((Control)select, 20).left((Control)parent, 110).result());
        this.txtFileName.setLayoutData((Object)new FormDataBuilder().top((Control)select, 20).left((Control)filenameLabel, 10).right((Control)this.lblComboFilter, -15).result());
        this.lblComboFilter.setLayoutData((Object)new FormDataBuilder().top((Control)select, 20).right((Control)((TypedComboBox)this.typedComboBox).viewer.getCombo(), -5).result());
        ((TypedComboBox)this.typedComboBox).viewer.getCombo().setLayoutData((Object)new FormDataBuilder().top((Control)select, 20).right((Control)this.btnSave, -15).result());
        this.txtFileName.addModifyListener(modifyEvent -> this.processState());
        if (StringUtils.isNotEmpty((String)this.fileDialogOperation.getFilename())) {
            this.txtFileName.setText(this.fileDialogOperation.getFilename());
        }
        PropsUI.getInstance().setLook((Control)this.btnSave);
        this.btnSave.setLayoutData((Object)new FormDataBuilder().top((Control)select, 20).right((Control)this.btnCancel, -15).result());
        this.btnSave.setText(BaseMessages.getString(PKG, (String)"file-open-save-plugin.app.save.button", (String[])new String[0]));
        this.btnSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StructuredSelection treeSelection;
                StructuredSelection structuredSelection;
                if (FileOpenSaveDialog.this.fileTableViewer.getSelection().isEmpty()) {
                    treeSelection = structuredSelection = (StructuredSelection)FileOpenSaveDialog.this.treeViewer.getSelection();
                } else {
                    structuredSelection = (StructuredSelection)FileOpenSaveDialog.this.fileTableViewer.getSelection();
                    treeSelection = (StructuredSelection)FileOpenSaveDialog.this.treeViewer.getSelection();
                }
                if (structuredSelection.getFirstElement() instanceof File && FileOpenSaveDialog.this.txtFileName.getText() != null && StringUtils.isNotEmpty((String)FileOpenSaveDialog.this.txtFileName.getText())) {
                    FileOpenSaveDialog.this.processOnSavePressed((File)structuredSelection.getFirstElement());
                    FILE_CONTROLLER.clearCache((File)treeSelection.getFirstElement());
                }
            }
        });
        this.btnCancel.setLayoutData((Object)new FormDataBuilder().top((Control)select, 20).right(100, -30).result());
        this.btnCancel.setText(BaseMessages.getString(PKG, (String)"file-open-save-plugin.app.cancel.button", (String[])new String[0]));
    }

    private void processOnSavePressed(File file) {
        if (file != null) {
            this.setStateVariablesFromSelection(file);
            if (file instanceof RepositoryFile) {
                this.path = null;
            }
            String fileName = this.txtFileName.getText();
            if (this.typedComboBox.getSelection().getId().equalsIgnoreCase(String.valueOf(FilterType.XML)) && !fileName.endsWith(".xml")) {
                this.name = fileName + ".xml";
            } else if (this.fileDialogOperation.getCommand().equalsIgnoreCase("export")) {
                if (this.typedComboBox.getSelection().getId().equalsIgnoreCase(String.valueOf(FilterType.KETTLE_TRANS)) && !fileName.endsWith(".ktr")) {
                    this.name = fileName + ".ktr";
                } else if (this.typedComboBox.getSelection().getId().equalsIgnoreCase(String.valueOf(FilterType.KETTLE_JOB)) && !fileName.endsWith(".kjb")) {
                    this.name = fileName + ".kjb";
                }
            } else {
                this.name = this.fileDialogOperation.getCommand().equalsIgnoreCase("exportAll") ? fileName + ".zip" : fileName;
            }
            this.getShell().dispose();
        }
    }

    public Composite createHeader(Composite parent) {
        Composite headerComposite = new Composite(parent, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.marginLeft = 20;
        formLayout.marginRight = 20;
        headerComposite.setLayout((Layout)formLayout);
        PropsUI.getInstance().setLook((Control)headerComposite);
        Label lblSelect = new Label(headerComposite, 16384);
        PropsUI.getInstance().setLook((Control)lblSelect);
        lblSelect.setText(StringUtils.capitalize((String)this.shellTitle));
        Font bigFont = new Font((Device)this.getShell().getDisplay(), (FontData[])Arrays.stream(lblSelect.getFont().getFontData()).map(fd -> {
            fd.setHeight(22);
            fd.setStyle(1);
            return fd;
        }).toArray(FontData[]::new));
        lblSelect.setFont(bigFont);
        this.getShell().addDisposeListener(e -> bigFont.dispose());
        Color clrWhite = new Color((Device)this.getShell().getDisplay(), 255, 255, 255);
        Composite searchComp = new Composite(headerComposite, 2048);
        PropsUI.getInstance().setLook((Control)searchComp);
        searchComp.addDisposeListener(e -> clrWhite.dispose());
        searchComp.setLayoutData((Object)new FormDataBuilder().right(100, 0).result());
        searchComp.setBackground(clrWhite);
        RowLayout searchLayout = new RowLayout();
        searchLayout.center = true;
        searchComp.setLayout((Layout)searchLayout);
        Label lblSearch = new Label(searchComp, 0);
        PropsUI.getInstance().setLook((Control)lblSearch);
        lblSearch.setLayoutData((Object)new RowData());
        lblSearch.setBackground(clrWhite);
        lblSearch.setImage(this.rasterImage("img/Search.S_D.svg", 25, 25));
        RowData rd = new RowData();
        rd.width = 200;
        this.txtSearch = new Text(searchComp, 0);
        PropsUI.getInstance().setLook((Control)this.txtSearch);
        this.txtSearch.setBackground(clrWhite);
        this.txtSearch.setLayoutData((Object)rd);
        this.txtSearch.addTraverseListener(traverseEvent -> {
            if (traverseEvent.detail == 4) {
                this.performSearch();
            }
        });
        FlatButton flatBtnClr = new FlatButton(searchComp, 0).setEnabledImage(this.rasterImage("img/Close.S_D.svg", 25, 25)).setDisabledImage(this.rasterImage("img/Close.S_D_disabled.svg", 25, 25)).setEnabled(true).setLayoutData(new RowData()).addListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (StringUtils.isEmpty((String)FileOpenSaveDialog.this.txtSearch.getText())) {
                    return;
                }
                FileOpenSaveDialog.this.txtSearch.setText("");
                FileOpenSaveDialog.this.restorePriorSearchState();
            }
        });
        this.txtSearch.addModifyListener(modifyEvent -> flatBtnClr.setEnabled(!StringUtils.isEmpty((String)this.txtSearch.getText())));
        headerComposite.layout();
        return headerComposite;
    }

    private void performSearch() {
        TreeSelection treeViewerSelection = (TreeSelection)this.treeViewer.getSelection();
        this.selectPath(treeViewerSelection.getFirstElement(), false, true);
        this.processState();
    }

    private void restorePriorSearchState() {
        TreeSelection treeViewerSelection = (TreeSelection)this.treeViewer.getSelection();
        this.selectPath(treeViewerSelection.getFirstElement());
        this.processState();
    }

    private Composite createButtonsBar(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        PropsUI.getInstance().setLook((Control)buttons);
        FormLayout formLayout = new FormLayout();
        formLayout.marginLeft = 20;
        formLayout.marginRight = 20;
        buttons.setLayout((Layout)formLayout);
        this.flatBtnBack = new FlatButton(buttons, 0).setEnabledImage(this.rasterImage("img/Backwards.S_D.svg", 32, 32)).setDisabledImage(this.rasterImage("img/Backwards.S_D_disabled.svg", 32, 32)).setToolTipText(BaseMessages.getString(PKG, (String)"file-open-save-plugin.app.back.button", (String[])new String[0])).setEnabled(false).addListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!FileOpenSaveDialog.this.selectionHistory.isEmpty()) {
                    int currentIndex;
                    if ((currentIndex = FileOpenSaveDialog.this.currentHistoryIndex--) > 0) {
                        Object previousPath = FileOpenSaveDialog.this.selectionHistory.get(currentIndex - 1);
                        FileOpenSaveDialog.this.navigateBtnFlag = true;
                        FileOpenSaveDialog.this.treeViewer.setSelection((ISelection)new StructuredSelection(previousPath));
                        FileOpenSaveDialog.this.flatBtnForward.setEnabled(true);
                    } else {
                        FileOpenSaveDialog.this.flatBtnBack.setEnabled(false);
                    }
                } else {
                    FileOpenSaveDialog.this.flatBtnBack.setEnabled(false);
                }
            }
        });
        this.flatBtnForward = new FlatButton(buttons, 0).setEnabledImage(this.rasterImage("img/Forwards.S_D.svg", 32, 32)).setDisabledImage(this.rasterImage("img/Forwards.S_D_disabled.svg", 32, 32)).setToolTipText(BaseMessages.getString(PKG, (String)"file-open-save-plugin.app.forward.button", (String[])new String[0])).setEnabled(false).setLayoutData(new FormDataBuilder().left((Control)this.flatBtnBack.getLabel(), 0).result()).addListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!FileOpenSaveDialog.this.selectionHistory.isEmpty()) {
                    int currentIndex;
                    if ((currentIndex = FileOpenSaveDialog.this.currentHistoryIndex++) >= 0 && currentIndex < FileOpenSaveDialog.this.selectionHistory.size() - 1) {
                        Object nextPath = FileOpenSaveDialog.this.selectionHistory.get(currentIndex + 1);
                        FileOpenSaveDialog.this.navigateBtnFlag = true;
                        FileOpenSaveDialog.this.treeViewer.setSelection((ISelection)new StructuredSelection(nextPath));
                        FileOpenSaveDialog.this.flatBtnBack.setEnabled(true);
                        FileOpenSaveDialog.this.flatBtnForward.setEnabled(FileOpenSaveDialog.this.currentHistoryIndex != FileOpenSaveDialog.this.selectionHistory.size() - 1);
                    } else {
                        FileOpenSaveDialog.this.flatBtnForward.setEnabled(false);
                    }
                } else {
                    FileOpenSaveDialog.this.flatBtnForward.setEnabled(false);
                }
            }
        });
        Composite fileButtons = new Composite(buttons, 0);
        PropsUI.getInstance().setLook((Control)fileButtons);
        fileButtons.setLayout((Layout)new RowLayout());
        fileButtons.setLayoutData((Object)new FormDataBuilder().right(100, 0).result());
        this.flatBtnUp = new FlatButton(fileButtons, 0).setEnabledImage(this.rasterImage("img/Up_Folder.S_D.svg", 32, 32)).setDisabledImage(this.rasterImage("img/Up_Folder.S_D_disabled.svg", 32, 32)).setToolTipText(BaseMessages.getString(PKG, (String)"file-open-save-plugin.app.up-directory.button", (String[])new String[0])).setLayoutData(new RowData()).setEnabled(false).addListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TreePath[] paths;
                TreeSelection treeSelection = (TreeSelection)FileOpenSaveDialog.this.treeViewer.getSelection();
                if (!treeSelection.isEmpty() && FileOpenSaveDialog.this.hasParentFolder((IStructuredSelection)treeSelection) && (paths = treeSelection.getPaths()).length > 0) {
                    TreePath parentPath = paths[paths.length - 1].getParentPath();
                    StructuredSelection currentSelection = new StructuredSelection(parentPath.getLastSegment());
                    FileOpenSaveDialog.this.treeViewer.setSelection((ISelection)currentSelection);
                }
            }
        });
        this.flatBtnAdd = new FlatButton(fileButtons, 0).setEnabledImage(this.rasterImage("img/New_Folder.S_D.svg", 32, 32)).setDisabledImage(this.rasterImage("img/New_Folder.S_D_disabled.svg", 32, 32)).setToolTipText(BaseMessages.getString(PKG, (String)"file-open-save-plugin.app.add-folder.button", (String[])new String[0])).setLayoutData(new RowData()).setEnabled(false).addListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileOpenSaveDialog.this.enterStringDialog = new EnterStringDialog(FileOpenSaveDialog.this.getShell(), "", BaseMessages.getString((Class)PKG, (String)"file-open-save-plugin.app.add-folder.shell-text", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"file-open-save-plugin.app.add-folder.line-text", (String[])new String[0]));
                String newFolderName = FileOpenSaveDialog.this.enterStringDialog.open();
                if (StringUtils.isNotEmpty((String)newFolderName)) {
                    FileOpenSaveDialog.this.addFolder(newFolderName);
                }
            }
        });
        this.flatBtnDelete = new FlatButton(fileButtons, 0).setEnabledImage(this.rasterImage("img/Close.S_D.svg", 32, 32)).setDisabledImage(this.rasterImage("img/Close.S_D_disabled.svg", 32, 32)).setToolTipText(BaseMessages.getString(PKG, (String)"file-open-save-plugin.app.delete.button", (String[])new String[0])).setLayoutData(new RowData()).setEnabled(false).addListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Listener ok = new Listener(){

                    public void handleEvent(Event event) {
                        FileOpenSaveDialog.this.deleteFileOrFolder();
                    }
                };
                Listener cancel = new Listener(){

                    public void handleEvent(Event event) {
                    }
                };
                LinkedHashMap<String, Object> listenerMap = new LinkedHashMap<String, Object>();
                listenerMap.put(BaseMessages.getString((String)"System.Button.OK"), ok);
                listenerMap.put(BaseMessages.getString((String)"System.Button.Cancel"), cancel);
                String title = "";
                String message = "";
                StructuredSelection fileTableViewerSelection = (StructuredSelection)FileOpenSaveDialog.this.fileTableViewer.getSelection();
                if (!fileTableViewerSelection.isEmpty()) {
                    File fileOrFolderToDelete = (File)fileTableViewerSelection.getFirstElement();
                    List messageList = fileTableViewerSelection.size() == 1 ? (fileOrFolderToDelete instanceof Directory ? FileOpenSaveDialog.this.deleteBtnMessages("folder", fileOrFolderToDelete.getName(), 1) : FileOpenSaveDialog.this.deleteBtnMessages("file", fileOrFolderToDelete.getName(), 1)) : FileOpenSaveDialog.this.deleteBtnMessages("many", "", fileTableViewerSelection.size());
                    title = (String)messageList.get(0);
                    message = (String)messageList.get(1);
                    FileOpenSaveDialog.this.warningDialog = new WarningDialog(FileOpenSaveDialog.this.getShell(), title, message, listenerMap);
                    FileOpenSaveDialog.this.warningDialog.open();
                }
            }
        });
        this.flatBtnRefresh = new FlatButton(fileButtons, 0).setEnabledImage(this.rasterImage("img/Refresh.S_D.svg", 32, 32)).setDisabledImage(this.rasterImage("img/Refresh.S_D_disabled.svg", 32, 32)).setToolTipText(BaseMessages.getString(PKG, (String)"file-open-save-plugin.app.refresh.button", (String[])new String[0])).setLayoutData(new RowData()).setEnabled(true).addListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileOpenSaveDialog.this.refreshDisplay(selectionEvent);
            }
        });
        this.txtNav = new Text(buttons, 2048);
        this.txtNav.setEditable(true);
        PropsUI.getInstance().setLook((Control)this.txtNav);
        this.txtNav.setBackground(this.getShell().getDisplay().getSystemColor(1));
        this.txtNav.setLayoutData((Object)new FormDataBuilder().left((Control)this.flatBtnForward.getLabel(), 10).right((Control)fileButtons, -10).height(32).result());
        this.txtNav.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 4) {
                    TreeSelection previousSelection = FileOpenSaveDialog.this.treeViewer.getSelection().isEmpty() ? new TreeSelection() : (TreeSelection)FileOpenSaveDialog.this.treeViewer.getSelection();
                    boolean isFilePresent = false;
                    List<Object> children = new ArrayList<Object>();
                    if (!previousSelection.isEmpty()) {
                        Object fileOrTree;
                        Object object = fileOrTree = previousSelection.isEmpty() ? null : previousSelection.getFirstElement();
                        if (fileOrTree == null) {
                            return;
                        }
                        if (fileOrTree instanceof Tree) {
                            children = ((Tree)fileOrTree).getChildren();
                        } else if (fileOrTree instanceof File) {
                            TreePath[] treePaths = previousSelection.getPaths();
                            Object object2 = treePaths[0].getFirstSegment();
                            children = ((Tree)object2).getChildren();
                        }
                    }
                    try {
                        String pathToSearchFor = FileOpenSaveDialog.this.txtNav.getText();
                        isFilePresent = FileOpenSaveDialog.this.searchForFileInTreeViewer(pathToSearchFor, children);
                    }
                    catch (FileException fileException) {
                        // empty catch block
                    }
                    if (!isFilePresent) {
                        FileOpenSaveDialog.this.treeViewer.setSelection((ISelection)previousSelection);
                    }
                }
            }
        });
        return buttons;
    }

    private void addSelectionHistoryItems(Object selectionNode) {
        this.selectionHistory.add(selectionNode);
        this.currentHistoryIndex = this.selectionHistory.size() - 1;
    }

    public boolean searchForFileInTreeViewer(String path, List<Object> children) throws FileException {
        Optional<Object> file = Optional.empty();
        Optional<Object> parent = Optional.empty();
        if (!children.isEmpty()) {
            List<File> childrenAsFiles = new ArrayList<File>(children.size());
            for (Object object : children) {
                childrenAsFiles.add((File)object);
            }
            file = this.getFileMatch(path, childrenAsFiles);
            while (file.isPresent()) {
                if (parent.isPresent() && (path.endsWith("/") || path.endsWith("\\"))) {
                    path = path.substring(0, path.length() - 1);
                }
                if (file.get() instanceof VFSFile && ((VFSFile)((Object)file.get())).getConnectionPath().equals(path) || ((File)file.get()).getPath().equals(path)) break;
                childrenAsFiles = FILE_CONTROLLER.getFiles((File)file.get(), null, true);
                if (!file.isPresent()) continue;
                this.treeViewer.setSelection((ISelection)new StructuredSelection(file.get()), true);
                parent = file;
                file = this.getFileMatch(path, childrenAsFiles);
            }
        }
        if (file.isPresent() && !(file.get() instanceof Directory)) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection(parent.get()), true);
            this.treeViewer.setExpandedState(parent.get(), true);
            this.fileTableViewer.setSelection((ISelection)new StructuredSelection(file.get()), true);
        } else if (file.isPresent()) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection(file.get()), true);
            this.treeViewer.setExpandedState(file.get(), true);
            this.fileTableViewer.setSelection((ISelection)new StructuredSelection(file.get()), true);
        }
        return file.isPresent();
    }

    private Optional<File> getFileMatch(String path, List<File> childrenAsFiles) {
        Optional<File> file = childrenAsFiles.get(0) instanceof VFSFile ? childrenAsFiles.stream().filter(f -> {
            boolean pathIsLonger;
            boolean bl = pathIsLonger = path.length() > ((VFSFile)((Object)f)).getConnectionPath().length();
            if (pathIsLonger) {
                return path.startsWith(((VFSFile)((Object)f)).getConnectionPath());
            }
            return ((VFSFile)((Object)f)).getConnectionPath().startsWith(path);
        }).sorted((f1, f2) -> ((VFSFile)((Object)f2)).getConnectionPath().length() - ((VFSFile)((Object)f1)).getConnectionPath().length()).filter(f -> path.contains(((VFSFile)((Object)f)).getConnectionPath())).findFirst() : childrenAsFiles.stream().filter(f -> {
            boolean pathIsLonger;
            boolean bl = pathIsLonger = path.length() > f.getPath().length();
            if (pathIsLonger) {
                return path.startsWith(f.getPath());
            }
            return f.getPath().startsWith(path);
        }).sorted((f1, f2) -> f2.getPath().length() - f1.getPath().length()).filter(f -> path.contains(f.getPath())).findFirst();
        return file;
    }

    private void refreshDisplay(SelectionEvent selectionEvent) {
        StructuredSelection fileTableViewerSelection = (StructuredSelection)this.fileTableViewer.getSelection();
        TreeSelection treeViewerSelection = (TreeSelection)this.treeViewer.getSelection();
        FileProvider fileProvider = null;
        if (!treeViewerSelection.isEmpty()) {
            if (treeViewerSelection.getFirstElement() instanceof Tree) {
                try {
                    fileProvider = ProviderServiceService.get().get(((Tree)treeViewerSelection.getFirstElement()).getProvider());
                }
                catch (Exception ex) {
                    this.log.logDebug("Unable to find provider");
                }
                for (Object file : ((Tree)treeViewerSelection.getFirstElement()).getChildren()) {
                    FILE_CONTROLLER.clearCache((File)file);
                }
                this.treeViewer.collapseAll();
            } else {
                try {
                    fileProvider = ProviderServiceService.get().get(((File)treeViewerSelection.getFirstElement()).getProvider());
                }
                catch (Exception ex) {
                    this.log.logDebug("Unable to find provider");
                }
                FILE_CONTROLLER.clearCache((File)treeViewerSelection.getFirstElement());
            }
            if (fileProvider != null) {
                fileProvider.clearProviderCache();
            }
            if (treeViewerSelection.getFirstElement() instanceof File && StringUtils.isBlank((String)((File)treeViewerSelection.getFirstElement()).getParent())) {
                this.treeViewer.collapseAll();
            }
            this.treeViewer.refresh(treeViewerSelection.getFirstElement(), true);
            this.fileTableViewer.refresh(true);
            this.treeViewer.setSelection((ISelection)treeViewerSelection, true);
        } else if (treeViewerSelection.isEmpty() && fileTableViewerSelection.isEmpty()) {
            try {
                fileProvider = ProviderServiceService.get().get(this.fileDialogOperation.getProvider());
                fileProvider.clearProviderCache();
                this.treeViewer.setInput((Object)FILE_CONTROLLER.load(ProviderFilterType.ALL_PROVIDERS.toString()).toArray());
                this.treeViewer.refresh(true);
                this.fileTableViewer.refresh(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getProviderFilter() {
        return this.providerFilter;
    }

    public void setProviderFilter(String providerFilter) {
        this.providerFilter = providerFilter;
    }

    private Composite createFilesBrowser(Composite parent) {
        this.clrGray = this.getShell().getDisplay().getSystemColor(15);
        this.clrBlack = this.getShell().getDisplay().getSystemColor(2);
        this.imgTime = this.rasterImage("img/Time.S_D.svg", 25, 25);
        this.imgVFS = this.rasterImage("img/VFS_D.svg", 25, 25);
        this.imgFolder = this.rasterImage("img/file_icons/Archive.S_D.svg", 25, 25);
        this.imgDisk = this.rasterImage("img/Disk.S_D.svg", 25, 25);
        this.imgFile = this.rasterImage("img/file_icons/Doc.S_D.svg", 25, 25);
        this.imgTrans = this.rasterImage("img/file_icons/Transformation.S_D.svg", 25, 25);
        this.imgJob = this.rasterImage("img/file_icons/Job.S_D.svg", 25, 25);
        Composite browser = new Composite(parent, 0);
        PropsUI.getInstance().setLook((Control)browser);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginRight = 0;
        gridLayout.marginLeft = 0;
        browser.setLayout((Layout)gridLayout);
        SashForm sashForm = new SashForm(browser, 256);
        PropsUI.getInstance().setLook((Control)sashForm);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeViewer = new TreeViewer((Composite)sashForm, 68352);
        PropsUI.getInstance().setLook((Control)this.treeViewer.getTree());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.setContentProvider((IContentProvider)new FileTreeContentProvider(FILE_CONTROLLER, this));
        this.treeViewer.setInput((Object)FILE_CONTROLLER.load(this.providerFilter).toArray());
        this.treeViewer.addPostSelectionChangedListener(e -> {
            IStructuredSelection selection = (IStructuredSelection)e.getSelection();
            this.flatBtnUp.setEnabled(this.hasParentFolder(selection));
            Object selectedNode = selection.getFirstElement();
            if (selectedNode != null && !this.treeViewer.getExpandedState(selectedNode)) {
                this.treeViewer.refresh(selectedNode, true);
                this.treeViewer.setExpandedState(selectedNode, true);
            }
            this.selectPath(selectedNode);
            this.fileTableViewer.setSelection((ISelection)new StructuredSelection());
            this.txtSearch.setText("");
            if (this.selectionHistory != null) {
                this.flatBtnBack.setEnabled(this.currentHistoryIndex != 0);
            }
            this.processState();
        });
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection selection = (IStructuredSelection)selectionChangedEvent.getSelection();
                Object selectedNode = selection.getFirstElement();
                if (selectionChangedEvent.getSelection() instanceof TreeSelection && !FileOpenSaveDialog.this.navigateBtnFlag.booleanValue()) {
                    FileOpenSaveDialog.this.addSelectionHistoryItems(selectedNode);
                }
                FileOpenSaveDialog.this.navigateBtnFlag = false;
            }
        });
        this.fileTableViewer = new TableViewer((Composite)sashForm, 68098);
        PropsUI.getInstance().setLook((Control)this.fileTableViewer.getTable());
        this.fileTableViewer.getTable().setHeaderVisible(true);
        Menu fileTableMenu = new Menu((Control)this.fileTableViewer.getTable());
        final MenuItem copyItem = new MenuItem(fileTableMenu, 0);
        copyItem.setText(BaseMessages.getString(PKG, (String)"file-open-save-plugin.app.copy", (String[])new String[0]));
        SelectionAdapter copyAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileOpenSaveDialog.this.performCopy(e);
            }
        };
        copyItem.addSelectionListener((SelectionListener)copyAdapter);
        final MenuItem pasteItem = new MenuItem(fileTableMenu, 0);
        pasteItem.setText(BaseMessages.getString(PKG, (String)"file-open-save-plugin.app.paste", (String[])new String[0]));
        SelectionAdapter pasteAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileOpenSaveDialog.this.performPaste();
                FileOpenSaveDialog.this.refreshDisplay(e);
            }
        };
        pasteItem.addSelectionListener((SelectionListener)pasteAdapter);
        final MenuItem cutItem = new MenuItem(fileTableMenu, 0);
        cutItem.setText(BaseMessages.getString(PKG, (String)"file-open-save-plugin.app.cut", (String[])new String[0]));
        SelectionAdapter cutAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileOpenSaveDialog.this.performCut(e);
            }
        };
        cutItem.addSelectionListener((SelectionListener)cutAdapter);
        final MenuItem deleteItem = new MenuItem(fileTableMenu, 0);
        deleteItem.setText(BaseMessages.getString(PKG, (String)"file-open-save-plugin.app.delete", (String[])new String[0]));
        SelectionAdapter deleteAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileOpenSaveDialog.this.performDelete(e);
            }
        };
        deleteItem.addSelectionListener((SelectionListener)deleteAdapter);
        final MenuItem renameItem = new MenuItem(fileTableMenu, 0);
        renameItem.setText(BaseMessages.getString(PKG, (String)"file-open-save-plugin.app.rename", (String[])new String[0]));
        SelectionAdapter renameAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileOpenSaveDialog.this.performRename(e);
            }
        };
        renameItem.addSelectionListener((SelectionListener)renameAdapter);
        if (Spoon.getInstance().rep == null) {
            this.fileTableViewer.getTable().setMenu(fileTableMenu);
        }
        this.fileTableViewer.getTable().addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                pasteItem.setEnabled(false);
                copyItem.setEnabled(false);
                cutItem.setEnabled(false);
                deleteItem.setEnabled(false);
                renameItem.setEnabled(false);
                int[] selectionIndices = FileOpenSaveDialog.this.fileTableViewer.getTable().getSelectionIndices();
                if (selectionIndices.length > 0) {
                    copyItem.setEnabled(true);
                    cutItem.setEnabled(true);
                    deleteItem.setEnabled(true);
                    renameItem.setEnabled(true);
                }
                if (FileOpenSaveDialog.this.selectedItems.size() > 0) {
                    if (selectionIndices.length == 0) {
                        IStructuredSelection treeViewerSelection = (IStructuredSelection)FileOpenSaveDialog.this.treeViewer.getSelection();
                        File destFolder = (File)treeViewerSelection.getFirstElement();
                        if (!StringUtils.equalsIgnoreCase((String)destFolder.getName(), (String)((File)FileOpenSaveDialog.this.selectedItems.stream().findFirst().get()).getName())) {
                            pasteItem.setEnabled(true);
                        }
                    } else if (StringUtils.equalsIgnoreCase((String)FileOpenSaveDialog.this.fileTableViewer.getTable().getItem(selectionIndices[0]).getText(1), (String)"Folder") && !StringUtils.equalsIgnoreCase((String)FileOpenSaveDialog.this.fileTableViewer.getTable().getItem(selectionIndices[0]).getText(0), (String)((File)FileOpenSaveDialog.this.selectedItems.stream().findFirst().get()).getName())) {
                        pasteItem.setEnabled(true);
                    }
                }
            }
        });
        this.fileTableViewer.getTable().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
                if (FileOpenSaveDialog.this.fileTableViewer.getTable().getItem(new Point(mouseEvent.x, mouseEvent.y)) == null) {
                    FileOpenSaveDialog.this.fileTableViewer.getTable().deselectAll();
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        TableViewerColumn tvcName = new TableViewerColumn(this.fileTableViewer, 0);
        tvcName.getColumn().setText(BaseMessages.getString(PKG, (String)"file-open-save-plugin.files.name.header", (String[])new String[0]));
        tvcName.getColumn().setWidth(250);
        ColumnLabelProvider clpName = new ColumnLabelProvider(){

            public String getText(Object element) {
                File f = (File)element;
                return f.getName();
            }

            public Image getImage(Object element) {
                File file;
                if (element instanceof Directory) {
                    return FileOpenSaveDialog.this.imgFolder;
                }
                if (element instanceof File && (file = (File)element) != null && file.getType() != null) {
                    if (file.getType().equals("transformation")) {
                        return FileOpenSaveDialog.this.imgTrans;
                    }
                    if (file.getType().equals("job")) {
                        return FileOpenSaveDialog.this.imgJob;
                    }
                    return FileOpenSaveDialog.this.imgFile;
                }
                return null;
            }
        };
        tvcName.setLabelProvider((CellLabelProvider)clpName);
        TableViewerColumn tvcType = new TableViewerColumn(this.fileTableViewer, 0);
        tvcType.getColumn().setText(BaseMessages.getString(PKG, (String)"file-open-save-plugin.files.type.header", (String[])new String[0]));
        tvcType.getColumn().setWidth(100);
        tvcType.getColumn().setResizable(false);
        tvcType.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Color getForeground(Object element) {
                return FileOpenSaveDialog.this.clrGray;
            }

            public String getText(Object element) {
                return super.getText((Object)StringUtils.capitalize((String)((File)element).getType()));
            }
        });
        TableViewerColumn tvcModified = new TableViewerColumn(this.fileTableViewer, 0);
        tvcModified.getColumn().setText(BaseMessages.getString(PKG, (String)"file-open-save-plugin.files.modified.header", (String[])new String[0]));
        tvcModified.getColumn().setWidth(140);
        tvcModified.getColumn().setResizable(false);
        tvcModified.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yy hh:mm aa");

            public Color getForeground(Object element) {
                return FileOpenSaveDialog.this.clrGray;
            }

            public String getText(Object element) {
                try {
                    return super.getText((Object)this.sdf.format(((File)element).getDate()));
                }
                catch (Exception e) {
                    return "";
                }
            }
        });
        this.fileTableViewer.getTable().addListener(11, e -> {
            Rectangle r = this.fileTableViewer.getTable().getClientArea();
            tvcName.getColumn().setWidth(Math.max(150, r.width - tvcType.getColumn().getWidth() - tvcModified.getColumn().getWidth()));
        });
        this.fileTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fileTableViewer.addPostSelectionChangedListener(e -> {
            IStructuredSelection selection = (IStructuredSelection)e.getSelection();
            Object selectedNode = selection.getFirstElement();
            if (selectedNode instanceof File) {
                if (this.txtFileName != null && !(selectedNode instanceof Directory)) {
                    this.txtFileName.setText(((File)selectedNode).getName());
                    this.name = ((File)selectedNode).getName();
                }
                this.flatBtnDelete.setEnabled(((File)selectedNode).isCanEdit());
                this.processState();
                this.txtNav.setText(this.getNavigationPath((File)selectedNode));
            }
        });
        this.fileTableViewer.addDoubleClickListener(e -> {
            Object selection = ((IStructuredSelection)e.getSelection()).getFirstElement();
            if (selection instanceof Directory) {
                ArrayList<Directory> parentDirectories = new ArrayList<Directory>();
                Directory directory = (Directory)selection;
                while (directory != null && !this.treeViewer.getExpandedState((Object)directory)) {
                    parentDirectories.add(directory);
                    try {
                        File file = FILE_CONTROLLER.getParent(directory);
                        if (!(file instanceof Directory) || !StringUtils.isNotEmpty((String)file.getPath())) break;
                        directory = (Directory)file;
                    }
                    catch (InvalidFileProviderException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                for (int i = parentDirectories.size() - 1; i >= 0; --i) {
                    this.treeViewer.refresh(parentDirectories.get(i), true);
                    this.treeViewer.setExpandedState(parentDirectories.get(i), true);
                }
                this.selectPath(selection, true, false);
                this.treeViewer.setExpandedState(selection, true);
                this.treeViewer.setSelection((ISelection)new StructuredSelection(selection), true);
                if (this.command.contains("save") || this.command.equals("selectFolder") || this.command.equals("export") || this.command.equals("exportAll")) {
                    this.parentPath = ((Directory)selection).getParent();
                    this.path = ((Directory)selection).getPath();
                    this.provider = ((Directory)selection).getProvider();
                }
                this.txtNav.setText(this.getNavigationPath((File)selection));
            } else if (selection instanceof File) {
                File localFile = (File)selection;
                if (this.command.equalsIgnoreCase("selectFile") || this.command.equalsIgnoreCase("open") || this.command.equalsIgnoreCase("import") || this.command.equalsIgnoreCase("selectFileFolder")) {
                    this.txtNav.setText(this.getNavigationPath(localFile));
                    String fileExtension = this.extractFileExtension(localFile.getPath());
                    if (this.isValidFileExtension(fileExtension)) {
                        this.setStateVariablesFromSelection(localFile);
                        this.getShell().dispose();
                    }
                }
            }
            this.processState();
        });
        sashForm.setWeights(new int[]{1, 2});
        return browser;
    }

    private void performRename(SelectionEvent e) {
        this.selectedItems.clear();
        for (int index : this.fileTableViewer.getTable().getSelectionIndices()) {
            File file2 = (File)this.fileTableViewer.getTable().getItem(index).getData();
            this.selectedItems.add(file2);
        }
        this.selectedItems.forEach(file -> this.createRenameDialog((File)file));
        this.refreshDisplay(e);
    }

    private void performDelete(SelectionEvent e) {
        this.selectedItems.clear();
        for (int index : this.fileTableViewer.getTable().getSelectionIndices()) {
            File file = (File)this.fileTableViewer.getTable().getItem(index).getData();
            this.selectedItems.add(file);
        }
        FILE_CONTROLLER.delete(new ArrayList<File>(this.selectedItems));
        this.refreshDisplay(e);
    }

    private void performCut(SelectionEvent e) {
        this.selectedItems.clear();
        for (int index : this.fileTableViewer.getTable().getSelectionIndices()) {
            File file = (File)this.fileTableViewer.getTable().getItem(index).getData();
            this.fileTableViewer.getTable().getItem(index).setGrayed(true);
            this.selectedItems.add(file);
            this.isCutActionSelected = true;
        }
    }

    private void performPaste() {
        this.selectedItems.forEach(file -> {
            boolean deleteCutFileFlag;
            block15: {
                String newFilePath;
                File destFolder;
                block13: {
                    block14: {
                        StructuredSelection fileTableViewerSelection = (StructuredSelection)this.fileTableViewer.getSelection();
                        IStructuredSelection treeViewerSelection = (IStructuredSelection)this.treeViewer.getSelection();
                        deleteCutFileFlag = true;
                        destFolder = fileTableViewerSelection.isEmpty() ? (File)treeViewerSelection.getFirstElement() : (File)fileTableViewerSelection.getFirstElement();
                        if (FILE_CONTROLLER.fileExists(destFolder, newFilePath = this.getNewFilePath(file.getName(), destFolder)) != Boolean.TRUE) break block13;
                        if (this.isCutActionSelected) break block14;
                        if (!this.isApplyToAll) {
                            this.createPasteWarningDialog(file.getName());
                        }
                        switch (this.pasteAction) {
                            case "replace": {
                                this.copyFile((File)file, destFolder, newFilePath, true);
                                break;
                            }
                            case "keep-both": {
                                Result result;
                                if (StringUtils.isNotEmpty((String)newFilePath) && (result = FILE_CONTROLLER.getNewName(destFolder, newFilePath)).getStatus() == Result.Status.SUCCESS) {
                                    FILE_CONTROLLER.copyFile((File)file, destFolder, (String)result.getData(), false);
                                    break;
                                }
                                break block15;
                            }
                            default: {
                                this.log.logBasic(file.getName() + " is skipped");
                                break;
                            }
                        }
                        break block15;
                    }
                    if (file.getParent() == destFolder.getPath()) {
                        deleteCutFileFlag = false;
                    }
                    break block15;
                }
                Result result = this.copyFile((File)file, destFolder, newFilePath, false);
            }
            if (this.isCutActionSelected && deleteCutFileFlag) {
                ArrayList<File> cutFiles = new ArrayList<File>();
                cutFiles.add((File)file);
                FILE_CONTROLLER.delete(cutFiles);
            }
        });
        this.pasteAction = null;
        this.isCutActionSelected = false;
        this.isApplyToAll = false;
        this.selectedItems.clear();
    }

    private String getNewFilePath(String fileName, File destFolder) {
        if (destFolder instanceof Directory) {
            if (destFolder instanceof LocalFile) {
                return destFolder.getPath() + java.io.File.separator + fileName;
            }
            return destFolder.getPath() + "/" + fileName;
        }
        return null;
    }

    private Result copyFile(File file, File destFolder, String path, boolean overwrite) {
        if (StringUtils.isNotEmpty((String)path)) {
            return FILE_CONTROLLER.copyFile(file, destFolder, path, overwrite);
        }
        return null;
    }

    private void createRenameDialog(File file) {
        RenameDialog renameDialog = new RenameDialog(this.getShell());
        String renameValue = renameDialog.open(file.getName());
        if (renameValue != null) {
            String filename = file.getName();
            String fileExtention = filename.lastIndexOf(FILE_PERIOD) != -1 ? filename.substring(filename.lastIndexOf(FILE_PERIOD), filename.length()) : null;
            FILE_CONTROLLER.rename(file, file.getParent() + java.io.File.separator + renameValue, true);
        }
    }

    private void createPasteWarningDialog(String fileName) {
        HashMap<String, PasteConfirmationDialog.ActionListener> actionListeners = new HashMap<String, PasteConfirmationDialog.ActionListener>();
        PasteConfirmationDialog.ActionListener skipListener = (event, applyToAll) -> {
            this.isApplyToAll = applyToAll;
            this.pasteAction = PASTE_ACTION_SKIP;
        };
        PasteConfirmationDialog.ActionListener keepBothListener = (event, applyToAll) -> {
            this.isApplyToAll = applyToAll;
            this.pasteAction = PASTE_ACTION_KEEP_BOTH;
        };
        PasteConfirmationDialog.ActionListener replaceListener = (event, applyToAll) -> {
            this.isApplyToAll = applyToAll;
            this.pasteAction = PASTE_ACTION_REPLACE;
        };
        actionListeners.put(BaseMessages.getString(PKG, (String)"file-open-save-plugin.app.skip.button", (String[])new String[0]), skipListener);
        actionListeners.put(BaseMessages.getString(PKG, (String)"file-open-save-plugin.app.keepBoth.button", (String[])new String[0]), keepBothListener);
        actionListeners.put(BaseMessages.getString(PKG, (String)"file-open-save-plugin.app.replace.button", (String[])new String[0]), replaceListener);
        PasteConfirmationDialog pasteConfirmationDialog = new PasteConfirmationDialog(this.getShell(), actionListeners);
        pasteConfirmationDialog.open(fileName);
    }

    private void performCopy(SelectionEvent e) {
        this.selectedItems.clear();
        for (int index : this.fileTableViewer.getTable().getSelectionIndices()) {
            File file = (File)this.fileTableViewer.getTable().getItem(index).getData();
            this.selectedItems.add(file);
        }
    }

    private void setButtonOpenState() {
        if (this.btnOpen != null && !this.getShell().isDisposed()) {
            this.openStructuredSelectionPath((IStructuredSelection)this.treeViewer.getSelection());
            this.openStructuredSelectionPath((IStructuredSelection)this.fileTableViewer.getSelection());
            if (this.command.equalsIgnoreCase("selectFileFolder")) {
                this.btnOpen.setEnabled(StringUtils.isNotEmpty((String)this.path) || StringUtils.isNotEmpty((String)this.name));
            } else if (this.command.equals("selectFolder")) {
                this.btnOpen.setEnabled(StringUtils.isNotEmpty((String)this.path) && StringUtils.isEmpty((String)this.name));
            } else if (this.command.equals("selectFile") || this.command.equals("open") || this.command.equals("import")) {
                this.btnOpen.setEnabled(StringUtils.isNotEmpty((String)this.name));
            } else {
                this.btnOpen.setEnabled(false);
            }
        }
    }

    private boolean isSaveState() {
        return this.fileDialogOperation.isSaveCommand();
    }

    private void processState() {
        this.setButtonSaveState();
        this.setButtonOpenState();
    }

    private void setButtonSaveState() {
        if (this.isSaveState() && this.txtFileName != null && !this.getShell().isDisposed()) {
            this.saveStructuredSelectionPath((IStructuredSelection)this.treeViewer.getSelection());
            this.saveStructuredSelectionPath((IStructuredSelection)this.fileTableViewer.getSelection());
            if (StringUtils.isNotEmpty((String)this.path)) {
                if (this.fileDialogOperation.isSaveCommand() && StringUtils.isNotEmpty((String)this.txtFileName.getText())) {
                    this.btnSave.setEnabled(true);
                }
            } else {
                this.btnSave.setEnabled(false);
            }
        }
    }

    private void openStructuredSelectionPath(IStructuredSelection selection) {
        IStructuredSelection selectedFileTreeViewer;
        IStructuredSelection iStructuredSelection = selectedFileTreeViewer = selection.isEmpty() ? null : selection;
        if (selectedFileTreeViewer != null && selectedFileTreeViewer.getFirstElement() instanceof Directory) {
            this.setStateVariablesFromSelection((File)selectedFileTreeViewer.getFirstElement());
            this.name = null;
        } else if (selectedFileTreeViewer != null && selectedFileTreeViewer.getFirstElement() instanceof File) {
            String fileExtension;
            String tempName = this.createFileNameFromPath(((File)selectedFileTreeViewer.getFirstElement()).getPath());
            this.name = this.command.equals("selectFile") || this.command.equalsIgnoreCase("selectFileFolder") || this.command.equals("open") || this.command.equals("import") ? (this.typedComboBox.getSelection().getId().equals(ALL_FILE_TYPES) ? tempName : (this.isValidFileExtension(fileExtension = this.extractFileExtension(tempName)) ? tempName : null)) : tempName;
            this.setStateVariablesFromSelection((File)selectedFileTreeViewer.getFirstElement());
        }
    }

    private boolean isValidFileExtension(String fileExtension) {
        return this.typedComboBox.getSelection().getId().equals(ALL_FILE_TYPES) || Utils.matches((String)fileExtension, (String)this.typedComboBox.getSelection().getValue());
    }

    private String extractFileExtension(String fullFilePath) {
        int lastIndexOfPeriod = fullFilePath.lastIndexOf(FILE_PERIOD);
        String fileExtension = lastIndexOfPeriod == -1 ? "" : fullFilePath.substring(lastIndexOfPeriod);
        return fileExtension;
    }

    private FileProvider determineProviderFromFilePath(FileDialogOperation fileDialogOperation) {
        try {
            String targetPath = fileDialogOperation.getPath();
            if (StringUtils.isNotEmpty((String)targetPath)) {
                java.io.File filePath = new java.io.File(targetPath);
                if (filePath.isFile()) {
                    boolean isKettleFile;
                    boolean bl = isKettleFile = filePath.getName() != null && (filePath.getName().contains(FilterType.KTR.toString()) || filePath.getName().contains(FilterType.KJB.toString()));
                    if (fileDialogOperation.getProvider() == null) {
                        return ProviderServiceService.get().get(ProviderFilterType.LOCAL.toString());
                    }
                    if (!isKettleFile && fileDialogOperation.getProvider().equalsIgnoreCase(ProviderFilterType.REPOSITORY.toString())) {
                        return ProviderServiceService.get().get(ProviderFilterType.LOCAL.toString());
                    }
                    if (fileDialogOperation.getProvider().equalsIgnoreCase(ProviderFilterType.REPOSITORY.toString())) {
                        return ProviderServiceService.get().get(ProviderFilterType.REPOSITORY.toString());
                    }
                }
                ProviderFilterType providerFilterType = ProviderFilterType.valueOf((String)fileDialogOperation.getProvider().toUpperCase());
                return ProviderServiceService.get().get(providerFilterType.toString());
            }
            return null;
        }
        catch (InvalidFileProviderException e) {
            return null;
        }
    }

    private void saveStructuredSelectionPath(IStructuredSelection selection) {
        IStructuredSelection selectedFileTreeViewer;
        IStructuredSelection iStructuredSelection = selectedFileTreeViewer = selection.isEmpty() ? null : selection;
        if (selectedFileTreeViewer != null && selectedFileTreeViewer.getFirstElement() instanceof File) {
            this.setStateVariablesFromSelection((File)selectedFileTreeViewer.getFirstElement());
        }
    }

    private void setStateVariablesFromSelection(File f) {
        this.type = f.getType();
        this.provider = f.getProvider();
        this.name = f.getName();
        this.connection = f instanceof VFSFile ? ((VFSFile)f).getConnection() : null;
        String string = this.objectId = f instanceof RepositoryFile ? ((RepositoryFile)f).getObjectId() : null;
        if (this.isSaveState()) {
            this.path = f instanceof Directory ? f.getPath() : f.getParent();
            try {
                File parentFile = ProviderServiceService.get().get(this.provider).getParent(f);
                this.parentPath = null != parentFile ? parentFile.getParent() : f.getParent();
            }
            catch (InvalidFileProviderException e) {
                new ErrorDialog(this.getShell(), "Error", "Error getting parent of parent file", (Exception)((Object)e), false);
            }
            if (f instanceof VFSFile) {
                this.parentPath = this.path = f instanceof Directory ? ((VFSFile)f).getConnectionPath() : ((VFSFile)f).getConnectionParentPath();
            }
        } else {
            this.path = f.getPath();
            this.parentPath = f.getParent();
            if (f instanceof VFSFile) {
                this.path = ((VFSFile)f).getConnectionPath();
                this.parentPath = ((VFSFile)f).getConnectionParentPath();
            }
        }
        if (f instanceof RepositoryFile) {
            this.parentPath = f instanceof Directory ? f.getPath() : f.getParent();
        }
    }

    private void deleteFileOrFolder() {
        block9: {
            StructuredSelection fileTableViewerSelection = (StructuredSelection)this.fileTableViewer.getSelection();
            try {
                List selection = null;
                Object treeViewerDestination = null;
                TreeSelection treeViewerSelection = (TreeSelection)this.treeViewer.getSelection();
                if (!fileTableViewerSelection.isEmpty()) {
                    selection = fileTableViewerSelection.toList();
                    treeViewerDestination = treeViewerSelection.getFirstElement();
                }
                if (selection.isEmpty()) {
                    return;
                }
                FileProvider fileProvider = null;
                if (fileTableViewerSelection.getFirstElement() instanceof File) {
                    fileProvider = ProviderServiceService.get().get(((File)selection.get(0)).getProvider());
                }
                if (fileProvider == null) break block9;
                ArrayList<File> selectionList = new ArrayList<File>();
                for (Object file : selection) {
                    selectionList.add((File)file);
                }
                Result result = FILE_CONTROLLER.delete(selectionList);
                List filesToDelete = (List)result.getData();
                if (filesToDelete.size() > 0) {
                    FILE_CONTROLLER.clearCache((File)treeViewerDestination);
                    this.treeViewer.refresh(treeViewerDestination, true);
                    this.selectPath(treeViewerDestination);
                    this.treeViewer.setSelection((ISelection)treeViewerSelection, true);
                    break block9;
                }
                throw new FileException();
            }
            catch (FileException | InvalidFileProviderException ex) {
                File fileOrFolderToDelete = (File)fileTableViewerSelection.getFirstElement();
                String title = "";
                String message = "";
                if (fileOrFolderToDelete instanceof Directory) {
                    title = "file-open-save-plugin.error.unable-to-delete-folder.title";
                    message = "file-open-save-plugin.error.unable-to-delete-folder.message";
                } else {
                    title = "file-open-save-plugin.error.unable-to-delete-file.title";
                    message = "file-open-save-plugin.error.unable-to-delete-file.message";
                }
                new ErrorDialog(this.getShell(), BaseMessages.getString(PKG, (String)title, (String[])new String[0]), BaseMessages.getString(PKG, (String)message, (String[])new String[0]), (Exception)ex, false);
            }
        }
    }

    private List<String> deleteBtnMessages(String fileType, String fileName, int fileSelectionCount) {
        String messageAfter;
        String messageBefore;
        ArrayList<String> messageList = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        String title = "file-open-save-plugin.error.delete-" + fileType + ".title";
        messageList.add(BaseMessages.getString(PKG, (String)title, (String[])new String[0]));
        if (StringUtils.equalsIgnoreCase((String)fileType, (String)"file") && fileSelectionCount == 1) {
            messageBefore = BaseMessages.getString(PKG, (String)("file-open-save-plugin.error.delete-" + fileType + ".message"), (String[])new String[0]);
            messageAfter = "?";
        } else {
            messageBefore = BaseMessages.getString(PKG, (String)("file-open-save-plugin.error.delete-" + fileType + ".before.message"), (String[])new String[0]);
            messageAfter = BaseMessages.getString(PKG, (String)("file-open-save-plugin.error.delete-" + fileType + ".after.message"), (String[])new String[0]);
        }
        sb.append(messageBefore);
        sb.append(" ");
        if (fileSelectionCount > 1) {
            sb.append(fileSelectionCount);
            sb.append(" ");
        } else {
            sb.append(fileName);
            sb.append(" ");
        }
        sb.append(messageAfter);
        messageList.add(String.valueOf(sb));
        return messageList;
    }

    private boolean addFolder(String newFolderName) {
        try {
            Object treeViewerDestination;
            Object selection;
            StructuredSelection fileTableViewerSelection = (StructuredSelection)this.fileTableViewer.getSelection();
            TreeSelection treeViewerSelection = (TreeSelection)this.treeViewer.getSelection();
            FileProvider fileProvider = null;
            String parentPathOfSelection = "";
            if (!fileTableViewerSelection.isEmpty()) {
                selection = fileTableViewerSelection.getFirstElement();
                treeViewerDestination = selection instanceof Directory ? fileTableViewerSelection.getFirstElement() : treeViewerSelection.getFirstElement();
            } else {
                selection = treeViewerSelection.getFirstElement();
                treeViewerDestination = treeViewerSelection.getFirstElement();
            }
            if (selection instanceof Directory) {
                fileProvider = ProviderServiceService.get().get(((Directory)selection).getProvider());
                parentPathOfSelection = ((Directory)selection).getPath();
            } else if (selection instanceof File) {
                fileProvider = ProviderServiceService.get().get(((File)selection).getProvider());
                parentPathOfSelection = Paths.get(((File)selection).getParent(), new String[0]).getParent().toString();
            }
            if (fileProvider != null) {
                File file = fileProvider.createDirectory(parentPathOfSelection, (File)selection, newFolderName);
                if (file == null) {
                    Listener cancel = event -> {};
                    LinkedHashMap<String, Listener> listenerMap = new LinkedHashMap<String, Listener>();
                    listenerMap.put(BaseMessages.getString((String)"System.Button.Cancel"), cancel);
                    this.warningDialog = new WarningDialog(this.getShell(), BaseMessages.getString(PKG, (String)"file-open-save-plugin.error.unable-to-create-folder.title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"file-open-save-plugin.error.unable-to-create-folder.message", (String[])new String[0]), listenerMap);
                    this.warningDialog.open();
                }
                FILE_CONTROLLER.clearCache((File)treeViewerDestination);
                this.treeViewer.refresh(treeViewerDestination, true);
                this.selectPath(treeViewerDestination);
                StructuredSelection selectionAsStructuredSelection = new StructuredSelection(treeViewerDestination);
                this.treeViewer.setSelection((ISelection)selectionAsStructuredSelection, true);
                if (!this.treeViewer.getExpandedState((Object)selectionAsStructuredSelection)) {
                    this.treeViewer.setExpandedState((Object)selectionAsStructuredSelection, true);
                }
                for (TableItem tableItem : this.fileTableViewer.getTable().getItems()) {
                    if (!tableItem.getText(0).equals(newFolderName)) continue;
                    this.fileTableViewer.getTable().setSelection(tableItem);
                    this.fileTableViewer.getTable().setFocus();
                    break;
                }
                this.processState();
                return true;
            }
            throw new KettleException("Unable to select file provider!");
        }
        catch (Exception ex) {
            new ErrorDialog(this.getShell(), "Error", BaseMessages.getString(PKG, (String)"file-open-save-plugin.error.unable-to-create-folder.title", (String[])new String[0]), ex, false);
            return false;
        }
    }

    private Image rasterImage(String path, int width, int height) {
        SwtUniversalImage img = SwtSvgImageUtil.getUniversalImage((Display)this.getShell().getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)path);
        Image image = img.getAsBitmapForSize((Device)this.getShell().getDisplay(), width, height);
        this.getShell().addDisposeListener(e -> {
            img.dispose();
            image.dispose();
        });
        return image;
    }

    boolean hasParentFolder(IStructuredSelection structuredSelection) {
        return !structuredSelection.isEmpty() && structuredSelection.getFirstElement() instanceof Directory;
    }

    private void openHelpDialog() {
        Program.launch((String)HELP_URL);
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    protected void selectPath(Object selectedElement) {
        this.selectPath(selectedElement, true, false);
    }

    protected void selectPath(Object selectedElement, boolean useCache, boolean search) {
        if (selectedElement instanceof Tree) {
            List children = ((Tree)selectedElement).getChildren();
            if (children != null) {
                this.fileTableViewer.setInput((Object)children.toArray());
                this.parentPath = null;
                this.path = null;
                this.name = null;
                this.txtNav.setText(((Tree)selectedElement).getName());
            }
            this.processState();
        } else if (selectedElement instanceof Directory) {
            if (!search) {
                this.txtSearch.setText("");
            }
            String searchString = this.txtSearch.getText();
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), () -> {
                try {
                    String currentFilters;
                    String string = currentFilters = this.typedComboBox.getSelection().getId().equals(ALL_FILE_TYPES) ? null : this.typedComboBox.getSelection().getValue();
                    if (StringUtils.isNotEmpty(currentFilters)) {
                        currentFilters = currentFilters.replace("\\", "");
                    }
                    List<File> files = search ? FILE_CONTROLLER.searchFiles((File)selectedElement, currentFilters, searchString) : FILE_CONTROLLER.getFiles((File)selectedElement, currentFilters, useCache);
                    this.fileTableViewer.setInput((Object)files.stream().sorted(Comparator.comparing(f -> f instanceof Directory, Boolean::compare).reversed().thenComparing(Comparator.comparing(f -> ((File)f).getName(), String.CASE_INSENSITIVE_ORDER))).toArray());
                }
                catch (FileException e) {
                    new ErrorDialog(this.getShell(), "Error", "Error populating file table", (Exception)((Object)e), false);
                }
            });
            for (TableItem fileTableItem : this.fileTableViewer.getTable().getItems()) {
                Object tableItemObject = fileTableItem.getData();
                if (tableItemObject instanceof Directory) continue;
                String fileName = ((File)tableItemObject).getPath();
                String fileExtension = this.extractFileExtension(fileName);
                boolean isValidFileExtension = this.isValidFileExtension(fileExtension);
                if (isValidFileExtension) {
                    fileTableItem.setForeground(this.clrBlack);
                    continue;
                }
                fileTableItem.setForeground(this.clrGray);
            }
            this.txtNav.setText(this.getNavigationPath((File)selectedElement));
            this.flatBtnAdd.setEnabled(((Directory)selectedElement).isCanAddChildren());
            this.processState();
        }
    }

    protected String getNavigationPath(File file) {
        return file instanceof VFSFile ? ((VFSFile)file).getConnectionPath() : file.getPath();
    }

    protected LogChannelInterface getLog() {
        return this.log;
    }

    public static class FilterFileType {
        private String id;
        private String value;
        private String label;

        public FilterFileType() {
            this.id = "";
            this.value = "";
            this.label = "";
        }

        public FilterFileType(String id, String value, String label) {
            this.id = id;
            this.value = value;
            this.label = label;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }
    }

    protected class TypedComboBox<T> {
        private ComboViewer viewer;
        private TypedComboBoxLabelProvider<T> labelProvider;
        private List<T> content;
        private List<TypedComboBoxSelectionListener<T>> selectionListeners;
        private T currentSelection;

        public TypedComboBox(Composite parent) {
            this.viewer = new ComboViewer(parent, 12);
            this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    Object typedElement = TypedComboBox.this.getTypedObject(element);
                    if (TypedComboBox.this.labelProvider != null && typedElement != null) {
                        return TypedComboBox.this.labelProvider.getListLabel(typedElement);
                    }
                    return element.toString();
                }
            });
            this.viewer.addSelectionChangedListener(event -> {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                T typedSelection = this.getTypedObject(selection.getFirstElement());
                if (typedSelection != null) {
                    this.currentSelection = typedSelection;
                    this.notifySelectionListeners(typedSelection);
                }
            });
            this.content = new ArrayList<T>();
            this.selectionListeners = new ArrayList<TypedComboBoxSelectionListener<T>>();
        }

        public void setLabelProvider(TypedComboBoxLabelProvider<T> labelProvider) {
            this.labelProvider = labelProvider;
        }

        public void setContent(List<T> content) {
            this.content = content;
            this.viewer.setInput((Object)content.toArray());
        }

        public T getSelection() {
            return this.currentSelection;
        }

        public void setSelection(T selection) {
            if (this.content.contains(selection)) {
                this.viewer.setSelection((ISelection)new StructuredSelection(selection), true);
            }
        }

        public void selectFirstItem() {
            if (!this.content.isEmpty()) {
                this.setSelection(this.content.get(0));
            }
        }

        public void addSelectionListener(TypedComboBoxSelectionListener<T> listener) {
            this.selectionListeners.add(listener);
        }

        public void removeSelectionListener(TypedComboBoxSelectionListener<T> listener) {
            this.selectionListeners.remove(listener);
        }

        private T getTypedObject(Object o) {
            if (this.content.contains(o)) {
                return this.content.get(this.content.indexOf(o));
            }
            return null;
        }

        public void notifySelectionListeners(T newSelection) {
            for (TypedComboBoxSelectionListener<T> listener : this.selectionListeners) {
                listener.selectionChanged(this, newSelection);
            }
        }
    }

    protected static interface TypedComboBoxLabelProvider<T> {
        public String getListLabel(T var1);
    }

    protected static interface TypedComboBoxSelectionListener<T> {
        public void selectionChanged(TypedComboBox<T> var1, T var2);
    }

    protected static class FileTreeContentProvider
    implements ITreeContentProvider {
        private final FileController fileController;
        private final FileOpenSaveDialog parentDialog;

        public FileTreeContentProvider(FileController fileController, FileOpenSaveDialog fileOpenSaveDialog) {
            this.fileController = fileController;
            this.parentDialog = fileOpenSaveDialog;
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Tree) {
                Tree parentTree = (Tree)parentElement;
                if (parentTree.isHasChildren()) {
                    return parentTree.getChildren().toArray();
                }
            } else if (parentElement instanceof Directory) {
                ArrayList childrenList = new ArrayList();
                BusyIndicator.showWhile((Display)this.parentDialog.getShell().getDisplay(), () -> {
                    try {
                        childrenList.addAll(this.fileController.getFiles((File)((Directory)parentElement), null, true).stream().filter(Directory.class::isInstance).sorted(Comparator.comparing(Entity::getName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList()));
                    }
                    catch (FileException e) {
                        new ErrorDialog(this.parentDialog.getShell(), "Error", "Error populating file tree", (Exception)((Object)e), false);
                    }
                });
                return childrenList.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Tree) {
                return ((Tree)element).isHasChildren();
            }
            if (element instanceof Directory) {
                return ((Directory)element).isHasChildren();
            }
            return false;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }

    protected static class FlatButton {
        private CLabel label;
        private AtomicBoolean enabled = new AtomicBoolean(true);
        private Color hoverColor;
        private Image enabledImage;
        private Image disabledImage;

        public FlatButton(Composite parent, int style) {
            this.label = new CLabel(parent, style);
            PropsUI.getInstance().setLook((Control)this.label);
            this.setEnabled(true);
            this.setHoverColor(parent.getDisplay().getSystemColor(15));
            this.label.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){
                private Color origColor;

                public void mouseEnter(MouseEvent arg0) {
                    this.origColor = label.getBackground();
                    if (enabled.get()) {
                        label.setBackground(hoverColor);
                    }
                }

                public void mouseExit(MouseEvent e) {
                    if (this.origColor != null) {
                        label.setBackground(this.origColor);
                    }
                }
            });
            this.label.addMouseListener((MouseListener)new MouseAdapter(){
                private boolean down = false;

                public void mouseDown(MouseEvent me) {
                    this.down = true;
                }

                public void mouseUp(MouseEvent me) {
                    if (this.down && this.isEnabled()) {
                        label.notifyListeners(13, new Event());
                    }
                    this.down = false;
                }
            });
        }

        public CLabel getLabel() {
            return this.label;
        }

        public boolean isEnabled() {
            return this.enabled.get();
        }

        public FlatButton setEnabled(boolean enabled) {
            if (this.disabledImage != null && this.enabledImage != null) {
                this.label.setImage(enabled ? this.enabledImage : this.disabledImage);
            } else if (this.enabledImage != null && this.disabledImage == null) {
                this.label.setImage(this.enabledImage);
            } else if (this.enabledImage == null && this.disabledImage != null) {
                this.label.setImage(this.disabledImage);
            }
            this.label.redraw();
            this.enabled.set(enabled);
            return this;
        }

        public Image getEnabledImage() {
            return this.enabledImage;
        }

        public FlatButton setEnabledImage(Image enabledImage) {
            this.enabledImage = enabledImage;
            return this;
        }

        public Image getDisabledImage() {
            return this.disabledImage;
        }

        public FlatButton setDisabledImage(Image disabledImage) {
            this.disabledImage = disabledImage;
            return this;
        }

        public FlatButton setToolTipText(String toolTipText) {
            this.label.setToolTipText(toolTipText);
            return this;
        }

        public Color getHoverColor() {
            return this.hoverColor;
        }

        public FlatButton setHoverColor(Color hoverColor) {
            this.hoverColor = hoverColor;
            return this;
        }

        public FlatButton setLayoutData(Object o) {
            this.label.setLayoutData(o);
            return this;
        }

        public FlatButton addListener(SelectionListener listener) {
            TypedListener typedListener = new TypedListener((SWTEventListener)listener);
            this.label.addListener(13, (Listener)typedListener);
            return this;
        }
    }
}

