/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema.concept.types.aggregation;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.pentaho.pms.messages.Messages;

public class AggregationSettings {
    public static final int TYPE_AGGREGATION_NONE = 0;
    public static final int TYPE_AGGREGATION_SUM = 1;
    public static final int TYPE_AGGREGATION_AVERAGE = 2;
    public static final int TYPE_AGGREGATION_COUNT = 3;
    public static final int TYPE_AGGREGATION_COUNT_DISTINCT = 4;
    public static final int TYPE_AGGREGATION_MINIMUM = 5;
    public static final int TYPE_AGGREGATION_MAXIMUM = 6;
    public static final AggregationSettings NONE = new AggregationSettings(0);
    public static final AggregationSettings SUM = new AggregationSettings(1);
    public static final AggregationSettings AVERAGE = new AggregationSettings(2);
    public static final AggregationSettings COUNT = new AggregationSettings(3);
    public static final AggregationSettings COUNT_DISTINCT = new AggregationSettings(4);
    public static final AggregationSettings MINIMUM = new AggregationSettings(5);
    public static final AggregationSettings MAXIMUM = new AggregationSettings(6);
    private static final String[] typeCodes = new String[]{"none", "sum", "average", "count", "count_distinct", "minimum", "maximum"};
    public static final String[] typeDescriptions = new String[]{Messages.getString("AggregationSettings.USER_NONE_DESC"), Messages.getString("AggregationSettings.USER_SUM_DESC"), Messages.getString("AggregationSettings.USER_AVERAGE_DESC"), Messages.getString("AggregationSettings.USER_COUNT_DESC"), Messages.getString("AggregationSettings.USER_DISTINCT_COUNT_DESC"), Messages.getString("AggregationSettings.USER_MINIMUM_DESC"), Messages.getString("AggregationSettings.USER_MAXIMUM_DESC")};
    public static final AggregationSettings[] types = new AggregationSettings[]{NONE, SUM, AVERAGE, COUNT, COUNT_DISTINCT, MINIMUM, MAXIMUM};
    private int type;

    public AggregationSettings(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AggregationSettings)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        AggregationSettings rhs = (AggregationSettings)obj;
        return new EqualsBuilder().append(this.type, rhs.type).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(37, 109).append(this.type).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append(this.type).toString();
    }

    public static AggregationSettings getType(String description) {
        int i;
        for (i = 0; i < typeDescriptions.length; ++i) {
            if (!typeDescriptions[i].equalsIgnoreCase(description)) continue;
            return types[i];
        }
        for (i = 0; i < typeCodes.length; ++i) {
            if (!typeCodes[i].equalsIgnoreCase(description)) continue;
            return types[i];
        }
        return NONE;
    }

    public String getCode() {
        return typeCodes[this.type];
    }

    public String getDescription() {
        return typeDescriptions[this.type];
    }

    public static String[] getTypeDescriptions() {
        return (String[])typeDescriptions.clone();
    }
}

