/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema;

import org.pentaho.di.core.changed.ChangedFlagInterface;
import org.pentaho.di.core.gui.GUIPositionInterface;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.pms.messages.Messages;
import org.pentaho.pms.schema.BusinessCategory;
import org.pentaho.pms.schema.BusinessColumn;
import org.pentaho.pms.schema.PhysicalTable;
import org.pentaho.pms.schema.concept.ConceptInterface;
import org.pentaho.pms.schema.concept.ConceptUtilityBase;
import org.pentaho.pms.schema.concept.ConceptUtilityInterface;
import org.pentaho.pms.util.Const;
import org.pentaho.pms.util.ObjectAlreadyExistsException;
import org.pentaho.pms.util.Settings;
import org.pentaho.pms.util.UniqueArrayList;
import org.pentaho.pms.util.UniqueList;
import org.w3c.dom.Node;

public class BusinessTable
extends ConceptUtilityBase
implements Cloneable,
GUIPositionInterface,
ChangedFlagInterface,
ConceptUtilityInterface,
Comparable {
    private Point location;
    private boolean changed = true;
    private boolean drawn = true;
    private boolean selected;
    private PhysicalTable physicalTable = null;
    private UniqueList<BusinessColumn> businessColumns = new UniqueArrayList<BusinessColumn>();

    public BusinessTable() {
        this.location = new Point(150, 150);
    }

    public BusinessTable(String id) {
        this();
        try {
            this.setId(id);
        }
        catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
            // empty catch block
        }
    }

    public BusinessTable(String id, PhysicalTable physicalTable) {
        this(id);
        this.setPhysicalTable(physicalTable);
    }

    @Override
    public String getModelElementDescription() {
        return Messages.getString("BusinessTable.USER_DESCRIPTION");
    }

    public Object clone() {
        BusinessTable businessTable = new BusinessTable(this.getId(), this.physicalTable);
        businessTable.idChangedListeners = this.idChangedListeners;
        businessTable.setConcept((ConceptInterface)this.getConcept().clone());
        businessTable.getBusinessColumns().clear();
        for (int i = 0; i < this.nrBusinessColumns(); ++i) {
            try {
                businessTable.addBusinessColumn((BusinessColumn)this.getBusinessColumn(i).clone());
                continue;
            }
            catch (ObjectAlreadyExistsException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.location != null) {
            businessTable.setLocation(new Point(this.location.x, this.location.y));
        } else {
            businessTable.setLocation(null);
        }
        return businessTable;
    }

    public BusinessTable cloneUnique(String locale, UniqueList tables, UniqueList<BusinessColumn> columns) {
        BusinessTable businessTable = (BusinessTable)this.clone();
        businessTable.getBusinessColumns().clear();
        for (int i = 0; i < this.nrBusinessColumns(); ++i) {
            try {
                BusinessColumn column = this.getBusinessColumn(i).cloneUnique(locale, columns);
                columns.add(column);
                businessTable.addBusinessColumn(column);
                continue;
            }
            catch (ObjectAlreadyExistsException e) {
                throw new RuntimeException(e);
            }
        }
        String newId = BusinessTable.proposeId(locale, this, this.physicalTable, tables);
        try {
            businessTable.setId(newId);
        }
        catch (ObjectAlreadyExistsException e) {
            return null;
        }
        return businessTable;
    }

    public static final String proposeId(String locale, BusinessTable businessTable, PhysicalTable physicalTable) {
        String baseID = Const.toID(businessTable.getDisplayName(locale));
        String namePart = Const.toID(Const.NVL(physicalTable.getName(locale), physicalTable.getFormula()));
        String id = Settings.getBusinessTableIDPrefix() + baseID + "_" + namePart;
        if (Settings.isAnIdUppercase()) {
            id = id.toUpperCase();
        }
        return id;
    }

    public static final String proposeId(String locale, BusinessTable businessTable, PhysicalTable physicalTable, UniqueList tables) {
        boolean gotNew = false;
        boolean found = false;
        String id = BusinessTable.proposeId(locale, businessTable, physicalTable);
        int catNr = 1;
        String newId = id;
        while (!gotNew) {
            for (ConceptUtilityBase element : tables) {
                if (!element.getId().equalsIgnoreCase(newId)) continue;
                found = true;
                break;
            }
            if (found) {
                newId = id + "_" + ++catNr;
                found = false;
                continue;
            }
            gotNew = true;
        }
        if (Settings.isAnIdUppercase()) {
            newId = newId.toUpperCase();
        }
        return newId;
    }

    public BusinessCategory generateCategory(String locale, UniqueList categories) {
        BusinessCategory businessCategory = new BusinessCategory();
        try {
            businessCategory.setId(BusinessCategory.proposeId(locale, this, businessCategory, categories));
        }
        catch (ObjectAlreadyExistsException e) {
            throw new RuntimeException(e);
        }
        String categoryName = this.getDisplayName(locale);
        boolean gotNew = false;
        boolean found = false;
        int catNr = 1;
        String newName = categoryName;
        while (!gotNew) {
            for (ConceptUtilityBase element : categories) {
                if (!element.getName(locale).equalsIgnoreCase(newName)) continue;
                found = true;
                break;
            }
            if (found) {
                newName = categoryName + "_" + ++catNr;
                found = false;
                continue;
            }
            gotNew = true;
        }
        businessCategory.getConcept().setName(locale, newName);
        for (int i = 0; i < this.nrBusinessColumns(); ++i) {
            try {
                businessCategory.addBusinessColumn(this.getBusinessColumn(i));
                continue;
            }
            catch (ObjectAlreadyExistsException e) {
                throw new RuntimeException(e);
            }
        }
        return businessCategory;
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    @Override
    public void setChanged() {
        this.setChanged(true);
    }

    public PhysicalTable getPhysicalTable() {
        return this.physicalTable;
    }

    public void setPhysicalTable(PhysicalTable physicalTable) {
        this.physicalTable = physicalTable;
        if (physicalTable != null) {
            this.getConcept().setInheritedInterface(physicalTable.getConcept());
        } else {
            this.getConcept().setInheritedInterface(null);
        }
    }

    public UniqueList<BusinessColumn> getBusinessColumns() {
        return this.businessColumns;
    }

    public void readData(Node tablenode) {
        String sxloc = XMLHandler.getTagValue((Node)tablenode, (String)"xloc");
        String syloc = XMLHandler.getTagValue((Node)tablenode, (String)"yloc");
        int x = Const.toInt(sxloc, 0);
        int y = Const.toInt(syloc, 0);
        this.location = new Point(x, y);
        String sdrawn = XMLHandler.getTagValue((Node)tablenode, (String)"draw_table");
        this.drawn = "Y".equalsIgnoreCase(sdrawn);
    }

    public String getXML() {
        String retval = "<business-table>";
        retval = retval + "      " + XMLHandler.addTagValue((String)"xloc", (int)this.location.x);
        retval = retval + "      " + XMLHandler.addTagValue((String)"yloc", (int)this.location.y);
        retval = retval + "      " + XMLHandler.addTagValue((String)"draw_table", (boolean)this.drawn);
        retval = retval + "</business-table>";
        return retval;
    }

    public boolean isDrawn() {
        return this.drawn;
    }

    public void setDrawn(boolean drawn) {
        if (this.drawn != drawn) {
            this.setChanged();
        }
        this.drawn = drawn;
    }

    public void hide() {
        this.setDrawn(false);
    }

    public void setLocation(int x, int y) {
        int ny;
        int nx = x >= 0 ? x : 0;
        Point loc = new Point(nx, ny = y >= 0 ? y : 0);
        if (!loc.equals(this.location)) {
            this.setChanged();
        }
        this.location = loc;
    }

    public void setLocation(Point loc) {
        if (loc != null && !loc.equals(this.location)) {
            this.setChanged();
        }
        this.location = loc;
    }

    public Point getLocation() {
        return this.location;
    }

    public void setSelected(boolean sel) {
        this.selected = sel;
    }

    public void flipSelected() {
        this.selected = !this.selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public int nrBusinessColumns() {
        return this.businessColumns.size();
    }

    public BusinessColumn findBusinessColumn(String columnId) {
        for (int i = 0; i < this.nrBusinessColumns(); ++i) {
            BusinessColumn businessColumn = this.getBusinessColumn(i);
            if (!businessColumn.getId().equalsIgnoreCase(columnId)) continue;
            return businessColumn;
        }
        return null;
    }

    public BusinessColumn findBusinessColumn(String locale, String name) {
        BusinessColumn businessColumn;
        int i;
        for (i = 0; i < this.nrBusinessColumns(); ++i) {
            businessColumn = this.getBusinessColumn(i);
            String displayName = businessColumn.getDisplayName(locale);
            if (displayName == null || !displayName.equals(name)) continue;
            return businessColumn;
        }
        for (i = 0; i < this.nrBusinessColumns(); ++i) {
            businessColumn = this.getBusinessColumn(i);
            String id = businessColumn.getId();
            if (id == null || !id.equals(name)) continue;
            return businessColumn;
        }
        return null;
    }

    public BusinessColumn getBusinessColumn(int i) {
        if (i < this.businessColumns.size()) {
            return this.businessColumns.get(i);
        }
        return null;
    }

    public void addBusinessColumn(BusinessColumn businessColumn) throws ObjectAlreadyExistsException {
        this.businessColumns.add(businessColumn);
        this.setChanged(true);
    }

    public void addBusinessColumn(int index, BusinessColumn businessColumn) throws ObjectAlreadyExistsException {
        this.businessColumns.add(index, businessColumn);
        this.setChanged(true);
    }

    public int indexOfBusinessColumn(BusinessColumn businessColumn) {
        return this.businessColumns.indexOf(businessColumn);
    }

    public void removeBusinessColumn(int index) {
        this.getBusinessColumn(index).getConcept().setSecurityParentInterface(null);
        this.businessColumns.remove(index);
        this.setChanged(true);
    }

    @Override
    public void clearChanged() {
        this.setChanged(false);
        for (int i = 0; i < this.nrBusinessColumns(); ++i) {
            BusinessColumn businessColumn = this.getBusinessColumn(i);
            businessColumn.clearChanged();
        }
    }

    public int compareTo(Object obj) {
        BusinessTable businessTable = (BusinessTable)obj;
        return this.getId().compareTo(businessTable.getId());
    }

    public String[] getColumnIDs() {
        String[] ids = new String[this.nrBusinessColumns()];
        for (int i = 0; i < this.nrBusinessColumns(); ++i) {
            ids[i] = this.getBusinessColumn(i).getId();
        }
        return ids;
    }

    public String[] getColumnNames(String locale) {
        String[] bColumns = new String[this.nrBusinessColumns()];
        for (int i = 0; i < this.nrBusinessColumns(); ++i) {
            bColumns[i] = this.getBusinessColumn(i).getDisplayName(locale);
        }
        return bColumns;
    }
}

