/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.baserver.utils;

import java.util.List;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.baserver.utils.SetSessionVariableData;
import org.pentaho.di.baserver.utils.SetSessionVariableDialog;
import org.pentaho.di.baserver.utils.SetSessionVariableStep;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="SetSessionVariableStep", name="SetSessionVariableMeta.Name", image="icons/setsessionvariable.svg", description="SetSessionVariableMeta.Description", i18nPackageName="pt.webdetails.di.baserverutils", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.BAServer", isSeparateClassLoaderNeeded=true, documentationUrl="https://pentaho-community.atlassian.net/wiki/display/EAI/Set+Session+Variables")
public class SetSessionVariableMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = SetSessionVariableMeta.class;
    private String[] fieldName;
    private String[] variableName;
    private String[] defaultValue;
    private boolean useFormatting;

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new SetSessionVariableStep(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new SetSessionVariableData();
    }

    public StepDialogInterface getDialog(Shell shell, StepMetaInterface meta, TransMeta transMeta, String name) {
        return new SetSessionVariableDialog(shell, meta, transMeta, name);
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public String[] getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String[] fieldValue) {
        this.variableName = fieldValue;
    }

    public String[] getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String[] defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isUsingFormatting() {
        return this.useFormatting;
    }

    public void setUseFormatting(boolean useFormatting) {
        this.useFormatting = useFormatting;
    }

    public void allocate(int count) {
        this.fieldName = new String[count];
        this.variableName = new String[count];
        this.defaultValue = new String[count];
    }

    public void setDefault() {
        this.allocate(0);
        this.useFormatting = true;
    }

    public Object clone() {
        SetSessionVariableMeta clone = (SetSessionVariableMeta)((Object)super.clone());
        int count = this.fieldName.length;
        clone.allocate(count);
        for (int i = 0; i < count; ++i) {
            clone.fieldName[i] = this.fieldName[i];
            clone.variableName[i] = this.variableName[i];
            clone.defaultValue[i] = this.defaultValue[i];
        }
        clone.useFormatting = this.useFormatting;
        return clone;
    }

    public String getXML() {
        StringBuffer xml = new StringBuffer(150);
        xml.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            xml.append("      <field>").append(Const.CR);
            xml.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            xml.append("        ").append(XMLHandler.addTagValue((String)"variable", (String)this.variableName[i]));
            xml.append("        ").append(XMLHandler.addTagValue((String)"default_value", (String)this.defaultValue[i]));
            xml.append("        </field>").append(Const.CR);
        }
        xml.append("      </fields>").append(Const.CR);
        xml.append("    ").append(XMLHandler.addTagValue((String)"use_formatting", (boolean)this.useFormatting));
        return xml.toString();
    }

    public void loadXML(Node stepNode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        try {
            Node fields = XMLHandler.getSubNode((Node)stepNode, (String)"fields");
            int count = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(count);
            for (int i = 0; i < count; ++i) {
                Node fieldNode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XMLHandler.getTagValue((Node)fieldNode, (String)"name");
                this.variableName[i] = XMLHandler.getTagValue((Node)fieldNode, (String)"variable");
                this.defaultValue[i] = XMLHandler.getTagValue((Node)fieldNode, (String)"default_value");
            }
            this.useFormatting = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepNode, (String)"use_formatting"));
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"SetSessionVariable.RuntimeError.UnableToReadXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int count = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(count);
            for (int i = 0; i < count; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.variableName[i] = rep.getStepAttributeString(id_step, i, "field_variable_name");
                this.defaultValue[i] = rep.getStepAttributeString(id_step, i, "field_default_value");
            }
            this.useFormatting = rep.getStepAttributeBoolean(id_step, 0, "use_formatting", false);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SetSessionVariable.RuntimeError.UnableToReadRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            for (int i = 0; i < this.fieldName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", Const.isEmpty((String)this.fieldName[i]) ? "" : this.fieldName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_variable_name", this.variableName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_default_value", this.defaultValue[i]);
            }
            rep.saveStepAttribute(id_transformation, id_step, 0, "use_formatting", this.useFormatting);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SetSessionVariable.RuntimeError.UnableToSaveRepository", (String[])new String[]{"" + id_step}), (Throwable)e);
        }
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        if (prev == null || prev.size() == 0) {
            remarks.add((CheckResultInterface)new CheckResult(3, BaseMessages.getString(PKG, (String)"SetSessionVariable.CheckResult.NotReceivingFieldsFromPreviousSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta));
        } else {
            remarks.add((CheckResultInterface)new CheckResult(1, BaseMessages.getString(PKG, (String)"SetSessionVariable.CheckResult.ReceivingFieldsFromPreviousSteps", (String[])new String[]{"" + prev.size()}), (CheckResultSourceInterface)stepMeta));
        }
        if (input.length > 0) {
            remarks.add((CheckResultInterface)new CheckResult(1, BaseMessages.getString(PKG, (String)"SetSessionVariable.CheckResult.ReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta));
        } else {
            remarks.add((CheckResultInterface)new CheckResult(4, BaseMessages.getString(PKG, (String)"SetSessionVariable.CheckResult.NotReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta));
        }
    }
}

