/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.web.servlet.UploadFileUtils;
import org.pentaho.platform.web.servlet.messages.Messages;
import org.pentaho.reporting.libraries.base.util.StringUtils;

@MultipartConfig
public class UploadFileServlet
extends HttpServlet
implements Servlet {
    private static final long serialVersionUID = 8305367618713715640L;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            IPentahoSession session = PentahoSessionHolder.getSession();
            if (!this.hasManageDataAccessPermission(session)) {
                response.sendError(403, Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0009_UNAUTHORIZED"));
                return;
            }
            response.setContentType("text/plain");
            Part uploadPart = request.getPart("uploadFormElement");
            if (uploadPart == null) {
                String error = Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0001_NO_FILE_TO_UPLOAD");
                response.getWriter().write(error);
                return;
            }
            String fileName = request.getParameter("file_name");
            if (StringUtils.isEmpty((String)fileName)) {
                throw new ServletException(Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0010_FILE_NAME_INVALID"));
            }
            boolean isTemporary = false;
            String temporary = request.getParameter("mark_temporary");
            if (temporary != null) {
                isTemporary = Boolean.parseBoolean(temporary);
            }
            boolean shouldUnzip = false;
            String unzip = request.getParameter("unzip");
            if (unzip != null) {
                shouldUnzip = Boolean.parseBoolean(unzip);
            }
            UploadFileUtils utils = new UploadFileUtils(session);
            utils.setShouldUnzip(shouldUnzip);
            utils.setTemporary(isTemporary);
            utils.setFileName(fileName);
            utils.setWriter(response.getWriter());
            utils.setUploadedPart(uploadPart);
            utils.process();
        }
        catch (FileNotFoundException e) {
            response.getWriter().write(Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0013_NO_SUCH_FILE_OR_DIRECTORY"));
        }
        catch (Exception e) {
            String error = Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0005_UNKNOWN_ERROR", new Object[]{e.getLocalizedMessage()});
            response.getWriter().write(error);
        }
    }

    protected boolean hasManageDataAccessPermission(IPentahoSession session) {
        String override = PentahoSystem.getSystemSetting((String)"data-access-override", (String)"false");
        if (Boolean.parseBoolean(override)) {
            return true;
        }
        IAuthorizationPolicy policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
        if (policy != null) {
            return policy.isAllowed("org.pentaho.platform.dataaccess.datasource.security.manage");
        }
        return false;
    }
}

