/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.security;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.platform.api.security.ILoginAttemptService;
import org.pentaho.platform.web.http.security.PreventBruteForceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

public class PreventBruteForceUsernamePasswordAuthenticationFilter
extends UsernamePasswordAuthenticationFilter {
    private ILoginAttemptService loginAttemptService;

    public PreventBruteForceUsernamePasswordAuthenticationFilter(ILoginAttemptService loginAttemptService) {
        this.loginAttemptService = loginAttemptService;
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) {
        String clientIp = this.getClientIp(request);
        if (this.loginAttemptService.isBlocked(clientIp)) {
            throw new PreventBruteForceException("Authentication blocked to prevent brute force login");
        }
        return super.attemptAuthentication(request, response);
    }

    private String getClientIp(HttpServletRequest request) {
        String xfHeader = request.getHeader("X-Forwarded-For");
        if (xfHeader == null) {
            return request.getRemoteAddr();
        }
        return xfHeader.split(",")[0];
    }
}

