/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.security;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.web.http.messages.Messages;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;

public class HttpSessionReuseDetectionFilter
implements Filter,
InitializingBean {
    private static final Log logger = LogFactory.getLog(HttpSessionReuseDetectionFilter.class);
    private String filterProcessesUrl;
    private String sessionReuseDetectedUrl;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException();
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException();
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.requiresAuthentication(httpRequest, httpResponse)) {
            String remoteUser;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)Messages.getInstance().getString("HttpSessionReuseDetectionFilter.DEBUG_PROCESS_AUTHN"));
            }
            if (null != (remoteUser = httpRequest.getRemoteUser()) && remoteUser.length() > 0) {
                HttpSession session;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)Messages.getInstance().getString("HttpSessionReuseDetectionFilter.DEBUG_USER_ALREADY_LOGGED_IN", new Object[]{remoteUser}));
                }
                if (null != (session = httpRequest.getSession(false))) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)Messages.getInstance().getString("HttpSessionReuseDetectionFilter.DEBUG_INVALIDATING_SESSION"));
                    }
                    session.invalidate();
                }
                SecurityContextHolder.clearContext();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)Messages.getInstance().getString("HttpSessionReuseDetectionFilter.DEBUG_REDIRECTING", new Object[]{this.sessionReuseDetectedUrl}));
                }
                httpResponse.sendRedirect(httpResponse.encodeRedirectURL(httpRequest.getContextPath() + this.sessionReuseDetectedUrl));
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.filterProcessesUrl, (String)Messages.getInstance().getString("HttpSessionReuseDetectionFilter.ERROR_0001_FILTERPROCESSESURL_NOT_SPECIFIED"));
        Assert.hasLength((String)this.sessionReuseDetectedUrl, (String)Messages.getInstance().getString("HttpSessionReuseDetectionFilter.ERROR_0002_SESSIONREUSEDETECTEDURL_NOT_SPECIFIED"));
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        String uri = request.getRequestURI();
        int pathParamIndex = uri.indexOf(59);
        if (pathParamIndex > 0) {
            uri = uri.substring(0, pathParamIndex);
        }
        return uri.endsWith(request.getContextPath() + this.filterProcessesUrl);
    }

    public String getFilterProcessesUrl() {
        return this.filterProcessesUrl;
    }

    public void setFilterProcessesUrl(String filterProcessesUrl) {
        this.filterProcessesUrl = filterProcessesUrl;
    }

    public String getSessionReuseDetectedUrl() {
        return this.sessionReuseDetectedUrl;
    }

    public void setSessionReuseDetectedUrl(String sessionReuseDetectedUrl) {
        this.sessionReuseDetectedUrl = sessionReuseDetectedUrl;
    }
}

