/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class SystemStatusFilter
implements Filter {
    private String redirectToOnInitError;
    private boolean systemInitializedOk;

    public void init(FilterConfig filterConfig) throws ServletException {
        String failurePage = filterConfig.getInitParameter("initFailurePage");
        if (failurePage == null || failurePage.length() == 0) {
            failurePage = "InitFailure";
        }
        this.redirectToOnInitError = "/" + failurePage;
        this.systemInitializedOk = PentahoSystem.getInitializedOK();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.systemInitializedOk) {
            filterChain.doFilter(request, response);
        } else {
            HttpServletRequest req = (HttpServletRequest)request;
            if (req.getServletPath().endsWith(this.redirectToOnInitError)) {
                filterChain.doFilter(request, response);
            } else {
                RequestDispatcher dispatcher = request.getRequestDispatcher(this.redirectToOnInitError);
                dispatcher.forward(request, response);
            }
        }
    }

    public void destroy() {
    }
}

