/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.filters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.api.mt.ITenantedPrincipleNameResolver;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.UserSession;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class ProxyTrustingFilter
implements Filter {
    FilterConfig filterConfig;
    private static final String DEFAULT_PARAMETER_NAME = "_TRUST_USER_";
    private static final String DEFAULT_LOCALE_OVERRIDE_PARAMETER_NAME = "_TRUST_LOCALE_OVERRIDE_";
    String[] trustedIpAddrs = null;
    private boolean checkHeader = true;
    private String requestParameterName;
    private String headerName;
    private String localeOverrideParameterName;
    private String localeOverrideHeaderName;
    private final Map<String, Pattern> ipPatterns = new HashMap<String, Pattern>();
    private static final Log logger = LogFactory.getLog(ProxyTrustingFilter.class);

    public Log getLogger() {
        return logger;
    }

    public void init(FilterConfig filterConfiguration) throws ServletException {
        this.filterConfig = filterConfiguration;
        this.initParameterTrustedIpAddresses();
        this.initParameterCheckHeader();
        this.initParameterUser();
        this.initParameterLocaleOverride();
    }

    protected void initParameterTrustedIpAddresses() {
        this.trustedIpAddrs = null;
        String hostStr = this.filterConfig.getInitParameter("TrustedIpAddrs");
        if (hostStr != null) {
            StringTokenizer st = new StringTokenizer(hostStr, ",");
            ArrayList<String> addrs = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String tok = st.nextToken().trim();
                if (tok.length() <= 0) continue;
                addrs.add(tok);
            }
            if (addrs.size() > 0) {
                this.trustedIpAddrs = addrs.toArray(new String[0]);
            }
        }
    }

    protected void initParameterCheckHeader() {
        String checkHeaderString = this.filterConfig.getInitParameter("CheckHeader");
        if (!this.isEmpty(checkHeaderString)) {
            this.checkHeader = checkHeaderString.equalsIgnoreCase("true");
        }
    }

    protected void initParameterUser() {
        String requestParameterSetting = this.filterConfig.getInitParameter("RequestParameterName");
        this.requestParameterName = !this.isEmpty(requestParameterSetting) ? requestParameterSetting : DEFAULT_PARAMETER_NAME;
        String headerNameSetting = this.filterConfig.getInitParameter("HeaderName");
        this.headerName = !this.isEmpty(headerNameSetting) ? headerNameSetting : DEFAULT_PARAMETER_NAME;
    }

    protected void initParameterLocaleOverride() {
        String localeOverrideParameterSetting = this.filterConfig.getInitParameter("LocaleOverrideParameterName");
        this.localeOverrideParameterName = !this.isEmpty(localeOverrideParameterSetting) ? localeOverrideParameterSetting : DEFAULT_LOCALE_OVERRIDE_PARAMETER_NAME;
        String localeOverrideHeaderNameSetting = this.filterConfig.getInitParameter("LocaleOverrideHeaderName");
        this.localeOverrideHeaderName = !this.isEmpty(localeOverrideHeaderNameSetting) ? localeOverrideHeaderNameSetting : DEFAULT_LOCALE_OVERRIDE_PARAMETER_NAME;
    }

    boolean isTrusted(String addr) {
        if (this.trustedIpAddrs != null) {
            for (String element : this.trustedIpAddrs) {
                Matcher matcher;
                if (element.equals(addr)) {
                    return true;
                }
                Pattern pat = this.ipPatterns.get(element);
                if (pat == null) {
                    try {
                        pat = Pattern.compile(element);
                        this.ipPatterns.put(element, pat);
                    }
                    catch (PatternSyntaxException ignored) {
                        continue;
                    }
                }
                if (!(matcher = pat.matcher(addr)).find()) continue;
                return true;
            }
        }
        return false;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String name;
        HttpServletRequest req;
        String remoteHost;
        if (this.trustedIpAddrs != null && request instanceof HttpServletRequest && this.isTrusted(remoteHost = (req = (HttpServletRequest)request).getRemoteAddr()) && !this.isEmpty(name = this.getTrustUser(req))) {
            this.doFilterCore(req, name);
        }
        chain.doFilter(request, response);
    }

    protected void doFilterCore(HttpServletRequest request, String name) throws ServletException {
        try {
            this.becomeUser(name);
            HttpSession httpSession = request.getSession();
            httpSession.setAttribute("pentaho-session-context", (Object)PentahoSessionHolder.getSession());
            String localeOverrideCode = this.getTrustLocaleOverrideCode(request);
            httpSession.setAttribute("locale_override", (Object)localeOverrideCode);
            this.setSystemLocaleOverrideCode(localeOverrideCode);
            SecurityContext authWrapper = this.createSpringSecurityContext();
            httpSession.setAttribute("SPRING_SECURITY_CONTEXT", (Object)authWrapper);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private SecurityContext createSpringSecurityContext() {
        SecurityContext authWrapper = new SecurityContext(){
            private static final long serialVersionUID = 1L;
            private Authentication authentication;

            public Authentication getAuthentication() {
                return this.authentication;
            }

            public void setAuthentication(Authentication authentication) {
                this.authentication = authentication;
            }
        };
        authWrapper.setAuthentication(SecurityContextHolder.getContext().getAuthentication());
        return authWrapper;
    }

    public void destroy() {
    }

    public static void main(String[] args) {
    }

    protected String getHeaderName() {
        return this.headerName;
    }

    protected String getParameterName() {
        return this.requestParameterName;
    }

    protected String getLocaleOverrideHeaderName() {
        return this.localeOverrideHeaderName;
    }

    protected String getLocaleOverrideParameterName() {
        return this.localeOverrideParameterName;
    }

    protected boolean checkHeader() {
        return this.checkHeader;
    }

    protected String getTrustUser(HttpServletRequest request) {
        String name = request.getParameter(this.getParameterName());
        if (this.checkHeader() && this.isEmpty(name)) {
            name = request.getHeader(this.normalizeHeaderName(this.getHeaderName()));
        }
        return name;
    }

    protected String getTrustLocaleOverrideCode(HttpServletRequest request) {
        String localeOverrideCode = request.getParameter(this.getLocaleOverrideParameterName());
        if (this.checkHeader() && this.isEmpty(localeOverrideCode)) {
            localeOverrideCode = request.getHeader(this.normalizeHeaderName(this.getLocaleOverrideHeaderName()));
        }
        return localeOverrideCode;
    }

    public boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    protected String normalizeHeaderName(String in) {
        String lower = in.toLowerCase();
        return Character.toUpperCase(lower.charAt(0)) + lower.substring(1);
    }

    protected void becomeUser(String principalName) {
        UserSession session;
        Locale locale = Locale.getDefault();
        ITenantedPrincipleNameResolver tenantedUserNameUtils = (ITenantedPrincipleNameResolver)PentahoSystem.get(ITenantedPrincipleNameResolver.class, (String)"tenantedUserNameUtils", null);
        if (tenantedUserNameUtils != null) {
            session = new UserSession(principalName, locale, false, null);
            ITenant tenant = tenantedUserNameUtils.getTenant(principalName);
            session.setAttribute("org.pentaho.tenantId", (Object)tenant.getId());
            session.setAuthenticated(tenant.getId(), principalName);
        } else {
            session = new UserSession(principalName, locale, false, null);
            session.setAuthenticated(principalName);
        }
        PentahoSessionHolder.setSession((IPentahoSession)session);
        Authentication auth = SecurityHelper.getInstance().createAuthentication(principalName);
        SecurityContextHolder.getContext().setAuthentication(auth);
        PentahoSystem.sessionStartup((IPentahoSession)PentahoSessionHolder.getSession(), null);
    }

    protected void setSystemLocaleOverrideCode(String localeOverrideCode) {
        LocaleHelper.setThreadLocaleOverride((Locale)LocaleHelper.parseLocale((String)localeOverrideCode));
    }
}

