/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.filters;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.web.http.filters.SetCharacterEncodingFilter;
import org.pentaho.platform.web.http.messages.Messages;

public class PentahoAwareCharacterEncodingFilter
extends SetCharacterEncodingFilter {
    private static final Log logger = LogFactory.getLog(PentahoAwareCharacterEncodingFilter.class);
    public static final String INIT_PARAM_ENCODING = "encoding";
    public static final String DEFAULT_CHAR_ENCODING = "UTF-8";

    @Override
    protected String selectEncoding(ServletRequest request) {
        HttpServletRequest httpRequest;
        String enc;
        if (request instanceof HttpServletRequest && StringUtils.isNotBlank((String)(enc = (httpRequest = (HttpServletRequest)request).getSession(true).getServletContext().getInitParameter(INIT_PARAM_ENCODING)))) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)Messages.getInstance().getString("PentahoAwareCharacterEncodingFilter.ENCODING_IN_CTX", new Object[]{enc}));
            }
            return enc;
        }
        String enc2 = super.selectEncoding(request);
        if (StringUtils.isNotBlank((String)enc2)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)Messages.getInstance().getString("PentahoAwareCharacterEncodingFilter.ENCODING_IN_FILTER_INIT", new Object[]{enc2}));
            }
            return enc2;
        }
        if (logger.isWarnEnabled()) {
            logger.warn((Object)Messages.getInstance().getString("PentahoAwareCharacterEncodingFilter.COULD_NOT_FIND_ENCODING", new Object[]{DEFAULT_CHAR_ENCODING}));
        }
        return DEFAULT_CHAR_ENCODING;
    }
}

