/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.action.IStreamingAction;
import org.pentaho.platform.api.repository2.unified.IStreamListener;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.scheduler2.IBackgroundExecutionStreamProvider;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository.RepositoryFilenameUtils;
import org.pentaho.platform.repository2.unified.fileio.RepositoryFileInputStream;
import org.pentaho.platform.repository2.unified.fileio.RepositoryFileOutputStream;
import org.pentaho.platform.repository2.unified.jcr.PentahoJcrConstants;
import org.pentaho.platform.util.web.MimeHelper;

public class RepositoryFileStreamProvider
implements IBackgroundExecutionStreamProvider,
IStreamListener {
    private static final long serialVersionUID = 2812310908328498989L;
    private static final Log logger = LogFactory.getLog(RepositoryFileStreamProvider.class);
    public String outputFilePath;
    public String inputFilePath;
    public String appendDateFormat;
    private IStreamingAction streamingAction;
    private boolean autoCreateUniqueFilename;

    public RepositoryFileStreamProvider(String inputFilePath, String outputFilePath, boolean autoCreateUniqueFilename) {
        this.outputFilePath = outputFilePath;
        this.inputFilePath = inputFilePath;
        this.autoCreateUniqueFilename = autoCreateUniqueFilename;
    }

    public RepositoryFileStreamProvider(String inputFilePath, String outputFilePath, boolean autoCreateUniqueFilename, String appendDateFormat) {
        this(inputFilePath, outputFilePath, autoCreateUniqueFilename);
        this.appendDateFormat = appendDateFormat;
    }

    public RepositoryFileStreamProvider() {
    }

    public IStreamingAction getStreamingAction() {
        return this.streamingAction;
    }

    public void setStreamingAction(IStreamingAction streamingAction) {
        this.streamingAction = streamingAction;
    }

    public String getOutputPath() {
        return this.outputFilePath;
    }

    public String getMimeType() {
        String mimeType = null;
        if (this.streamingAction != null) {
            mimeType = this.streamingAction.getMimeType(null);
        }
        if (mimeType == null) {
            mimeType = MimeHelper.getMimeTypeFromFileName((String)this.outputFilePath);
        }
        if (mimeType == null) {
            mimeType = "binary/octet-stream";
        }
        return mimeType;
    }

    public OutputStream getOutputStream() throws Exception {
        String tempOutputFilePath = this.outputFilePath;
        String extension = RepositoryFilenameUtils.getExtension((String)tempOutputFilePath);
        if ("*".equals(extension)) {
            String mimeType;
            tempOutputFilePath = tempOutputFilePath.substring(0, tempOutputFilePath.lastIndexOf(46));
            if (this.appendDateFormat != null) {
                try {
                    LocalDateTime now = LocalDateTime.now();
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.appendDateFormat);
                    String formattedDate = now.format(formatter);
                    tempOutputFilePath = tempOutputFilePath + formattedDate;
                }
                catch (Exception e) {
                    logger.warn((Object)("Unable to calculate current date: " + e.getMessage()));
                }
            }
            if (this.streamingAction != null && (mimeType = this.streamingAction.getMimeType(null)) != null && MimeHelper.getExtension((String)mimeType) != null) {
                tempOutputFilePath = tempOutputFilePath + MimeHelper.getExtension((String)mimeType);
            }
        }
        RepositoryFileOutputStream outputStream = new RepositoryFileOutputStream(tempOutputFilePath, this.autoCreateUniqueFilename, true);
        outputStream.addListener((IStreamListener)this);
        outputStream.forceFlush(false);
        return outputStream;
    }

    public void fileCreated(String filePath) {
        IUnifiedRepository repository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
        RepositoryFile outputFile = repository.getFile(filePath);
        if (outputFile != null) {
            Map fileMetadata = repository.getFileMetadata(outputFile.getId());
            RepositoryFile inputFile = repository.getFile(this.inputFilePath);
            if (inputFile != null) {
                fileMetadata.put(PentahoJcrConstants.PHO_CONTENTCREATOR, inputFile.getId());
                repository.setFileMetadata(outputFile.getId(), fileMetadata);
            }
        }
    }

    public String getOutputFilePath() {
        return this.outputFilePath;
    }

    public void setOutputFilePath(String filePath) {
        this.outputFilePath = filePath;
    }

    public String getInputFilePath() {
        return this.inputFilePath;
    }

    public void setInputFilePath(String filePath) {
        this.inputFilePath = filePath;
    }

    public String getAppendDateFormat() {
        return this.appendDateFormat;
    }

    public void setAppendDateFormat(String appendDateFormat) {
        this.appendDateFormat = appendDateFormat;
    }

    public InputStream getInputStream() throws Exception {
        IUnifiedRepository repository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
        RepositoryFile repositoryFile = repository.getFile(this.inputFilePath);
        if (repositoryFile == null || repositoryFile.isFolder()) {
            throw new FileNotFoundException();
        }
        return new RepositoryFileInputStream(repositoryFile);
    }

    public boolean autoCreateUniqueFilename() {
        return this.autoCreateUniqueFilename;
    }

    public String toString() {
        return "input file = " + this.inputFilePath + ":outputFile = " + this.outputFilePath;
    }
}

