/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import com.sun.jersey.core.header.QualitySourceMediaType;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractJaxRSResource {
    public static final String TEXT_HTML = "text/html;qs=2";
    private static final Log logger = LogFactory.getLog(AbstractJaxRSResource.class);
    protected List<MediaType> acceptableMediaTypes;
    @Context
    protected HttpServletRequest httpServletRequest;
    @Context
    protected HttpServletResponse httpServletResponse;

    @Context
    public void setHttpHeaders(HttpHeaders httpHeaders) {
        List mediaTypes = httpHeaders.getAcceptableMediaTypes();
        int htmlPos = -1;
        int xmlPos = -1;
        for (int i = 0; i < mediaTypes.size(); ++i) {
            MediaType t = (MediaType)mediaTypes.get(i);
            if (t.getSubtype().equals(MediaType.APPLICATION_XML_TYPE.getSubtype())) {
                xmlPos = i;
            }
            if (!t.getSubtype().equals(MediaType.TEXT_HTML_TYPE.getSubtype())) continue;
            htmlPos = i;
        }
        if (htmlPos > -1 && xmlPos > -1 && xmlPos < htmlPos) {
            MediaType origHtmlMediaType = (MediaType)mediaTypes.remove(htmlPos);
            HashMap<String, String> params = new HashMap<String, String>(origHtmlMediaType.getParameters());
            params.put("q", "2.0");
            QualitySourceMediaType newhtmlMediaType = new QualitySourceMediaType(origHtmlMediaType.getType(), origHtmlMediaType.getSubtype(), 2000, params);
            mediaTypes.add(xmlPos, newhtmlMediaType);
            logger.info((Object)("Bad Accept header detected by browser, mime type order rewritten as " + mediaTypes.toString()));
        }
        this.acceptableMediaTypes = mediaTypes;
    }
}

