/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class PentahoDataSourceTypeMap {
    private static final Log log = LogFactory.getLog(PentahoDataSourceTypeMap.class);
    private Map<String, Set<String>> mapDataSourceTypeToDomainIds = new HashMap<String, Set<String>>();

    PentahoDataSourceTypeMap() {
    }

    public void reset() {
        log.debug((Object)"reset()");
        this.mapDataSourceTypeToDomainIds.clear();
    }

    public void addDatasourceType(String datasourceType, String domainId) {
        log.debug((Object)String.format("addDatasourceType( datasourceType: %s, domainId: %s )", datasourceType, domainId));
        Set<String> setDomainIds = this.mapDataSourceTypeToDomainIds.get(datasourceType);
        if (setDomainIds == null) {
            setDomainIds = new HashSet<String>();
        }
        setDomainIds.add(domainId);
        this.mapDataSourceTypeToDomainIds.put(datasourceType, setDomainIds);
    }

    public void deleteDomainId(String domainId) {
        log.debug((Object)String.format("deleteDomainId( domainId: %s )", domainId));
        this.mapDataSourceTypeToDomainIds.values().stream().forEach(setDomainIds -> setDomainIds.remove(domainId));
    }

    public Set<String> getDatasourceType(String datasourceType) {
        log.debug((Object)String.format("getDatasourceType( datasourceType: %s )", datasourceType));
        return this.mapDataSourceTypeToDomainIds.containsKey(datasourceType) ? this.mapDataSourceTypeToDomainIds.get(datasourceType) : Collections.emptySet();
    }
}

