/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.condition.scriptable;

import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.apache.commons.logging.Log;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.IConditionalExecution;
import org.pentaho.platform.plugin.action.messages.Messages;

public class ScriptableCondition
implements IConditionalExecution {
    private String script;
    private String scriptLanguage = "JavaScript";
    private boolean defaultResult = true;
    private boolean ignoreInputNamesWithMinus = false;
    private boolean listAvailableEngines = false;

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public void setScriptLanguage(String value) {
        this.scriptLanguage = value;
    }

    public void setDefaultResult(boolean value) {
        this.defaultResult = value;
    }

    public boolean getDefaultResult() {
        return this.defaultResult;
    }

    public String getScriptLanguage() {
        return this.scriptLanguage;
    }

    public void setIgnoreInputNamesWithMinus(boolean value) {
        this.ignoreInputNamesWithMinus = value;
    }

    public boolean getIgnoreInputNamesWithMinus() {
        return this.ignoreInputNamesWithMinus;
    }

    public void setListAvailableEngines(boolean value) {
        this.listAvailableEngines = value;
        if (value) {
            System.out.println("*** DEBUG - Display Script Engine List ***");
            ScriptEngineManager manager = new ScriptEngineManager();
            List<ScriptEngineFactory> factories = manager.getEngineFactories();
            for (ScriptEngineFactory factory : factories) {
                System.out.println(String.format("Engine %s, Version %s, Language %s, Registered Names: %s", factory.getEngineName(), factory.getEngineVersion(), factory.getLanguageName(), factory.getNames().toString()));
            }
        }
    }

    public boolean shouldExecute(Map currentInputs, Log logger) throws Exception {
        boolean shouldExecute = this.getDefaultResult();
        ScriptEngineManager mgr = new ScriptEngineManager();
        ScriptEngine engine = mgr.getEngineByName(this.getScriptLanguage());
        if (engine == null) {
            throw new IllegalArgumentException(Messages.getInstance().getErrorString("ScriptableCondition.ERROR_0001_ENGINE_NOT_AVAILABLE", new Object[]{this.getScriptLanguage()}));
        }
        String inputName = null;
        for (Map.Entry mapEntry : currentInputs.entrySet()) {
            inputName = (String)mapEntry.getKey();
            if (this.getIgnoreInputNamesWithMinus() && inputName.indexOf(45) >= 0) {
                logger.info((Object)Messages.getInstance().getString("ScriptableCondition.INFO_IGNORED_INPUT", new Object[]{inputName}));
                continue;
            }
            IActionParameter inputParameter = (IActionParameter)mapEntry.getValue();
            Object inputValue = inputParameter.getValue();
            engine.put(inputName, inputValue);
        }
        engine.put("out", System.out);
        engine.put("rule", this);
        Object resultObject = engine.eval(this.getScript());
        if (resultObject instanceof Boolean) {
            return (Boolean)resultObject;
        }
        if (resultObject instanceof String) {
            return "true".equalsIgnoreCase(resultObject.toString()) || "yes".equalsIgnoreCase(resultObject.toString());
        }
        if (resultObject instanceof Number) {
            return ((Number)resultObject).intValue() > 0;
        }
        if (resultObject instanceof IPentahoResultSet) {
            return ((IPentahoResultSet)resultObject).getRowCount() > 0;
        }
        logger.info((Object)Messages.getInstance().getString("ScriptableCondition.INFO_DEFAULT_RESULT_RETURNED"));
        return shouldExecute;
    }
}

