/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.sql;

import java.sql.SQLException;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.actionsequence.dom.actions.SqlExecuteAction;
import org.pentaho.commons.connection.IPentahoMetaData;
import org.pentaho.commons.connection.memory.MemoryMetaData;
import org.pentaho.commons.connection.memory.MemoryResultSet;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.plugin.action.sql.SQLLookupRule;
import org.pentaho.platform.plugin.services.connections.sql.SQLConnection;

public class SQLExecute
extends SQLLookupRule {
    private static final long serialVersionUID = 2480019361917802106L;

    @Override
    public Log getLogger() {
        return LogFactory.getLog(SQLExecute.class);
    }

    @Override
    public boolean validateAction() {
        boolean result = true;
        if (!(this.getActionDefinition() instanceof SqlExecuteAction)) {
            this.error(Messages.getInstance().getErrorString("ComponentBase.ERROR_0001_UNKNOWN_ACTION_TYPE", new Object[]{this.getActionDefinition().getElement().asXML()}));
            result = false;
        } else {
            result = super.validateAction();
        }
        return result;
    }

    @Override
    protected boolean runQuery(String rawQuery, boolean live) {
        SQLConnection conn = (SQLConnection)this.connection;
        return this.runSqlQuery(conn, rawQuery, live);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean runSqlQuery(SQLConnection conn, String rawQuery, boolean live) {
        SqlExecuteAction sqlExecuteAction = (SqlExecuteAction)this.getActionDefinition();
        boolean executed = false;
        boolean continueOnException = sqlExecuteAction.getContinueOnException().getBooleanValue(false);
        String[] columnHeaders = new String[]{Messages.getInstance().getString("SQLExecute.USER_AFFECTED_ROWS_COLUMN_NAME"), Messages.getInstance().getString("SQLExecute.USER_AFFECTED_ROW_STATUS")};
        MemoryMetaData metaData = new MemoryMetaData((Object[][])new String[][]{columnHeaders}, null);
        metaData.setColumnTypes(new String[]{"int", "string"});
        MemoryResultSet affectedRowsResultSet = new MemoryResultSet((IPentahoMetaData)metaData);
        String successMsg = Messages.getInstance().getString("SQLExecute.USER_SUCCESS");
        String failMsg = Messages.getInstance().getString("SQLExecute.USER_FAILED");
        try {
            if (conn == null) {
                this.error(Messages.getInstance().getErrorString("SQLBaseComponent.ERROR_0007_NO_CONNECTION"));
                boolean bl = false;
                return bl;
            }
            if (!conn.initialized()) {
                this.error(Messages.getInstance().getErrorString("SQLBaseComponent.ERROR_0007_NO_CONNECTION"));
                boolean bl = false;
                return bl;
            }
            if (sqlExecuteAction.getForceSingleStatement().getBooleanValue(false)) {
                String query = this.applyInputsToFormat(rawQuery);
                this.debug(Messages.getInstance().getString("SQLBaseComponent.DEBUG_RUNNING_QUERY", new Object[]{query}));
                int affectedRows = conn.execute(query);
                executed = true;
                affectedRowsResultSet.addRow(new Object[]{new Integer(affectedRows), successMsg});
            } else {
                rawQuery = SQLExecute.removeLineTerminators(rawQuery.trim()).toString();
                StringTokenizer st = new StringTokenizer(rawQuery, sqlExecuteAction.getMultiStatementSeparator().getStringValue(";"));
                while (st.hasMoreTokens()) {
                    rawQuery = st.nextToken();
                    String query = this.applyInputsToFormat(rawQuery.trim());
                    this.debug(Messages.getInstance().getString("SQLBaseComponent.DEBUG_RUNNING_QUERY", new Object[]{query}));
                    try {
                        int affectedRows = conn.execute(query);
                        affectedRowsResultSet.addRow(new Object[]{new Integer(affectedRows), successMsg});
                        executed = true;
                        this.debug(Messages.getInstance().getString("SQLBaseComponent.DEBUG_UPDATED_QUERY", new Object[]{query}));
                    }
                    catch (SQLException e) {
                        this.error(Messages.getInstance().getErrorString("SQLBaseComponent.ERROR_0006_EXECUTE_FAILED", new Object[]{this.getActionName() + " : " + e.getLocalizedMessage()}));
                        executed = continueOnException;
                        if (!continueOnException) break;
                        this.addErrorCode(affectedRowsResultSet, e, failMsg);
                    }
                }
            }
            if (this.getResultOutputName() != null) {
                this.setOutputValue(this.getResultOutputName(), affectedRowsResultSet);
            }
        }
        catch (SQLException e) {
            this.error(Messages.getInstance().getErrorString("SQLBaseComponent.ERROR_0006_EXECUTE_FAILED", new Object[]{this.getActionName() + " : " + e.getLocalizedMessage()}));
            executed = continueOnException;
            this.addErrorCode(affectedRowsResultSet, e, e.getLocalizedMessage());
        }
        finally {
            if (this.connectionOwner) {
                conn.close();
            }
        }
        return executed;
    }

    public void addErrorCode(MemoryResultSet affectedRowsResultSet, SQLException e, String failMsg) {
        int eCode = e.getErrorCode();
        if (eCode > 0) {
            eCode *= -1;
        }
        affectedRowsResultSet.addRow(new Object[]{new Integer(eCode), e.getLocalizedMessage()});
    }

    public static String removeLineTerminators(String inputStr) {
        char[] rtn = new char[inputStr.length()];
        block3: for (int i = 0; i < inputStr.length(); ++i) {
            char ch = inputStr.charAt(i);
            switch (ch) {
                case '\n': 
                case '\r': {
                    rtn[i] = 32;
                    continue block3;
                }
                default: {
                    rtn[i] = ch;
                }
            }
        }
        return new String(rtn);
    }
}

