/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.jfreereport.outputs;

import java.awt.GraphicsEnvironment;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IComponent;
import org.pentaho.platform.plugin.action.jfreereport.AbstractJFreeReportComponent;
import org.pentaho.platform.plugin.action.jfreereport.outputs.AbstractGenerateContentComponent;
import org.pentaho.platform.plugin.action.jfreereport.outputs.JFreeReportCSVComponent;
import org.pentaho.platform.plugin.action.jfreereport.outputs.JFreeReportExcelComponent;
import org.pentaho.platform.plugin.action.jfreereport.outputs.JFreeReportHtmlComponent;
import org.pentaho.platform.plugin.action.jfreereport.outputs.JFreeReportPdfComponent;
import org.pentaho.platform.plugin.action.jfreereport.outputs.JFreeReportPreviewSwingComponent;
import org.pentaho.platform.plugin.action.jfreereport.outputs.JFreeReportPrintComponent;
import org.pentaho.platform.plugin.action.jfreereport.outputs.JFreeReportRTFComponent;
import org.pentaho.platform.plugin.action.jfreereport.outputs.JFreeReportXmlComponent;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.reporting.engine.classic.core.MasterReport;

public class JFreeReportAllContentComponent
extends AbstractJFreeReportComponent {
    private static final long serialVersionUID = -8233725514054165666L;
    private AbstractGenerateContentComponent component;

    public Log getLogger() {
        return LogFactory.getLog(((Object)((Object)this)).getClass());
    }

    protected boolean executeAction() throws Throwable {
        if (this.component != null) {
            this.debug(Messages.getInstance().getString("JFreeReportAllContentComponent.DEBUG_EXECUTING_COMPONENT", new Object[]{((Object)((Object)this.component)).toString()}));
            return this.component.execute() == 6;
        }
        this.debug(Messages.getInstance().getString("JFreeReportAllContentComponent.DEBUG_NO_COMPONENT"));
        return false;
    }

    public boolean init() {
        if (this.component != null) {
            return this.component.init();
        }
        return true;
    }

    public void done() {
        if (this.component != null) {
            this.component.done();
        }
    }

    protected boolean validateSystemSettings() {
        return true;
    }

    protected boolean initAndValidate(IComponent componentToValidate) {
        componentToValidate.setInstanceId(this.getInstanceId());
        componentToValidate.setActionName(this.getActionName());
        componentToValidate.setProcessId(this.getProcessId());
        componentToValidate.setComponentDefinition(this.getComponentDefinition());
        componentToValidate.setSession(this.getSession());
        componentToValidate.setRuntimeContext(this.getRuntimeContext());
        componentToValidate.setLoggingLevel(this.getLoggingLevel());
        componentToValidate.setMessages(this.getMessages());
        return componentToValidate.validate() == 1;
    }

    protected boolean validateAction() {
        if (this.isDefinedInput("printer-name")) {
            this.component = new JFreeReportPrintComponent();
            return this.initAndValidate((IComponent)this.component);
        }
        if (this.isDefinedInput("output-type")) {
            String reportOutputType = this.getInputStringValue("output-type");
            if (this.getLogger().isDebugEnabled()) {
                this.debug(Messages.getInstance().getString("JFreeReport.DEBUG_OUTPUT_TYPE", new Object[]{reportOutputType}));
            }
            if ("html".equals(reportOutputType)) {
                this.component = new JFreeReportHtmlComponent();
                return this.initAndValidate((IComponent)this.component);
            }
            if ("pdf".equals(reportOutputType)) {
                this.component = new JFreeReportPdfComponent();
                return this.initAndValidate((IComponent)this.component);
            }
            if ("xls".equals(reportOutputType)) {
                this.component = new JFreeReportExcelComponent();
                return this.initAndValidate((IComponent)this.component);
            }
            if ("csv".equals(reportOutputType)) {
                this.component = new JFreeReportCSVComponent();
                return this.initAndValidate((IComponent)this.component);
            }
            if ("rtf".equals(reportOutputType)) {
                this.component = new JFreeReportRTFComponent();
                return this.initAndValidate((IComponent)this.component);
            }
            if ("xml".equals(reportOutputType)) {
                this.component = new JFreeReportXmlComponent();
                return this.initAndValidate((IComponent)this.component);
            }
            if ("swing-preview".equals(reportOutputType)) {
                if (GraphicsEnvironment.isHeadless()) {
                    this.component = new JFreeReportPreviewSwingComponent();
                    return this.initAndValidate((IComponent)this.component);
                }
                this.warn(Messages.getInstance().getString("JFreeReportAllContentComponent.WARN_HEADLESSMODE_ACTIVE"));
                return false;
            }
            return false;
        }
        this.warn(Messages.getInstance().getString("JFreeReportAllContentComponent.WARN_NO_PRINTER_GIVEN"));
        return false;
    }

    protected boolean performExport(MasterReport report) {
        return false;
    }
}

