/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.chartbeans;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.pentaho.actionsequence.dom.ActionSequenceDocument;
import org.pentaho.actionsequence.dom.IActionInputSource;
import org.pentaho.actionsequence.dom.IActionSequenceInput;
import org.pentaho.actionsequence.dom.IActionSequenceInputSource;
import org.pentaho.actionsequence.dom.IActionSequenceOutput;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.MQLAction;
import org.pentaho.chart.model.ChartDataDefinition;
import org.pentaho.chart.model.ChartModel;
import org.pentaho.chart.model.util.ChartSerializer;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.api.engine.ISolutionEngine;
import org.pentaho.platform.config.messages.Messages;
import org.pentaho.platform.engine.core.output.SimpleOutputHandler;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.runtime.TemplateUtil;
import org.pentaho.platform.plugin.action.chartbeans.IChartBeansGenerator;
import org.pentaho.platform.plugin.action.pentahometadata.ActionDefinitionEncoder;
import org.pentaho.platform.util.UUIDUtil;
import org.pentaho.platform.util.web.SimpleUrlFactory;

public class DefaultChartBeansGenerator
implements IChartBeansGenerator {
    private Random random = new Random();
    private static final String URL_PATH_SEP = "/";
    private static final String DEFAULT_HTML_TEMPLATE = "<html><head><title>Command: doChart</title>{0}</head><body style='margin:0;' scroll='no'>{1}</body></html>";
    private static final String JFREE_CHART_HTML_TEMPLATE = "<html><head><title>Pentaho Chart</title></head><body style='margin:0;' scroll='no'>{imageMap}<img border=\"0\" width=\"{chartWidth}\" height=\"{chartHeight}\" src=\"{contextPath}getImage?image={imageFile}\" {useMap}/></body></html>";
    private static String DEFAULT_flashScriptFragment = "<input type=\"hidden\"/><script defer='defer' type=\"text/javascript\">function {dataFunction}() { return /*JSON*/\"{chartJson}\"/*END_JSON*/;}</script>";
    private static String DEFAULT_flashObjectFragment = "<object classid=\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\" codebase=\"http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0\" width=\"{chart-width}\" height=\"{chart-height}\"  id=\"ofco{chartId}\" align=\"middle\"> <param name=\"allowScriptAccess\" value=\"sameDomain\" /> <param name=\"wmode\" value=\"opaque\"><param name=\"movie\" value=\"{ofc-url}?get-data={dataFunction}\" /> <param name=\"quality\" value=\"high\" /> <embed src=\"{ofc-url}?get-data={dataFunction}\" wmode=\"opaque\" quality=\"high\" bgcolor=\"#FFFFFF\" width=\"{chart-width}\" height=\"{chart-height}\"  id=\"ofce{chartId}\" align=\"middle\" allowScriptAccess=\"sameDomain\" type=\"application/x-shockwave-flash\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" /></object>";

    private InputStream internalCreateChart(IPentahoSession pentahoSession, Map<String, Object> parameterMap, String serializedChartDataDefinition, String serializedChartModel, int chartWidth, int chartHeight, String contentLinkingTemplate, OutputStream outputStream) throws IOException {
        boolean returnInputStream;
        ByteArrayInputStream result = null;
        ByteArrayOutputStream resultOutputStream = null;
        OutputStream out = null;
        boolean bl = returnInputStream = outputStream == null;
        if (returnInputStream) {
            resultOutputStream = new ByteArrayOutputStream();
            out = new BufferedOutputStream(resultOutputStream);
        } else {
            out = outputStream;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chart-model-json", serializedChartModel);
        params.put("chart-width", chartWidth);
        params.put("chart-height", chartHeight);
        ChartDataDefinition chartDataDefinition = ChartSerializer.deSerializeDataDefinition((String)serializedChartDataDefinition, (ChartSerializer.ChartSerializationFormat)ChartSerializer.ChartSerializationFormat.JSON);
        if (chartDataDefinition.getQuery() != null) {
            params.put("query", chartDataDefinition.getQuery());
        }
        if (chartDataDefinition.getDomainColumn() != null) {
            params.put("series-column", chartDataDefinition.getDomainColumn());
        }
        if (chartDataDefinition.getCategoryColumn() != null && !chartDataDefinition.getCategoryColumn().equals("None")) {
            params.put("category-column", chartDataDefinition.getCategoryColumn());
        }
        if (chartDataDefinition.getRangeColumn() != null) {
            params.put("value-column", chartDataDefinition.getRangeColumn());
        }
        if (chartDataDefinition.getScalingFactor() != null) {
            params.put("scaling-factor", chartDataDefinition.getScalingFactor().toString());
        }
        this.createAndRunActionSequence(pentahoSession, params, parameterMap, contentLinkingTemplate, out);
        if (out instanceof BufferedOutputStream) {
            out.flush();
        }
        if (returnInputStream) {
            result = new ByteArrayInputStream(resultOutputStream.toByteArray());
            return result;
        }
        return null;
    }

    protected void createAndRunActionSequence(IPentahoSession pentahoSession, Map<String, Object> params, Map<String, Object> defaultParameterMap, String contentLinkingTemplate, OutputStream out) {
        SimpleParameterProvider parameterProvider = new SimpleParameterProvider(params);
        for (Map.Entry<String, Object> entry : defaultParameterMap.entrySet()) {
            parameterProvider.setParameter(entry.getKey(), entry.getValue());
        }
        HashMap<String, IParameterProvider> parameterProviders = new HashMap<String, IParameterProvider>();
        parameterProviders.put("request", (IParameterProvider)parameterProvider);
        SimpleOutputHandler outputHandler = new SimpleOutputHandler(out, true);
        outputHandler.setOutputPreference(3);
        ActionSequenceDocument doc = this.createActionSequenceDocument(defaultParameterMap.keySet(), contentLinkingTemplate);
        this.runActionSequence(pentahoSession, parameterProviders, (IOutputHandler)outputHandler, doc);
        try {
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void runActionSequence(IPentahoSession pentahoSession, Map<String, IParameterProvider> parameterProviders, IOutputHandler outputHandler, ActionSequenceDocument doc) throws RuntimeException {
        IRuntimeContext runtime;
        ISolutionEngine solutionEngine = (ISolutionEngine)PentahoSystem.get(ISolutionEngine.class, (IPentahoSession)pentahoSession);
        if (solutionEngine == null) {
            throw new RuntimeException("solutionEngine is null");
        }
        solutionEngine.setLoggingLevel(2);
        solutionEngine.init(pentahoSession);
        IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
        String contextPath = requestContext.getContextPath();
        SimpleUrlFactory urlFactory = new SimpleUrlFactory(contextPath);
        IParameterProvider requestParmProvider = parameterProviders.get("request");
        if (requestParmProvider.hasParameter("obj_id")) {
            String obj_id = (String)requestParmProvider.getParameter("obj_id");
            String msg_name = (String)requestParmProvider.getParameter("message_name");
            String job_id = (String)requestParmProvider.getParameter("job_id");
            runtime = solutionEngine.execute(doc.toString(), obj_id, job_id, false, true, msg_name, true, parameterProviders, outputHandler, null, (IPentahoUrlFactory)urlFactory, new ArrayList());
        } else {
            runtime = solutionEngine.execute(doc.toString(), "chartbeans_mql", "myprocessid", false, true, "myinstanceid", true, parameterProviders, outputHandler, null, (IPentahoUrlFactory)urlFactory, new ArrayList());
        }
        if (runtime != null && runtime.getStatus() != 6) {
            StringBuilder buf = new StringBuilder();
            boolean firstIteration = true;
            for (Object message : runtime.getMessages()) {
                Exception ex;
                if (message instanceof Exception && (ex = (Exception)message).getCause() instanceof RuntimeException) {
                    throw (RuntimeException)ex.getCause();
                }
                if (!firstIteration) {
                    buf.append(" \\\\ ");
                }
                buf.append(message);
            }
            String errorStr = buf.indexOf("action_sequence_failed") > -1 && buf.indexOf("MQLRelationalDataComponent") > -1 ? Messages.getInstance().getString("DefaultChartBeansGenerator.ERROR_0001_SECURITY_ERROR") : Messages.getInstance().getString("DefaultChartBeansGenerator.ERROR_0002_UNKNOWN_ERROR");
            throw new RuntimeException(errorStr);
        }
    }

    protected ActionSequenceDocument createActionSequenceDocument(Set<String> parameterNameSet, String contentLinkingTemplate) {
        ActionSequenceDocument actionSequenceDocument = new ActionSequenceDocument();
        actionSequenceDocument.setTitle("chartbeans_mql.xaction");
        actionSequenceDocument.setVersion("1");
        actionSequenceDocument.setLoggingLevel("debug");
        actionSequenceDocument.setAuthor("Dashboard");
        actionSequenceDocument.setDescription("Generate a chart through ChartBeans from an MQL statement.");
        actionSequenceDocument.setHelp("Pass in an MQL statement that returns a table of three columns. The first column is the series, the second is the category and the third is the data.");
        actionSequenceDocument.setHelp("");
        actionSequenceDocument.setResultType("rule");
        IActionSequenceInput queryInput = actionSequenceDocument.createInput("query", "string");
        IActionSequenceInput chartModelJsonInput = actionSequenceDocument.createInput("chart-model-json", "string");
        IActionSequenceInput chartWidthInput = actionSequenceDocument.createInput("chart-width", "integer");
        chartWidthInput.addSource("request", "chart-width");
        chartWidthInput.setDefaultValue("1");
        IActionSequenceInput chartHeightInput = actionSequenceDocument.createInput("chart-height", "integer");
        chartHeightInput.addSource("request", "chart-height");
        chartHeightInput.setDefaultValue("1");
        IActionSequenceInput seriesColumnInput = actionSequenceDocument.createInput("series-column", "string");
        seriesColumnInput.setDefaultValue("1");
        IActionSequenceInput categoryColumnInput = actionSequenceDocument.createInput("category-column", "string");
        categoryColumnInput.setDefaultValue("2");
        IActionSequenceInput valueColumnInput = actionSequenceDocument.createInput("value-column", "string");
        valueColumnInput.setDefaultValue("0");
        IActionSequenceInput scalingFactorInput = actionSequenceDocument.createInput("scaling-factor", "string");
        for (String parameterName : parameterNameSet) {
            IActionSequenceInput input = actionSequenceDocument.createInput(ActionDefinitionEncoder.encodeBlankSpaces(parameterName), "string");
            IActionSequenceInputSource[] sources = input.getSources();
            if (sources.length > 0) {
                input.getSources()[0].setName(parameterName);
                continue;
            }
            input.addSource("request", parameterName);
        }
        IActionSequenceOutput outputStreamOutput = actionSequenceDocument.createOutput("outputstream", "content");
        outputStreamOutput.addDestination("response", "content");
        MQLAction mqlAction = (MQLAction)actionSequenceDocument.addAction(MQLAction.class);
        mqlAction.setActionInputValue("query", (IActionInputSource)queryInput);
        for (String parameterName : parameterNameSet) {
            mqlAction.addInput(ActionDefinitionEncoder.encodeBlankSpaces(parameterName), "string");
        }
        mqlAction.setOutputResultSet("chartdata");
        mqlAction.setComponentDefinition("live", Boolean.TRUE.toString());
        mqlAction.setComponentDefinition("display-names", Boolean.FALSE.toString());
        ActionDefinition pojoAction = (ActionDefinition)actionSequenceDocument.addAction(ActionDefinition.class);
        pojoAction.setComponentName("ChartBeansComponent");
        if (contentLinkingTemplate != null) {
            pojoAction.setComponentDefinition("contentLinkingTemplate", contentLinkingTemplate);
        }
        pojoAction.setActionInputValue("chart-model-json", (IActionInputSource)chartModelJsonInput);
        pojoAction.addInput("chartdata", "result-set");
        pojoAction.setActionInputValue("chart-width", (IActionInputSource)chartWidthInput);
        pojoAction.setActionInputValue("chart-height", (IActionInputSource)chartHeightInput);
        pojoAction.setActionInputValue("series-column", (IActionInputSource)seriesColumnInput);
        pojoAction.setActionInputValue("category-column", (IActionInputSource)categoryColumnInput);
        pojoAction.setActionInputValue("value-column", (IActionInputSource)valueColumnInput);
        pojoAction.setActionInputValue("scaling-factor", (IActionInputSource)scalingFactorInput);
        pojoAction.addOutput("outputstream", "content");
        return actionSequenceDocument;
    }

    @Override
    public String buildEmptyOpenFlashChartHtmlFragment(String msg) {
        Properties props = new Properties();
        props.setProperty("dataFunction", "getChartData" + Integer.toString(this.random.nextInt(100000)));
        props.setProperty("chartJson", "{}");
        String flashHtml = MessageFormat.format(this.getHtmlTemplate(), TemplateUtil.applyTemplate((String)this.getFlashScriptFragment(), (Properties)props, null), msg);
        return flashHtml;
    }

    @Override
    public String buildOpenFlashChartHtmlFragment(String openFlashChartJson, String swfUrl, String chartWidth, String chartHeight) {
        String chartId = UUIDUtil.getUUIDAsString().replaceAll("[^\\w]", "");
        Properties props = new Properties();
        props.setProperty("chartId", chartId);
        props.setProperty("dataFunction", "getChartData" + Integer.toString(this.random.nextInt(100000)));
        props.setProperty("chart-width", chartWidth);
        props.setProperty("chart-height", chartHeight);
        props.setProperty("ofc-url", swfUrl);
        props.setProperty("chartJson", openFlashChartJson);
        String flashHtml = MessageFormat.format(this.getHtmlTemplate(), TemplateUtil.applyTemplate((String)this.getFlashScriptFragment(), (Properties)props, null), TemplateUtil.applyTemplate((String)this.getFlashObjectFragment(), (Properties)props, null));
        return flashHtml;
    }

    public String buildJFreeChartHtmlFragment(File imageFile, String imageMap, String imageMapName, int chartWidth, int chartHeight, String contextPath) {
        Properties props = new Properties();
        props.setProperty("imageMap", imageMap != null ? imageMap : "");
        props.setProperty("useMap", imageMapName != null ? "usemap=\"#" + imageMapName + "\"" : "");
        props.setProperty("contextPath", contextPath);
        props.setProperty("chartWidth", Integer.toString(chartWidth));
        props.setProperty("chartHeight", Integer.toString(chartHeight));
        props.setProperty("imageFile", imageFile.getName());
        return TemplateUtil.applyTemplate((String)JFREE_CHART_HTML_TEMPLATE, (Properties)props, null);
    }

    public String createChartAsHtml(IPentahoSession userSession, Map<String, Object> parameterMap, String serializedChartDataDefinition, String serializedChartModel, int chartWidth, int chartHeight, String contentLinkingTemplate) throws IOException {
        String override;
        ChartModel chartModel = ChartSerializer.deSerialize((String)serializedChartModel, (ChartSerializer.ChartSerializationFormat)ChartSerializer.ChartSerializationFormat.JSON);
        String html = null;
        if (chartModel.getChartEngineId() == null) {
            String defaultChartEngine = PentahoSystem.getSystemSetting((String)"chartbeans/chartbeans_config.xml", (String)"default-chart-engine", (String)"OpenFlashChart");
            if (defaultChartEngine == null) {
                defaultChartEngine = "OpenFlashChart";
            }
            chartModel.setChartEngineId(defaultChartEngine);
        }
        if ((override = (String)parameterMap.get("renderEngine")) != null) {
            chartModel.setChartEngineId(override);
        }
        serializedChartModel = ChartSerializer.serialize((ChartModel)chartModel, (ChartSerializer.ChartSerializationFormat)ChartSerializer.ChartSerializationFormat.JSON);
        if (contentLinkingTemplate == null) {
            html = this.createChartAsHtml(userSession, parameterMap, serializedChartDataDefinition, serializedChartModel, chartWidth, chartHeight);
        } else {
            String ENCODING = "UTF-8";
            InputStream is = this.internalCreateChart(userSession, parameterMap, serializedChartDataDefinition, serializedChartModel, chartWidth, chartHeight, contentLinkingTemplate, null);
            html = IOUtils.toString((InputStream)is, (String)"UTF-8");
        }
        return html;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createChartAsHtml(IPentahoSession userSession, Map<String, Object> parameterMap, String serializedChartDataDefinition, String serializedChartModel, int chartWidth, int chartHeight) throws IOException {
        String html;
        block8: {
            ChartModel chartModel;
            block7: {
                String override;
                chartModel = ChartSerializer.deSerialize((String)serializedChartModel, (ChartSerializer.ChartSerializationFormat)ChartSerializer.ChartSerializationFormat.JSON);
                html = null;
                if (chartModel.getChartEngineId() == null) {
                    String defaultChartEngine = PentahoSystem.getSystemSetting((String)"chartbeans/chartbeans_config.xml", (String)"default-chart-engine", (String)"OpenFlashChart");
                    if (defaultChartEngine == null) {
                        defaultChartEngine = "OpenFlashChart";
                    }
                    chartModel.setChartEngineId(defaultChartEngine);
                }
                if ((override = (String)parameterMap.get("renderEngine")) != null) {
                    chartModel.setChartEngineId(override);
                }
                serializedChartModel = ChartSerializer.serialize((ChartModel)chartModel, (ChartSerializer.ChartSerializationFormat)ChartSerializer.ChartSerializationFormat.JSON);
                if (!"JFreeChart".equals(chartModel.getChartEngineId())) break block7;
                String SOLUTION_TMP_DIR = "system/tmp/";
                File tmpDir = new File(PentahoSystem.getApplicationContext().getFileOutputPath("system/tmp/"));
                tmpDir.mkdirs();
                File chartFileOnServer = new File(tmpDir, UUID.randomUUID().toString());
                BufferedOutputStream bos = null;
                try {
                    bos = new BufferedOutputStream(new FileOutputStream(chartFileOnServer));
                    this.internalCreateChart(userSession, parameterMap, serializedChartDataDefinition, serializedChartModel, chartWidth, chartHeight, null, bos);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(bos);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)bos);
                IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
                String contextPath = requestContext.getContextPath();
                String url = contextPath + (!StringUtils.isEmpty((String)contextPath) && contextPath.endsWith(URL_PATH_SEP) ? "" : URL_PATH_SEP);
                String IMAGE_URL_TEMPLATE = "{0}getImage?image={1}";
                String imageUrl = MessageFormat.format("{0}getImage?image={1}", url, chartFileOnServer.getName());
                html = this.mergeStaticImageHtmlTemplate(imageUrl);
                break block8;
            }
            if ("OpenFlashChart".equals(chartModel.getChartEngineId())) {
                ByteArrayOutputStream tmpOut = new ByteArrayOutputStream();
                this.internalCreateChart(userSession, parameterMap, serializedChartDataDefinition, serializedChartModel, chartWidth, chartHeight, null, tmpOut);
                String ENCODING = "UTF-8";
                ByteArrayInputStream in = new ByteArrayInputStream(tmpOut.toByteArray());
                IOUtils.closeQuietly((OutputStream)tmpOut);
                html = IOUtils.toString((InputStream)in, (String)"UTF-8");
                IOUtils.closeQuietly((InputStream)in);
            } else {
                throw new IllegalArgumentException("unrecognized chart engine");
            }
        }
        return html;
    }

    @Override
    public String mergeOpenFlashChartHtmlTemplate(String openFlashChartJson, String swfUrl) {
        return this.buildOpenFlashChartHtmlFragment(openFlashChartJson, swfUrl, "100%", "100%");
    }

    @Override
    public String mergeJFreeChartHtmlTemplate(File imageFile, String imageMap, String imageMapName, int chartWidth, int chartHeight, String contextPath) {
        return this.buildJFreeChartHtmlFragment(imageFile, imageMap, imageMapName, chartWidth, chartHeight, contextPath);
    }

    @Override
    public String mergeStaticImageHtmlTemplate(String imageUrl) {
        String BODY_TEMPLATE = "<img src=\"{0}\" />";
        String body = MessageFormat.format("<img src=\"{0}\" />", imageUrl);
        return MessageFormat.format(this.getHtmlTemplate(), "", body);
    }

    @Override
    public String getHtmlTemplate() {
        return DEFAULT_HTML_TEMPLATE;
    }

    @Override
    public String getFlashScriptFragment() {
        return DEFAULT_flashScriptFragment;
    }

    @Override
    public String getFlashObjectFragment() {
        return DEFAULT_flashObjectFragment;
    }
}

