/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.config;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.dom4j.Node;
import org.pentaho.platform.api.engine.IConfiguration;
import org.pentaho.platform.api.engine.ISystemSettings;

public class SystemSettingsConfiguration
implements IConfiguration {
    private final String id;
    private final ISystemSettings settings;
    private Properties properties;

    public SystemSettingsConfiguration(String id, ISystemSettings settings) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        if (settings == null) {
            throw new IllegalArgumentException("SystemSettings is null");
        }
        this.id = id;
        this.settings = settings;
    }

    public String getId() {
        return "system";
    }

    public synchronized Properties getProperties() {
        if (this.properties == null) {
            Properties props = new Properties();
            List elements = this.settings.getSystemSettings("pentaho-system");
            if (elements == null) {
                return null;
            }
            List nodes = ((Element)elements.get(0)).content();
            this.addNodesToProperties(nodes, props, "");
            this.properties = props;
        }
        return this.properties;
    }

    private void addNodesToProperties(List<Node> nodes, Properties props, String parentPath) {
        for (Node node : nodes) {
            if (!(node instanceof Element)) continue;
            Element ele = (Element)node;
            String contents = ele.getText().trim();
            String newParentPath = "";
            if (!StringUtils.isEmpty((String)parentPath)) {
                newParentPath = parentPath + ".";
            }
            newParentPath = newParentPath + ele.getName();
            if (!StringUtils.isEmpty((String)contents)) {
                props.setProperty(newParentPath, contents);
            }
            List children = ele.content();
            this.addNodesToProperties(children, props, newParentPath);
        }
    }

    public void update(Properties addProperties) throws IOException {
        throw new UnsupportedOperationException("SystemSettings does not support write-back");
    }
}

