/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.config;

import java.io.File;
import java.io.IOException;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.pentaho.platform.config.IConsoleConfig;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;

public class ConsoleConfigXml
implements IConsoleConfig {
    protected static final String ROOT_ELEMENT = "console";
    protected static final String CHECK_PERIOD_XPATH = "console/biserver-status-check-period-millis";
    protected static final String PLATFORM_USERNAME_XPATH = "console/platform-username";
    protected static final String SOLUTION_PATH_XPATH = "console/solution-path";
    protected static final String WAR_PATH_XPATH = "console/war-path";
    protected static final String TEMP_DIR_PATH_XPATH = "console/temp-directory";
    protected static final String BACKUP_DIR_PATH_XPATH = "console/backup-directory";
    protected static final String HELP_URL_XPATH = "console/help_url";
    protected static final String JDBC_DRIVERS_XPATH = "console/jdbc-drivers-path";
    protected static final String DEFAULT_ROLES_XPATH = "console/default-roles";
    protected static final String HOME_PAGE_TIMEOUT_XPATH = "console/homepage-timeout-millis";
    protected static final String HOME_PAGE_URL_XPATH = "console/homepage-url";
    protected static final String XML_ENCODING_XPATH = "console/xml-encoding";
    protected static final String BASE_URL_XPATH = "console/base-url";
    protected static final String DEFAULT_SERVER_DIR_XPATH = "console/default-server-dir";
    Document document;

    @Override
    public String getBaseUrl() {
        return this.getValue(BASE_URL_XPATH);
    }

    @Override
    public void setBaseUrl(String url) {
        this.setValue(BASE_URL_XPATH, url);
    }

    public ConsoleConfigXml(File consoleConfigXmlFile) throws IOException, DocumentException {
        this(XmlDom4JHelper.getDocFromFile((File)consoleConfigXmlFile, null));
    }

    public ConsoleConfigXml(String xml) throws DocumentException {
        this(DocumentHelper.parseText((String)xml));
    }

    public ConsoleConfigXml(Document doc) throws DocumentException {
        Element rootElement = doc.getRootElement();
        if (rootElement != null && !doc.getRootElement().getName().equals(ROOT_ELEMENT)) {
            throw new DocumentException("Invalid root element.");
        }
        this.document = doc;
    }

    public ConsoleConfigXml() {
        this.document = DocumentHelper.createDocument();
        this.document.addElement(ROOT_ELEMENT);
    }

    @Override
    public Long getServerStatusCheckPeriod() {
        Long period = null;
        try {
            period = Long.parseLong(this.getValue(CHECK_PERIOD_XPATH));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return period;
    }

    @Override
    public void setServerStatusCheckPeriod(Long biServerStatusCheckPeriod) {
        String period = biServerStatusCheckPeriod != null ? Long.toString(biServerStatusCheckPeriod) : "";
        this.setValue(CHECK_PERIOD_XPATH, period);
    }

    @Override
    public Integer getHomePageTimeout() {
        Integer timeout = null;
        try {
            timeout = Integer.parseInt(this.getValue(HOME_PAGE_TIMEOUT_XPATH));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return timeout;
    }

    @Override
    public void setHomePageTimeout(Integer timeout) {
        this.setValue(HOME_PAGE_TIMEOUT_XPATH, timeout != null ? Integer.toString(timeout) : "");
    }

    @Override
    public String getHomePageUrl() {
        return this.getValue(HOME_PAGE_URL_XPATH);
    }

    @Override
    public void setHomePageUrl(String url) {
        this.setValue(HOME_PAGE_URL_XPATH, url);
    }

    @Override
    public String getHelpUrl() {
        return this.getValue(HELP_URL_XPATH);
    }

    @Override
    public void setHelpUrl(String url) {
        this.setValue(HELP_URL_XPATH, url);
    }

    @Override
    public String getJdbcDriversClassPath() {
        return this.getValue(JDBC_DRIVERS_XPATH);
    }

    @Override
    public void setJdbcDriversClassPath(String classpath) {
        this.setValue(JDBC_DRIVERS_XPATH, classpath);
    }

    @Override
    public String getDefaultRoles() {
        return this.getValue(DEFAULT_ROLES_XPATH);
    }

    @Override
    public void setDefaultRoles(String defaultRoles) {
        this.setValue(DEFAULT_ROLES_XPATH, defaultRoles);
    }

    @Override
    public String getPlatformUserName() {
        return this.getValue(PLATFORM_USERNAME_XPATH);
    }

    @Override
    public void setPlatformUserName(String platformUserName) {
        this.setValue(PLATFORM_USERNAME_XPATH, platformUserName);
    }

    @Override
    public String getSolutionPath() {
        return this.getValue(SOLUTION_PATH_XPATH);
    }

    @Override
    public void setSolutionPath(String solutionPath) {
        this.setValue(SOLUTION_PATH_XPATH, solutionPath);
    }

    @Override
    public String getWebAppPath() {
        return this.getValue(WAR_PATH_XPATH);
    }

    @Override
    public void setWebAppPath(String warPath) {
        this.setValue(WAR_PATH_XPATH, warPath);
    }

    @Override
    public String getTempDirectory() {
        return this.getValue(TEMP_DIR_PATH_XPATH);
    }

    @Override
    public void setTempDirectory(String path) {
        this.setValue(TEMP_DIR_PATH_XPATH, path);
    }

    @Override
    public String getBackupDirectory() {
        return this.getValue(BACKUP_DIR_PATH_XPATH);
    }

    @Override
    public void setBackupDirectory(String path) {
        this.setValue(BACKUP_DIR_PATH_XPATH, path);
    }

    public void setValue(String xPath, String value) {
        Element element = (Element)this.document.selectSingleNode(xPath);
        if (element == null) {
            element = DocumentHelper.makeElement((Branch)this.document, (String)xPath);
        }
        element.setText(value);
    }

    @Override
    public String getDefaultBiServerDir() {
        return this.getValue(DEFAULT_SERVER_DIR_XPATH);
    }

    @Override
    public void setDefaultBiServerDir(String defaultBiServerDir) {
        this.setValue(DEFAULT_SERVER_DIR_XPATH, defaultBiServerDir);
    }

    public String getValue(String xpath) {
        Element element = (Element)this.document.selectSingleNode(xpath);
        return element != null ? element.getText() : null;
    }

    @Override
    public String getXmlEncoding() {
        return this.getValue(XML_ENCODING_XPATH);
    }

    @Override
    public void setXmlEncoding(String encoding) {
        this.setValue(XML_ENCODING_XPATH, encoding);
    }

    public Document getDocument() {
        return this.document;
    }
}

