/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.scriptable;

import java.util.LinkedHashMap;
import javax.swing.table.TableModel;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.AbstractDataFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.states.LegacyDataRowWrapper;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class ScriptableDataFactory
extends AbstractDataFactory {
    private static final Log logger = LogFactory.getLog(ScriptableDataFactory.class);
    private LinkedHashMap<String, String> queries = new LinkedHashMap();
    private String language;
    private transient BSFManager interpreter;
    private transient LegacyDataRowWrapper dataRowWrapper;
    private String script;
    private String shutdownScript;

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setQuery(String name, String value) {
        if (value == null) {
            this.queries.remove(name);
        } else {
            this.queries.put(name, value);
        }
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getShutdownScript() {
        return this.shutdownScript;
    }

    public void setShutdownScript(String shutdownScript) {
        this.shutdownScript = shutdownScript;
    }

    public String getQuery(String name) {
        return this.queries.get(name);
    }

    public String[] getQueryNames() {
        return this.queries.keySet().toArray(new String[this.queries.size()]);
    }

    protected BSFManager createInterpreter() throws BSFException {
        BSFManager interpreter = new BSFManager();
        this.initializeInterpreter(interpreter);
        return interpreter;
    }

    protected void initializeInterpreter(BSFManager interpreter) throws BSFException {
        this.dataRowWrapper = new LegacyDataRowWrapper();
        interpreter.declareBean("dataRow", (Object)this.dataRowWrapper, DataRow.class);
        interpreter.declareBean("configuration", (Object)this.getConfiguration(), Configuration.class);
        interpreter.declareBean("contextKey", (Object)this.getContextKey(), ResourceKey.class);
        interpreter.declareBean("resourceManager", (Object)this.getResourceManager(), ResourceManager.class);
        interpreter.declareBean("resourceBundleFactory", (Object)this.getResourceBundleFactory(), ResourceBundleFactory.class);
        interpreter.declareBean("dataFactoryContext", (Object)this.getDataFactoryContext(), ResourceBundleFactory.class);
        if (this.script != null) {
            interpreter.exec(this.getLanguage(), "startup-script", 1, 1, (Object)this.getScript());
        }
    }

    public TableModel queryData(String query, DataRow parameters) throws ReportDataFactoryException {
        boolean allowScriptEval = ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.engine.classic.core.allowScriptEvaluation", "false").equalsIgnoreCase("true");
        if (!allowScriptEval) {
            throw new ReportDataFactoryException("Scripts are prevented from running by default in order to avoid potential remote code execution.  The system administrator must enable this capability.");
        }
        String queryScript = this.queries.get(query);
        if (queryScript == null) {
            throw new ReportDataFactoryException("No such query");
        }
        if (this.interpreter == null) {
            try {
                this.interpreter = this.createInterpreter();
            }
            catch (BSFException e) {
                throw new ReportDataFactoryException("Failed to initialize the BSF-Framework", (Throwable)e);
            }
        }
        try {
            this.dataRowWrapper.setParent(parameters);
            Object o = this.interpreter.eval(this.getLanguage(), "expression", 1, 1, (Object)queryScript);
            if (!(o instanceof TableModel)) {
                throw new ReportDataFactoryException("Resulting value is not a tablemodel");
            }
            return (TableModel)o;
        }
        catch (ReportDataFactoryException rde) {
            throw rde;
        }
        catch (Exception e) {
            throw new ReportDataFactoryException("Evaluation error", (Throwable)e);
        }
    }

    public ScriptableDataFactory clone() {
        ScriptableDataFactory dataFactory = (ScriptableDataFactory)super.clone();
        dataFactory.queries = (LinkedHashMap)this.queries.clone();
        dataFactory.interpreter = null;
        dataFactory.dataRowWrapper = null;
        return dataFactory;
    }

    public DataFactory derive() {
        return this.clone();
    }

    public void close() {
        if (this.interpreter != null && this.shutdownScript != null) {
            try {
                this.interpreter.eval(this.getLanguage(), "shutdown-script", 1, 1, (Object)this.getShutdownScript());
            }
            catch (BSFException e) {
                logger.warn((Object)"Failed to evaluate shutdown-script", (Throwable)e);
            }
        }
        this.dataRowWrapper = null;
        this.interpreter = null;
    }

    public boolean isQueryExecutable(String query, DataRow parameters) {
        return this.queries.containsKey(query);
    }

    public void cancelRunningQuery() {
        if (this.interpreter != null) {
            this.interpreter.terminate();
        }
    }
}

