/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.server;

import com.google.gwt.core.server.ServerGwtBridge;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GwtServletBase
extends HttpServlet {
    protected String[] localeSearchOrder = new String[]{"queryparam", "cookie", "meta", "useragent"};
    protected String defaultLocale = "default";
    protected String localeCookie = null;
    protected String localeQueryParam = "locale";

    public void init() throws ServletException {
    }

    protected final String getCookie(HttpServletRequest req, String cookieName) {
        Cookie[] cookies = req.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(cookieName)) continue;
            return cookie.getValue();
        }
        return null;
    }

    protected String getGwtLocale(HttpServletRequest req) {
        String locale = null;
        for (String localeMethod : this.localeSearchOrder) {
            if ("cookie".equals(localeMethod)) {
                if (this.localeCookie != null) {
                    locale = this.getCookie(req, this.localeCookie);
                }
            } else if ("queryparam".equals(localeMethod)) {
                if (this.localeQueryParam != null) {
                    locale = req.getParameter(this.localeQueryParam);
                }
            } else if ("useragent".equals(localeMethod) || "usemeta".equals(localeMethod)) {
                // empty if block
            }
            if (locale == null) continue;
            return locale;
        }
        return this.defaultLocale;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.setGwtProperties(req);
        super.service(req, resp);
    }

    protected void setGwtProperties(HttpServletRequest req) {
        ServerGwtBridge.getInstance().setThreadProperty("locale", this.getGwtLocale(req));
    }
}

