/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.jms.ui;

import com.google.common.base.Preconditions;
import java.util.EnumMap;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.jms.JmsConstants;
import org.pentaho.di.trans.step.jms.JmsDelegate;
import org.pentaho.di.trans.step.jms.context.JmsProvider;
import org.pentaho.di.trans.step.jms.ui.JmsDialogSecurityLayout;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.widget.TextVar;

public class ConnectionForm {
    private final Composite parentComponent;
    private final JmsDelegate jmsDelegate;
    private final JmsDialogSecurityLayout jmsDialogSecurityLayout;
    private PropsUI props;
    private TransMeta transMeta;
    private ModifyListener lsMod;
    private EnumMap<JmsProvider.ConnectionType, Button> typesToButtons = new EnumMap(JmsProvider.ConnectionType.class);
    private Group wConnectionGroup;
    private Label wlIbmUrl;
    private TextVar wIbmUrl;
    private Label wlActiveUrl;
    private TextVar wActiveUrl;

    ConnectionForm(Composite parentComponent, PropsUI props, TransMeta transMeta, ModifyListener lsMod, JmsDelegate jmsDelegate, JmsDialogSecurityLayout jmsDialogSecurityLayout) {
        Preconditions.checkNotNull((Object)parentComponent);
        Preconditions.checkNotNull((Object)props);
        Preconditions.checkNotNull((Object)transMeta);
        Preconditions.checkNotNull((Object)lsMod);
        this.parentComponent = parentComponent;
        this.props = props;
        this.transMeta = transMeta;
        this.lsMod = lsMod;
        this.jmsDelegate = jmsDelegate;
        this.jmsDialogSecurityLayout = jmsDialogSecurityLayout;
    }

    Group layoutForm() {
        FormLayout setupLayout = new FormLayout();
        setupLayout.marginHeight = 15;
        setupLayout.marginWidth = 15;
        this.parentComponent.setLayout((Layout)setupLayout);
        this.wConnectionGroup = new Group(this.parentComponent, 16);
        this.wConnectionGroup.setText(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Connection", (String[])new String[0]));
        FormLayout flConnection = new FormLayout();
        flConnection.marginHeight = 15;
        flConnection.marginWidth = 15;
        this.wConnectionGroup.setLayout((Layout)flConnection);
        FormData fdConnectionGroup = new FormData();
        fdConnectionGroup.left = new FormAttachment(0, 0);
        fdConnectionGroup.top = new FormAttachment(0, 0);
        fdConnectionGroup.right = new FormAttachment(100, 0);
        fdConnectionGroup.width = 350;
        this.wConnectionGroup.setLayoutData((Object)fdConnectionGroup);
        this.props.setLook((Control)this.wConnectionGroup);
        this.displayConnTypes(this.wConnectionGroup);
        this.setStartingsVals();
        return this.wConnectionGroup;
    }

    private void setStartingsVals() {
        this.wIbmUrl.setText(this.jmsDelegate.ibmUrl);
        this.wActiveUrl.setText(this.jmsDelegate.amqUrl);
        JmsProvider.ConnectionType connectionType = JmsProvider.ConnectionType.valueOf(this.jmsDelegate.connectionType);
        this.typesToButtons.get((Object)connectionType).setSelection(true);
        this.toggleVisibility(connectionType);
    }

    private void displayConnTypes(Group wConnectionGroup) {
        Button previous = null;
        Button widestWidget = null;
        for (final JmsProvider.ConnectionType type : JmsProvider.ConnectionType.values()) {
            Button connectionButton = new Button((Composite)wConnectionGroup, 16);
            connectionButton.setText(type.toString());
            this.typesToButtons.put(type, connectionButton);
            FormData fdbConnType = new FormData();
            fdbConnType.left = new FormAttachment(0, 0);
            fdbConnType.top = previous == null ? new FormAttachment(0, 0) : new FormAttachment(previous, 10);
            previous = connectionButton;
            connectionButton.setLayoutData((Object)fdbConnType);
            connectionButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ConnectionForm.this.lsMod.modifyText(null);
                    ConnectionForm.this.toggleVisibility(type);
                }

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    ConnectionForm.this.toggleVisibility(type);
                }
            });
            this.props.setLook((Control)connectionButton);
            if (null != widestWidget && previous.getSize().y <= widestWidget.getSize().y) continue;
            widestWidget = previous;
        }
        Label environmentSeparator = new Label((Composite)wConnectionGroup, 514);
        FormData fdenvironmentSeparator = new FormData();
        fdenvironmentSeparator.top = new FormAttachment(0, 0);
        fdenvironmentSeparator.left = new FormAttachment(widestWidget, 15);
        fdenvironmentSeparator.bottom = new FormAttachment(100, 0);
        environmentSeparator.setLayoutData((Object)fdenvironmentSeparator);
        this.layoutIbmMqConnectionFields((Control)environmentSeparator);
        this.layoutActiveMqConnectionFields((Control)environmentSeparator);
    }

    private void layoutIbmMqConnectionFields(Control leftOf) {
        this.wlIbmUrl = new Label((Composite)this.wConnectionGroup, 16384);
        this.props.setLook((Control)this.wlIbmUrl);
        this.wlIbmUrl.setText(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.JmsUrl", (String[])new String[0]));
        FormData fdlJmsUrl = new FormData();
        fdlJmsUrl.left = new FormAttachment(leftOf, 15);
        fdlJmsUrl.top = new FormAttachment(0, 0);
        this.wlIbmUrl.setLayoutData((Object)fdlJmsUrl);
        this.wIbmUrl = new TextVar((VariableSpace)this.transMeta, (Composite)this.wConnectionGroup, 18436);
        this.wIbmUrl.setToolTipText(JmsProvider.ConnectionType.WEBSPHERE.getUrlHint());
        this.props.setLook((Control)this.wIbmUrl);
        this.wIbmUrl.addModifyListener(this.lsMod);
        FormData fdUrl = new FormData();
        fdUrl.left = new FormAttachment(leftOf, 15);
        fdUrl.top = new FormAttachment((Control)this.wlIbmUrl, 5);
        fdUrl.right = new FormAttachment(100, 0);
        this.wIbmUrl.setLayoutData((Object)fdUrl);
    }

    private void layoutActiveMqConnectionFields(Control leftOf) {
        this.wlActiveUrl = new Label((Composite)this.wConnectionGroup, 16384);
        this.props.setLook((Control)this.wlActiveUrl);
        this.wlActiveUrl.setText(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.JmsUrl", (String[])new String[0]));
        FormData fdlJmsUrl = new FormData();
        fdlJmsUrl.left = new FormAttachment(leftOf, 15);
        fdlJmsUrl.top = new FormAttachment(0, 0);
        this.wlActiveUrl.setLayoutData((Object)fdlJmsUrl);
        this.wActiveUrl = new TextVar((VariableSpace)this.transMeta, (Composite)this.wConnectionGroup, 18436);
        this.wActiveUrl.setToolTipText(JmsProvider.ConnectionType.ACTIVEMQ.getUrlHint());
        this.props.setLook((Control)this.wActiveUrl);
        this.wActiveUrl.addModifyListener(this.lsMod);
        FormData fdJmsUrl = new FormData();
        fdJmsUrl.left = new FormAttachment(leftOf, 15);
        fdJmsUrl.top = new FormAttachment((Control)this.wlActiveUrl, 5);
        fdJmsUrl.right = new FormAttachment(100, 0);
        this.wActiveUrl.setLayoutData((Object)fdJmsUrl);
    }

    public String getIbmUrl() {
        return this.wIbmUrl.getText();
    }

    public String getActiveUrl() {
        return this.wActiveUrl.getText();
    }

    public String getConnectionType() {
        return ((JmsProvider.ConnectionType)((Object)this.typesToButtons.entrySet().stream().filter(entry -> ((Button)entry.getValue()).getSelection()).findFirst().orElseThrow(() -> new IllegalStateException("One type should be selected")).getKey())).name();
    }

    private void toggleVisibility(JmsProvider.ConnectionType type) {
        if (type == JmsProvider.ConnectionType.WEBSPHERE) {
            this.jmsDialogSecurityLayout.toggleVisibility(type);
            this.setIbmMqVisibility(true);
            this.setActiveMqVisibility(false);
        } else if (type == JmsProvider.ConnectionType.ACTIVEMQ) {
            this.jmsDialogSecurityLayout.toggleVisibility(type);
            this.setIbmMqVisibility(false);
            this.setActiveMqVisibility(true);
        }
    }

    private void setIbmMqVisibility(boolean isVisible) {
        this.wlIbmUrl.setVisible(isVisible);
        this.wIbmUrl.setVisible(isVisible);
    }

    private void setActiveMqVisibility(boolean isVisible) {
        this.wlActiveUrl.setVisible(isVisible);
        this.wActiveUrl.setVisible(isVisible);
    }
}

