/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.jms.context;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.jms.Destination;
import javax.jms.JMSContext;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQQueue;
import org.apache.activemq.artemis.jms.client.ActiveMQTopic;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.jms.JmsConstants;
import org.pentaho.di.trans.step.jms.JmsDelegate;
import org.pentaho.di.trans.step.jms.context.JmsProvider;

public class ActiveMQProvider
implements JmsProvider {
    private static final String CHAR_ENCODING = "UTF-8";
    public static final String PW_DEBUG_MASK = "********";

    @Override
    public boolean supports(JmsProvider.ConnectionType type) {
        return type == JmsProvider.ConnectionType.ACTIVEMQ;
    }

    @Override
    public JMSContext getContext(JmsDelegate delegate) {
        String finalUrl = this.buildUrl(delegate, false);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(finalUrl);
        return factory.createContext(delegate.amqUsername, delegate.amqPassword);
    }

    @Override
    public String getConnectionDetails(JmsDelegate meta) {
        return "User Name: " + (Strings.isNullOrEmpty((String)meta.amqUsername) ? "" : meta.amqUsername) + "\nPassword: " + PW_DEBUG_MASK + "\nURL: " + this.buildUrl(meta, true);
    }

    String buildUrl(JmsDelegate delegate, boolean debug) {
        StringBuilder finalUrl = new StringBuilder(delegate.amqUrl.trim());
        if (delegate.sslEnabled && !finalUrl.toString().contains("sslEnabled")) {
            this.appendSslOptions(delegate, finalUrl, debug);
        }
        return finalUrl.toString();
    }

    private void appendSslOptions(JmsDelegate delegate, StringBuilder finalUrl, boolean debug) {
        StringBuilder urlQuery = new StringBuilder();
        if (!finalUrl.toString().contains("?")) {
            urlQuery.append("?");
        } else if (!finalUrl.toString().endsWith("&")) {
            urlQuery.append("&");
        }
        urlQuery.append("sslEnabled=true");
        if (delegate.sslUseDefaultContext) {
            urlQuery.append("&useDefaultSslContext=true");
        } else {
            if (!Strings.isNullOrEmpty((String)delegate.sslKeystorePath)) {
                Preconditions.checkState((!Strings.isNullOrEmpty((String)delegate.sslKeystorePassword) ? 1 : 0) != 0, (Object)BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Security.KeystorePasswordRequired", (String[])new String[0]));
                urlQuery.append("&keyStorePath=").append(this.urlEncode(delegate.sslKeystorePath.trim()));
                urlQuery.append("&keyStorePassword=").append(debug ? PW_DEBUG_MASK : this.urlEncode(delegate.sslKeystorePassword.trim()));
            }
            Preconditions.checkState((!Strings.isNullOrEmpty((String)delegate.sslTruststorePath.trim()) ? 1 : 0) != 0, (Object)BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Security.TrustStorePathRequired", (String[])new String[0]));
            this.addParam("trustStorePath", delegate.sslTruststorePath, urlQuery, false);
            this.addParam("trustStorePassword", delegate.sslTruststorePassword, urlQuery, debug);
            this.addParam("enabledCipherSuites", delegate.sslCipherSuite, urlQuery, false);
            this.addParam("enabledProtocols", delegate.sslContextAlgorithm, urlQuery, false);
            this.addParam("verifyHost", delegate.amqSslVerifyHost, urlQuery, false);
            this.addParam("trustAll", delegate.amqSslTrustAll, urlQuery, false);
            this.addParam("sslProvider", delegate.amqSslProvider, urlQuery, false);
        }
        finalUrl.append(urlQuery.toString());
    }

    private void addParam(String paramName, String value, StringBuilder queryBuilder, boolean debug) {
        String trimmed = value.trim();
        if (!Strings.isNullOrEmpty((String)trimmed)) {
            queryBuilder.append("&").append(paramName).append("=").append(debug ? PW_DEBUG_MASK : this.urlEncode(trimmed));
        }
    }

    private String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, CHAR_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Destination getDestination(JmsDelegate delegate) {
        Preconditions.checkNotNull((Object)delegate.destinationName, (Object)BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsWebsphereMQ.DestinationNameRequired", (String[])new String[0]));
        String destName = delegate.destinationName;
        return this.isQueue(delegate) ? new ActiveMQQueue(destName) : new ActiveMQTopic(destName);
    }
}

