/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.jms;

import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.GenericStepData;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.ISubTransAwareMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.jms.JmsConsumer;
import org.pentaho.di.trans.step.jms.JmsDelegate;
import org.pentaho.di.trans.streaming.common.BaseStreamStepMeta;
import org.pentaho.metaverse.api.analyzer.kettle.annotations.Metaverse;

@InjectionSupported(localizationPrefix="JmsConsumerMeta.Injection.", groups={"SSL_GROUP"})
@Step(id="Jms2Consumer", image="JMSC.svg", i18nPackageName="org.pentaho.di.trans.step.jms", name="JmsConsumer.TypeLongDesc", description="JmsConsumer.TypeTooltipDesc", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.Streaming", documentationUrl="Products/JMS_Consumer")
@Metaverse.CategoryMaps(value={@Metaverse.CategoryMap(entity="JMS Destination", category="messageQueue"), @Metaverse.CategoryMap(entity="JMS Server", category="datasource")})
@Metaverse.EntityLinks(value={@Metaverse.EntityLink(entity="JMS Server", link="parentconcept", parentEntity="External Connection"), @Metaverse.EntityLink(entity="JMS Destination", link="containsconcept", parentEntity="JMS Server"), @Metaverse.EntityLink(entity="JMS Destination", link="parentconcept")})
public class JmsConsumerMeta
extends BaseStreamStepMeta
implements ISubTransAwareMeta,
StepMetaInterface {
    private static final String JMS_MESSAGE_METAVERSE = "Message";
    private static final String JMS_DESTINATION_NAME_METAVERSE = "Destination Name";
    private static final String JMS_MESSAGE_ID_METAVERSE = "Message Id";
    private static final String JMS_TIMESTAMP_METAVERSE = "JMS Timestamp";
    private static final String JMS_REDELIVERED_METAVERSE = "JMS Redelivered";
    @InjectionDeep
    public JmsDelegate jmsDelegate;
    @Injection(name="RECEIVE_TIMEOUT")
    public String receiveTimeout = "0";
    @Injection(name="MESSAGE_FIELD_NAME")
    @Metaverse.Node(name="Message", type="_resource_", link="inputs", nameFromValue="FALSE", subTransLink="SUBTRANS_INPUT")
    @Metaverse.Property(name="Message", parentNodeName="Message")
    @Metaverse.NodeLink(nodeName="Message", parentNodeName="JMS Destination", linkDirection="OUT")
    public String messageField = "message";
    @Injection(name="DESTINATION_FIELD_NAME")
    @Metaverse.Node(name="Destination Name", type="_resource_", link="inputs", nameFromValue="FALSE", subTransLink="SUBTRANS_INPUT")
    @Metaverse.Property(name="Destination Name", parentNodeName="Destination Name")
    @Metaverse.NodeLink(nodeName="Destination Name", parentNodeName="JMS Destination", linkDirection="OUT")
    public String destinationField = "destination";
    @Injection(name="MESSAGE_ID")
    @Metaverse.Node(name="Message Id", type="_resource_", link="inputs", nameFromValue="FALSE", subTransLink="SUBTRANS_INPUT")
    @Metaverse.Property(name="Message Id", parentNodeName="Message Id")
    @Metaverse.NodeLink(nodeName="Message Id", parentNodeName="JMS Destination", linkDirection="OUT")
    public String messageId = "messageId";
    @Injection(name="JMS_TIMESTAMP")
    @Metaverse.Node(name="JMS Timestamp", type="_resource_", link="inputs", nameFromValue="FALSE", subTransLink="SUBTRANS_INPUT")
    @Metaverse.Property(name="JMS Timestamp", parentNodeName="JMS Timestamp")
    @Metaverse.NodeLink(nodeName="JMS Timestamp", parentNodeName="JMS Destination", linkDirection="OUT")
    public String jmsTimestamp = "jmsTimestamp";
    @Injection(name="JMS_REDELIVERED")
    @Metaverse.Node(name="JMS Redelivered", type="_resource_", link="inputs", nameFromValue="FALSE", subTransLink="SUBTRANS_INPUT")
    @Metaverse.Property(name="JMS Redelivered", parentNodeName="JMS Redelivered")
    @Metaverse.NodeLink(nodeName="JMS Redelivered", parentNodeName="JMS Destination", linkDirection="OUT")
    public String jmsRedelivered = "jmsRedelivered";

    public JmsConsumerMeta() {
        this(new JmsDelegate());
    }

    public JmsConsumerMeta(JmsDelegate jmsDelegate) {
        this.setSpecificationMethod(ObjectLocationSpecificationMethod.FILENAME);
        this.jmsDelegate = jmsDelegate;
    }

    public String getDialogClassName() {
        return "org.pentaho.di.trans.step.jms.ui.JmsConsumerDialog";
    }

    public RowMeta getRowMeta(String s, VariableSpace variableSpace) {
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString(this.messageField));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString(this.destinationField));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString(this.messageId));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString(this.jmsTimestamp));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString(this.jmsRedelivered));
        return rowMeta;
    }

    public JmsDelegate getJmsDelegate() {
        return this.jmsDelegate;
    }

    public String getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        return new JmsConsumer(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new GenericStepData();
    }

    RowMetaInterface getRowMeta() {
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString(this.messageField));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString(this.destinationField));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString(this.messageId));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString(this.jmsTimestamp));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString(this.jmsRedelivered));
        return rowMeta;
    }
}

