/*
 * Decompiled with CFR 0.152.
 */
package com.totvscrm.pentaho.step.opensocket;

import com.totvscrm.pentaho.step.opensocket.OpenSocket;
import com.totvscrm.pentaho.step.opensocket.OpenSocketData;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="OpenSocket", image="opensocket.png", i18nPackageName="com.totvscrm.pentaho.step.opensocket", name="OpenSocket.Name", description="OpenSocket.TooltipDesc", categoryDescription="OpenSocket.CategoryName", documentationUrl="https://wsintegracoes.webnode.com/opensocket/", casesUrl="https://wsintegracoes.webnode.com/opensocket/", forumUrl="https://wsintegracoes.webnode.com/opensocket/")
public class OpenSocketMeta
extends BaseStepMeta
implements StepMetaInterface {
    public static Class<?> PKG = OpenSocketMeta.class;
    public String porta;
    public boolean kill;

    public Object clone() {
        OpenSocketMeta retval = (OpenSocketMeta)((Object)super.clone());
        return retval;
    }

    public void setDefault() {
        this.porta = "0";
        this.kill = false;
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void readData(Node stepnode) throws KettleXMLException {
        try {
            this.setPorta(XMLHandler.getNodeValue((Node)XMLHandler.getSubNode((Node)stepnode, (String)"porta")));
            this.setKill("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"kill")));
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to read step information from XML", (Throwable)e);
        }
    }

    public String getXML() {
        StringBuilder retval = new StringBuilder(300);
        retval.append(XMLHandler.addTagValue((String)"porta", (String)this.porta));
        retval.append(XMLHandler.addTagValue((String)"kill", (boolean)this.kill));
        return retval.toString();
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.porta = rep.getStepAttributeString(id_step, "porta");
            this.kill = rep.getStepAttributeBoolean(id_step, "kill");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "porta", this.porta);
            rep.saveStepAttribute(id_transformation, id_step, "kill", this.kill);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + String.valueOf(id_step), (Throwable)e);
        }
    }

    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        ValueMetaInterface v;
        RowMeta row = new RowMeta();
        try {
            v = ValueMetaFactory.createValueMeta((String)"porta", (int)2);
        }
        catch (KettlePluginException e) {
            throw new KettleStepException((Throwable)e);
        }
        v.setOrigin(name);
        row.addValueMeta(v);
        inputRowMeta.mergeRowMeta((RowMetaInterface)row, name);
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        int nrRemarks = remarks.size();
        if (remarks.size() == nrRemarks) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GetVariableMeta.CheckResult.AllVariablesSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new OpenSocket(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new OpenSocketData();
    }

    public String getPorta() {
        return this.porta;
    }

    public void setPorta(String porta) {
        this.porta = porta;
    }

    public boolean isKill() {
        return this.kill;
    }

    public void setKill(boolean kill) {
        this.kill = kill;
    }

    public static class FieldDefinition
    implements Cloneable {
        @Injection(name="FIELDNAME", group="FIELDS")
        public String fieldName;
        @Injection(name="VARIABLE", group="FIELDS")
        public String variableString;
        @Injection(name="FIELDTYPE", group="FIELDS")
        public int fieldType;
        @Injection(name="FIELDFORMAT", group="FIELDS")
        public String fieldFormat;
        @Injection(name="FIELDLENGTH", group="FIELDS")
        public int fieldLength;
        @Injection(name="FIELDPRECISION", group="FIELDS")
        public int fieldPrecision;
        @Injection(name="CURRENCY", group="FIELDS")
        public String currency;
        @Injection(name="DECIMAL", group="FIELDS")
        public String decimal;
        @Injection(name="GROUP", group="FIELDS")
        public String group;
        @Injection(name="TRIMTYPE", group="FIELDS")
        public int trimType;

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getVariableString() {
            return this.variableString;
        }

        public void setVariableString(String variableString) {
            this.variableString = variableString;
        }

        public int getFieldType() {
            return this.fieldType;
        }

        public void setFieldType(int fieldType) {
            this.fieldType = fieldType;
        }

        public String getFieldFormat() {
            return this.fieldFormat;
        }

        public void setFieldFormat(String fieldFormat) {
            this.fieldFormat = fieldFormat;
        }

        public int getFieldLength() {
            return this.fieldLength;
        }

        public void setFieldLength(int fieldLength) {
            this.fieldLength = fieldLength;
        }

        public int getFieldPrecision() {
            return this.fieldPrecision;
        }

        public void setFieldPrecision(int fieldPrecision) {
            this.fieldPrecision = fieldPrecision;
        }

        public String getCurrency() {
            return this.currency;
        }

        public void setCurrency(String currency) {
            this.currency = currency;
        }

        public String getDecimal() {
            return this.decimal;
        }

        public void setDecimal(String decimal) {
            this.decimal = decimal;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public int getTrimType() {
            return this.trimType;
        }

        public void setTrimType(int trimType) {
            this.trimType = trimType;
        }

        public FieldDefinition clone() {
            try {
                return (FieldDefinition)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

